/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.ExpressionTreeModel;
import com.sas.olapadmin.utilities.MemberTreeNode;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Dimension;
import com.sas.storage.olap.sasmdx.Hierarchy;
import com.sas.storage.olap.sasmdx.Member;
import com.sas.visuals.Resources;
import com.sas.workspace.WorkspaceTree;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ExpressionTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    public ExpressionTreeCellRenderer() {
        this.setLeafIcon(WorkspaceTree.getDefaultLeafIcon());
        this.setOpenIcon(WorkspaceTree.getOpenedFolderIcon());
        this.setClosedIcon(WorkspaceTree.getClosedFolderIcon());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, node, sel, expanded, leaf, row, hasFocus);
        ImageIcon icon = null;
        if (node instanceof ExpressionTreeModel.IdentityNode) {
            ExpressionTreeModel.IdentityNode thisNode = (ExpressionTreeModel.IdentityNode)node;
            icon = thisNode.getImageIcon();
        } else {
            DefaultMutableTreeNode thisNode;
            Object userObject = null;
            if (node instanceof MemberTreeNode) {
                thisNode = (MemberTreeNode)node;
                userObject = ((MemberTreeNode)thisNode).getUserObject();
            } else if (node instanceof DefaultMutableTreeNode) {
                thisNode = (DefaultMutableTreeNode)node;
                userObject = thisNode.getUserObject();
            }
            try {
                if (userObject == null) {
                    icon = null;
                } else if (userObject instanceof Member) {
                    Member mem = (Member)userObject;
                    Dimension d = (Dimension)mem.getDimension();
                    icon = d.getType() == 2 ? (mem.getType() == 4 ? Resources.getImageIcon((String)"Measure_calculated_shared.gif", (int)16) : Resources.getImageIcon((String)"Measure.gif", (int)16)) : (mem.getType() == 4 | mem.getType() == 3 ? Resources.getImageIcon((String)"Measure_calculated_shared.gif", (int)16) : Resources.getImageIcon((String)"OLAPMember.gif", (int)16));
                } else if (userObject instanceof SharedDimension) {
                    icon = Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16);
                } else if (userObject instanceof Dimension) {
                    Dimension dim = (Dimension)userObject;
                    icon = dim.getType() == 2 ? Resources.getImageIcon((String)"MeasureDimension.gif", (int)16) : Resources.getImageIcon((String)"OLAPDimension.gif", (int)16);
                } else if (userObject instanceof Hierarchy || userObject instanceof OLAPHierarchy) {
                    icon = Resources.getImageIcon((String)"OLAPHierarchy.gif", (int)16);
                } else if (userObject instanceof OLAPSharedDimension) {
                    icon = Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16);
                } else if (userObject instanceof OLAPDimension) {
                    icon = Resources.getImageIcon((String)"OLAPDimension.gif", (int)16);
                } else if (userObject instanceof Cube || userObject instanceof OLAPCube) {
                    icon = Resources.getImageIcon((String)"OLAPCube.gif", (int)16);
                }
            }
            catch (OLAPException e) {
                icon = null;
            }
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        return this;
    }
}

