/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class ExportCodeDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ExportCodeDialog.class);
    private StringBuffer codeToSave;
    private String directions;
    private Vector listOfPaths;
    private WAComboBox filePath;
    private JButton browse;

    public ExportCodeDialog(String instructions, StringBuffer code, Vector paths) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("ExportCodeDialog.window.title"), true);
        this.setHelpProduct("shared");
        this.setHelpTopic("security_batch_exportcode");
        this.codeToSave = code;
        this.listOfPaths = paths;
        this.directions = instructions;
        this.setMainPanel(new ExportCodePanel());
    }

    class ExportCodePanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;

        public ExportCodePanel() {
            this._layoutWidgets();
        }

        private void _layoutWidgets() {
            this.setLayout(new GridBagLayout());
            JLabel directionLabel = new JLabel(ExportCodeDialog.this.directions);
            JLabel fileLabel = new JLabel();
            Utilities.setLabelTextAndMnemonic(fileLabel, bundle.getString("ExportCodePanel.File.control.label"));
            if (ExportCodeDialog.this.listOfPaths != null) {
                ExportCodeDialog.this.filePath = new WAComboBox(ExportCodeDialog.this.listOfPaths.toArray());
            } else {
                ExportCodeDialog.this.filePath = new WAComboBox();
            }
            ExportCodeDialog.this.filePath.setPreferredSize(new Dimension(350, 20));
            ExportCodeDialog.this.filePath.setEditable(true);
            if (ExportCodeDialog.this.listOfPaths != null && !ExportCodeDialog.this.listOfPaths.isEmpty()) {
                ExportCodeDialog.this.filePath.setSelectedIndex(0);
            }
            fileLabel.setLabelFor((Component)ExportCodeDialog.this.filePath);
            ExportCodeDialog.this.browse = new JButton();
            Utilities.setButtonTextAndMnemonic(ExportCodeDialog.this.browse, bundle.getString("ExportCodePanel.Browse.action.label"));
            BrowseListener browseListener = new BrowseListener();
            ExportCodeDialog.this.browse.addActionListener(browseListener);
            this.add(directionLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add(fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)ExportCodeDialog.this.filePath, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.add(ExportCodeDialog.this.browse, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            boolean writeOK = false;
            String savePath = ExportCodeDialog.this.filePath.getText();
            if (!ModelUtilities.isBlank((String)savePath)) {
                File storeFileTo = new File(savePath);
                if (storeFileTo.isDirectory()) {
                    MessageUtil.displayMessage((String)bundle.getString("ExportCodePanel.SpecifiedFileIsDirectory.txt"), (String)Utilities.getMessageWindowTitle(), (int)-1);
                } else if (storeFileTo.exists() && !storeFileTo.canWrite()) {
                    MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.NoWriteSpecifiedFile.fmt.txt", (Object)savePath), (int)2);
                } else {
                    boolean isAppend = false;
                    boolean doWrite = true;
                    if (storeFileTo.exists()) {
                        int option = Utilities.displayFileExistsMessage(savePath);
                        if (option != 2) {
                            isAppend = option == 0;
                        } else {
                            doWrite = false;
                        }
                    }
                    if (doWrite) {
                        try {
                            String exportFile = null;
                            String absolutePath = null;
                            exportFile = savePath;
                            File exportPath = new File(savePath);
                            absolutePath = exportPath.getAbsolutePath();
                            FileWriter fileWriter = null;
                            fileWriter = new FileWriter(storeFileTo, isAppend);
                            BufferedWriter writer = new BufferedWriter(fileWriter);
                            writer.write(ExportCodeDialog.this.codeToSave.toString());
                            writer.close();
                            if (exportFile != null) {
                                MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.confirmation.fmt.txt", (Object)absolutePath), (int)1);
                            } else {
                                MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.confirmation.fmt.txt", (Object)savePath), (String)Utilities.getMessageWindowTitle(), (int)1);
                            }
                            writeOK = true;
                            if (ExportCodeDialog.this.listOfPaths != null) {
                                ExportCodeDialog.this.listOfPaths.remove(savePath);
                                ExportCodeDialog.this.listOfPaths.insertElementAt(savePath, 0);
                            } else if (exportFile != null) {
                                MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.confirmation.fmt.txt", (Object)absolutePath), (int)1);
                            }
                        }
                        catch (IOException oError) {
                            ExceptionHandler.handleException(oError);
                            writeOK = false;
                        }
                    }
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ExportCodePanel.BlankName.txt"), (String)Utilities.getMessageWindowTitle(), (int)-1);
            }
            return writeOK;
        }
    }

    class BrowseListener
    implements ActionListener {
        BrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            String currentPath = ExportCodeDialog.this.filePath.getText();
            File currentFile = null;
            if (!ModelUtilities.isBlank((String)currentPath)) {
                currentFile = new File(currentPath);
                if (currentFile.isDirectory()) {
                    fileChooser.setCurrentDirectory(currentFile);
                } else {
                    fileChooser.setSelectedFile(currentFile);
                }
            }
            fileChooser.setDialogTitle(bundle.getString("ExportCodePanel.FileChooser.window.title"));
            fileChooser.setApproveButtonText(bundle.getString("ExportCodePanel.FileChooser.OK.action.label"));
            fileChooser.showDialog((Component)Workspace.getWorkspace(), null);
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile != null) {
                String filename = selectedFile.toString();
                if (ExportCodeDialog.this.listOfPaths == null || ExportCodeDialog.this.listOfPaths != null && ExportCodeDialog.this.listOfPaths.indexOf(filename) < 0) {
                    ExportCodeDialog.this.filePath.insertItemAt((Object)filename, 0);
                }
                ExportCodeDialog.this.filePath.setSelectedIndex(0);
            }
        }
    }
}

