/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.utilities.AbstractHandler;
import com.sas.olapadmin.utilities.GenericHandler;
import com.sas.olapadmin.utilities.Handler;
import com.sas.olapadmin.utilities.MdCauseHandler;
import com.sas.olapadmin.utilities.MessagePanel;
import com.sas.olapadmin.utilities.OLAPCauseHandler;
import com.sas.olapadmin.utilities.StorageOlapCauseHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.storage.olap.OLAPException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsMessagesWindow;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;

public class ExceptionHandler {
    public static final int ERROR = 0;
    public static final int INFORMATION = 1;
    public static final int SEVERE = 12;
    public static final int WARNING = 2;
    private static GenericHandler genericHandler;
    private static OLAPCauseHandler olapHandler;
    private static StorageOlapCauseHandler storageOlapHandler;
    private static MdCauseHandler mdCauseHandler;
    private static Handler thisHandler;
    private static final WAdminResource bundle;

    public static boolean handleException(Exception exception) {
        boolean returnValue = true;
        thisHandler = ExceptionHandler.getState(exception);
        returnValue = thisHandler.showMessage(null, exception);
        thisHandler.updateMessageWindow(exception);
        thisHandler.updateMessageLog(exception);
        return returnValue;
    }

    public static boolean handleException(OLAPException exception) {
        boolean returnValue = true;
        thisHandler = ExceptionHandler.getState((Exception)exception);
        returnValue = thisHandler.showMessage(null, (Exception)exception);
        thisHandler.updateMessageWindow((Exception)exception);
        thisHandler.updateMessageLog((Exception)exception);
        return returnValue;
    }

    public static boolean handleException(Exception exception, String debugMessage) {
        if (Workspace.isDebug()) {
            Workspace.getDefaultLogger().debug((Object)debugMessage);
        }
        return ExceptionHandler.handleException(exception);
    }

    public static boolean handleException(String messageTitle, Exception exception) {
        boolean returnValue = true;
        thisHandler = ExceptionHandler.getState(exception);
        returnValue = thisHandler.showMessage(messageTitle, exception);
        thisHandler.updateMessageWindow(exception);
        thisHandler.updateMessageLog(exception);
        return returnValue;
    }

    public static boolean handleException(String messageTitle, Exception exception, String debugMessage) {
        if (Workspace.isDebug()) {
            Workspace.getDefaultLogger().debug((Object)debugMessage);
        }
        return ExceptionHandler.handleException(messageTitle, exception);
    }

    public static boolean handleException(Exception exception, HashMap inputRetry) {
        boolean returnValue = ExceptionHandler.handleException(exception);
        ExceptionHandler.retry(inputRetry);
        return returnValue;
    }

    private static boolean retry(HashMap inputRetry) {
        boolean retrySuccessful = true;
        return retrySuccessful;
    }

    private static AbstractHandler getGenericHandler() {
        if (genericHandler == null) {
            genericHandler = new GenericHandler();
        }
        return genericHandler;
    }

    private static AbstractHandler getMdHandler() {
        if (mdCauseHandler == null) {
            mdCauseHandler = new MdCauseHandler();
        }
        return mdCauseHandler;
    }

    private static AbstractHandler getOlapHandler() {
        if (olapHandler == null) {
            olapHandler = new OLAPCauseHandler();
        }
        return olapHandler;
    }

    private static AbstractHandler getStorageOlapHandler() {
        if (storageOlapHandler == null) {
            storageOlapHandler = new StorageOlapCauseHandler();
        }
        return storageOlapHandler;
    }

    private static Handler getState(Exception exception) {
        AbstractHandler currentState = exception instanceof OLAPException ? ExceptionHandler.getStorageOlapHandler() : (exception instanceof com.sas.olapadmin.designer.model.OLAPException ? ExceptionHandler.getOlapHandler() : (exception instanceof MdException ? ExceptionHandler.getMdHandler() : (exception instanceof RemoteException ? ExceptionHandler.getMdHandler() : ExceptionHandler.getGenericHandler())));
        return currentState;
    }

    static String getRootCauses(Exception exception) {
        StringBuffer causes = new StringBuffer();
        ArrayList<Exception> getCauses = new ArrayList<Exception>();
        for (Throwable currentException = exception; currentException != null && getCauses.indexOf(currentException) < 0; currentException = currentException.getCause()) {
            String msg = currentException.getLocalizedMessage();
            if (!Utilities.isBlank(msg)) {
                causes.append(msg).append("\n\n");
            }
            getCauses.add((Exception)currentException);
        }
        return causes.toString();
    }

    static boolean showMessage(String messageTitle, Exception exception, String message, int exceptionLevel, int exceptionType) {
        Exception cause = null;
        boolean simpleMessage = true;
        if (Utilities.isBlank(message)) {
            message = exception.getLocalizedMessage();
            if (Utilities.isBlank(message)) {
                message = bundle.getString("ExceptionHandler.GenericError.txt");
            }
            simpleMessage = (cause = (Exception)exception.getCause()) == null;
        } else {
            cause = exception;
            simpleMessage = false;
        }
        String messages = "";
        if (cause != null) {
            messages = ExceptionHandler.getRootCauses(cause);
        }
        if (simpleMessage || Utilities.isBlank(messages)) {
            MessageUtil.displayMessage((String)message, (int)exceptionLevel);
        } else {
            MessagePanel panel = new MessagePanel(messages);
            if (!Utilities.isBlank(messageTitle)) {
                MessageUtil.displayDetailsMessage((String)message, (String)messageTitle, (int)exceptionType, (int)-1, (JComponent)panel);
            } else {
                MessageUtil.displayDetailsMessage((String)message, (int)exceptionType, (int)-1, (JComponent)panel);
            }
        }
        boolean returnValue = exceptionLevel == 2 || exceptionLevel == 1;
        return returnValue;
    }

    static void updateWorkspaceMessage(String mdError) {
        Workspace m_workspace = Workspace.getWorkspace();
        if (m_workspace.getCustomDesktop() != null) {
            WsMessagesWindow messageWindow = m_workspace.getMessagesWindow();
            if (!messageWindow.isShowing()) {
                m_workspace.showMessagesWindow();
            }
            messageWindow.addMessage(mdError);
        }
    }

    static {
        bundle = new WAdminResource(ExceptionHandler.class);
    }
}

