/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.jackrabbit.j2ee.AbstractConfig;
import org.apache.jackrabbit.j2ee.BootstrapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RMIConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(RMIConfig.class);
    private boolean rmiEnabled;
    private int rmiPort = -1;
    private String rmiHost;
    private String rmiName;
    private String rmiUri;
    private final BootstrapConfig parentConfig;

    public RMIConfig(BootstrapConfig parentConfig) {
        this.parentConfig = parentConfig;
    }

    public void init(Properties props) throws ServletException {
        String property = props.getProperty("rmi.name");
        if (property != null) {
            this.setRmiName(property);
        }
        if ((property = props.getProperty("rmi.enabled")) != null) {
            this.setRmiEnabled(property);
        }
        if ((property = props.getProperty("rmi.port")) != null) {
            this.setRmiPort(property);
        }
        if ((property = props.getProperty("rmi.host")) != null) {
            this.setRmiHost(property);
        }
        if ((property = props.getProperty("rmi.uri")) != null) {
            this.setRmiUri(property);
        }
    }

    public void init(ServletConfig ctx) throws ServletException {
        String property = ctx.getInitParameter("rmi-name");
        if (property != null) {
            this.setRmiName(property);
        }
        if ((property = ctx.getInitParameter("rmi-enabled")) != null) {
            this.setRmiEnabled(property);
        }
        if ((property = ctx.getInitParameter("rmi-port")) != null) {
            this.setRmiPort(property);
        }
        if ((property = ctx.getInitParameter("rmi-host")) != null) {
            this.setRmiHost(property);
        }
        if ((property = ctx.getInitParameter("rmi-uri")) != null) {
            this.setRmiUri(property);
        }
        this.rmiEnabled = this.rmiPort >= 0 || this.rmiUri != null;
    }

    public String getRmiName() {
        return this.rmiName;
    }

    public void setRmiName(String rmiName) {
        this.rmiName = rmiName;
    }

    public boolean enabled() {
        return this.rmiEnabled;
    }

    public String getRmiEnabled() {
        return String.valueOf(this.rmiEnabled);
    }

    public void setRmiEnabled(String rmiEnabled) {
        this.rmiEnabled = Boolean.valueOf(rmiEnabled);
    }

    public int rmiPort() {
        return this.rmiPort;
    }

    public String getRmiPort() {
        return String.valueOf(this.rmiPort);
    }

    public void setRmiPort(String rmiPort) {
        this.rmiPort = Integer.decode(rmiPort);
    }

    public String getRmiHost() {
        return this.rmiHost;
    }

    public void setRmiHost(String rmiHost) {
        this.rmiHost = rmiHost;
    }

    public String getRmiUri() {
        return this.rmiUri;
    }

    public void setRmiUri(String rmiUri) {
        this.rmiUri = rmiUri;
    }

    @Override
    public void validate() {
        if (!this.rmiEnabled) {
            return;
        }
        if (this.rmiUri != null && this.rmiUri.length() > 0) {
            try {
                URI uri = new URI(this.rmiUri);
                this.rmiHost = uri.getHost();
                this.rmiPort = uri.getPort();
                this.rmiName = uri.getPath();
            }
            catch (URISyntaxException e) {
                log.warn("Cannot parse RMI URI '" + this.rmiUri + "'.", (Throwable)e);
                this.rmiUri = null;
                this.rmiHost = null;
            }
            if (this.rmiName != null && this.rmiName.startsWith("/")) {
                this.rmiName = this.rmiName.substring(1);
            }
        }
        if (this.rmiPort == -1 || this.rmiPort == 0) {
            this.rmiPort = 1099;
        } else if (this.rmiPort < -1 || this.rmiPort > 65535) {
            log.warn("Invalid port in rmi-port param " + this.rmiPort + ". using default port.");
            this.rmiPort = 1099;
        }
        if (this.rmiHost == null) {
            this.rmiHost = "";
        }
        if (this.rmiName == null || this.rmiName.length() == 0) {
            this.rmiName = this.parentConfig.getRepositoryName();
        }
        this.rmiUri = "//" + this.rmiHost + ":" + this.rmiPort + "/" + this.rmiName;
        this.valid = true;
    }
}

