/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.armreader;

import com.sas.tools.armreader.Messages;
import com.sas.tools.armreader.StringSplitter;
import java.util.HashMap;
import java.util.Map;

public class Transaction {
    private static final StringSplitter dotSplitter = StringSplitter.compile('.');
    private static final int NUM_PLUGINS = 4;
    private static final String[] pluginNames = new String[]{Messages.getString("Transaction.CSPDS"), Messages.getString("Transaction.CSAS"), Messages.getString("Transaction.CACHE"), Messages.getString("Transaction.MOLAP")};
    private double wallTime;
    private double cpuTime;
    private double sysTime;
    private int occurrences;
    private String regionLevels;
    private String aggrLevels;
    private boolean preAggregated;
    private long numRows;
    private long[] plugins;
    private Map regionLevelsMap;
    private Map aggrLevelsMap;

    protected Transaction(String wall, String cpu, String sys) {
        this.wallTime = Transaction.decodeSASTime(wall);
        this.cpuTime = Transaction.decodeSASTime(cpu);
        this.sysTime = Transaction.decodeSASTime(sys);
        this.occurrences = 1;
        this.plugins = new long[4];
    }

    protected void stop(String wall, String cpu, String sys, String rows, String plugin, String regionLevels, String aggrLevels, boolean preAggregated) {
        this.wallTime = Transaction.decodeSASTime(wall) - this.wallTime;
        this.cpuTime = Transaction.decodeSASTime(cpu) - this.cpuTime;
        this.sysTime = Transaction.decodeSASTime(sys) - this.sysTime;
        this.numRows = Long.parseLong(rows);
        this.plugins[Integer.parseInt((String)plugin)] = 1L;
        this.regionLevels = regionLevels;
        this.aggrLevels = aggrLevels;
        this.preAggregated = preAggregated;
    }

    protected void aggregateWith(Transaction transaction) {
        this.wallTime += transaction.getWallTime();
        this.cpuTime += transaction.getCpuTime();
        this.sysTime += transaction.getSysTime();
        this.numRows += transaction.getNumRows();
        this.occurrences += transaction.getOccurrences();
        if (this.preAggregated != transaction.isPreAggregated()) {
            System.err.println(Messages.getString("Transaction.NoMatch"));
        }
        for (int i = 0; i < this.plugins.length; ++i) {
            int n = i;
            this.plugins[n] = this.plugins[n] + transaction.getPlugins()[i];
        }
        this.preAggregated = this.preAggregated && transaction.isPreAggregated();
    }

    public static double decodeSASTime(String sasTime) {
        String[] tokens = dotSplitter.split(sasTime);
        return (double)Integer.parseInt(tokens[0]) + (double)Integer.parseInt(tokens[1]) / 1000000.0;
    }

    public double getCpuTime() {
        return this.cpuTime;
    }

    public double getSysTime() {
        return this.sysTime;
    }

    public double getWallTime() {
        return this.wallTime;
    }

    public String getRegionLevels() {
        return this.regionLevels;
    }

    public String getAggrLevels() {
        return this.aggrLevels;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public boolean isPreAggregated() {
        return this.preAggregated;
    }

    public long getNumRows() {
        return this.numRows;
    }

    private long[] getPlugins() {
        return this.plugins;
    }

    public Map getPluginsMap() {
        HashMap<String, Long> map = new HashMap<String, Long>(this.plugins.length);
        for (int i = 0; i < this.plugins.length; ++i) {
            if (this.plugins[i] == 0L) continue;
            map.put(pluginNames[i], new Long(this.plugins[i]));
        }
        return map;
    }

    protected void setRegionLevelsMap(Map levelsMap) {
        this.regionLevelsMap = levelsMap;
    }

    protected void setAggrLevelsMap(Map levelsMap) {
        this.aggrLevelsMap = levelsMap;
    }

    public Map getRegionLevelsMap() {
        return this.regionLevelsMap;
    }

    public Map getAggrLevelsMap() {
        return this.aggrLevelsMap;
    }
}

