/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.interceptor;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.endpoint.interceptor.DelegatingSmartSoapEndpointInterceptor;

public class SoapActionSmartEndpointInterceptor
extends DelegatingSmartSoapEndpointInterceptor {
    private final String soapAction;

    public SoapActionSmartEndpointInterceptor(EndpointInterceptor delegate, String soapAction) {
        super(delegate);
        Assert.hasLength((String)soapAction, (String)"soapAction can not be empty");
        this.soapAction = soapAction;
    }

    @Override
    protected boolean shouldIntercept(WebServiceMessage request, Object endpoint) {
        if (request instanceof SoapMessage) {
            String soapAction = ((SoapMessage)request).getSoapAction();
            if (StringUtils.hasLength((String)soapAction) && soapAction.charAt(0) == '\"' && soapAction.charAt(soapAction.length() - 1) == '\"') {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            return this.soapAction.equals(soapAction);
        }
        return false;
    }
}

