/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.vendor;

public enum DatabaseVendor {
    SAS("sastkts", false),
    MYSQL("mysql", true),
    MSSQL("sqlserver", true),
    ORACLE("oracle", false),
    DB2("db2", false),
    POSTGRES("postgresql", true),
    HSQLDB("hsqldb", false),
    H2("h2", true),
    TERADATA("teradata", false);

    private final String jdbcProtocol;
    private boolean hasBulkInsert;

    private DatabaseVendor(String jdbcProtocol, boolean hasBulkInsert) {
        this.jdbcProtocol = jdbcProtocol;
        this.hasBulkInsert = hasBulkInsert;
    }

    public boolean hasBulkInsert() {
        return this.hasBulkInsert;
    }

    public String getProtocol() {
        return this.jdbcProtocol;
    }

    public static DatabaseVendor get(String protocol) {
        if (null == protocol) {
            throw new IllegalArgumentException("You must supply a protocol value to retrieve a vendor.");
        }
        for (DatabaseVendor vendor : DatabaseVendor.values()) {
            if (!protocol.equals(vendor.getProtocol())) continue;
            return vendor;
        }
        return null;
    }
}

