/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.mybatis.caches.gemfire;

import com.sas.svcs.data.caches.gemfire.ApplicationContextProvider;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.Region;
import org.apache.ibatis.cache.Cache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public final class GemfireCache
implements Cache {
    private static final Logger LOGGER = LogManager.getLogger(GemfireCache.class);
    private Region<Object, Object> region = null;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private String id;
    private String name;
    private boolean statisticsEnabled;

    public void setId(String id) {
        this.id = id;
    }

    public void setRegion(Region<Object, Object> region) {
        this.region = region;
    }

    public Region<Object, Object> getRegion() {
        return this.region;
    }

    public GemfireCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
        this.name = "GemfireCache{" + this.id + "}";
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (null != applicationContext) {
            String mybatisRegionName;
            String gemfireRegionName = ApplicationContextProvider.getGemfireRegionName();
            Region parentRegion = (Region)applicationContext.getBean(gemfireRegionName);
            Region mybatis_region = parentRegion.getSubregion(mybatisRegionName = ApplicationContextProvider.getServletContext() + "_mybatis_region");
            if (null == mybatis_region) {
                mybatis_region = parentRegion.createSubregion(mybatisRegionName, new AttributesFactory(parentRegion.getAttributes()).create());
            }
            this.region = mybatis_region.getSubregion(id);
            if (null == this.region) {
                AttributesFactory attrFactory = new AttributesFactory(mybatis_region.getAttributes());
                if (LOGGER.isInfoEnabled()) {
                    this.statisticsEnabled = true;
                    attrFactory.setStatisticsEnabled(this.statisticsEnabled);
                }
                this.region = mybatis_region.createSubregion(id, attrFactory.create());
            }
            if (LOGGER.isInfoEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Statistics enabled for region ");
                msg.append(this.region.getName());
                msg.append(": ");
                msg.append(this.statisticsEnabled);
                LOGGER.info(msg.toString());
            }
        } else {
            LOGGER.warn(this.name + " is disabled. No region found!");
        }
    }

    public void clear() {
        if (null != this.region) {
            if (LOGGER.isInfoEnabled()) {
                StringBuilder msg = new StringBuilder(30);
                msg.append(this.name).append(" cleared.");
                LOGGER.info((CharSequence)msg);
            }
            this.region.clear();
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getObject(Object key) {
        Object retVal = null;
        if (null != this.region) {
            StringBuilder msg;
            if (this.region.containsKey((Object)key.hashCode())) {
                if (LOGGER.isInfoEnabled()) {
                    msg = new StringBuilder(50);
                    msg.append(this.name);
                    msg.append(" CacheHit (hashcode=");
                    msg.append(key.hashCode());
                    msg.append(")");
                    LOGGER.info(msg.toString());
                }
                retVal = this.region.get((Object)key.hashCode());
            } else if (LOGGER.isInfoEnabled()) {
                msg = new StringBuilder(50);
                msg.append(this.name);
                msg.append(" CacheMiss (hashcode=");
                msg.append(key.hashCode());
                msg.append(")");
                LOGGER.info(msg.toString());
            }
            if (LOGGER.isInfoEnabled() && this.statisticsEnabled) {
                CacheStatistics statistics = this.region.getStatistics();
                StringBuilder msg2 = new StringBuilder(50);
                msg2.append("Cache Statistics ");
                msg2.append(this.region.getName());
                msg2.append(": HitCount=");
                msg2.append(statistics.getHitCount());
                msg2.append(", MissCount=");
                msg2.append(statistics.getMissCount());
                msg2.append(", HitRatio=");
                msg2.append(statistics.getHitRatio());
                msg2.append(", LastAccessedTime=");
                msg2.append(statistics.getLastAccessedTime());
                msg2.append(", LastModifiedTime=");
                msg2.append(statistics.getLastModifiedTime());
                LOGGER.info((CharSequence)msg2);
            }
        }
        return retVal;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public int getSize() {
        if (null != this.region) {
            return this.region.size();
        }
        return 0;
    }

    public void putObject(Object key, Object value) {
        if (null != this.region) {
            if (LOGGER.isInfoEnabled()) {
                StringBuilder msg = new StringBuilder(50);
                msg.append("Adding Object (hashcode=");
                msg.append(key.hashCode());
                msg.append(") to ");
                msg.append(this.name);
                LOGGER.info(msg.toString());
            }
            this.region.put((Object)key.hashCode(), value);
        }
    }

    public Object removeObject(Object key) {
        if (null != this.region) {
            if (LOGGER.isInfoEnabled()) {
                StringBuilder msg = new StringBuilder(50);
                msg.append("Removing Object (hashcode=");
                msg.append(key.hashCode());
                msg.append(") from ");
                msg.append(this.name);
                LOGGER.info(msg.toString());
            }
            return this.region.remove((Object)key.hashCode());
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)obj;
        return this.id.equals(otherCache.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

