/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.memory;

import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectNotFoundException;
import com.sas.svcs.data.dao.GenericDAOBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MemoryGenericDAO<T extends Identifiable>
extends GenericDAOBase<T> {
    private final HashMap<String, T> objs = new HashMap();

    public HashMap<String, T> getObjectMap() {
        return this.objs;
    }

    @Override
    public T create(T obj) {
        this.firePreCreate(obj);
        obj.setId(this.getIdGenerator().generateId());
        this.objs.put(obj.getId(), obj);
        this.firePostCreate(obj);
        return obj;
    }

    @Override
    public void delete(T obj) throws ObjectNotFoundException {
        this.firePreDelete(obj);
        Identifiable deleted = (Identifiable)this.objs.remove(obj.getId());
        if (deleted == null) {
            throw new ObjectNotFoundException("Object not found: " + obj);
        }
        this.firePostDelete(obj);
    }

    @Override
    public T find(String id) {
        Identifiable ret = (Identifiable)this.objs.get(id);
        this.firePostFind(ret);
        return (T)ret;
    }

    @Override
    public T update(T obj) throws ObjectNotFoundException {
        if (null == this.objs.get(obj.getId())) {
            throw new ObjectNotFoundException("Object not found: " + obj);
        }
        this.firePreUpdate(obj);
        this.objs.put(obj.getId(), obj);
        this.firePostUpdate(obj);
        return obj;
    }

    @Override
    public Collection<T> findAll() {
        ArrayList<T> ret = new ArrayList<T>(this.objs.values());
        this.firePostFind(ret);
        return ret;
    }
}

