/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.jpa;

import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectNotFoundException;
import com.sas.svcs.data.dao.GenericDAOBase;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.List;

public class GenericJPADAO<T extends Identifiable>
extends GenericDAOBase<T> {
    private Class<T> clazz;
    private String findAllQuery;
    private EntityManager entityManager;

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setClass(Class<T> clazz) {
        this.clazz = clazz;
        String clazzName = clazz.getSimpleName();
        this.findAllQuery = "select " + clazzName + " from " + clazzName + " " + clazzName;
    }

    @Override
    public T create(T obj) {
        this.firePreCreate(obj);
        this.entityManager.persist(obj);
        this.firePostCreate(obj);
        return obj;
    }

    @Override
    public void delete(T obj) throws ObjectNotFoundException {
        this.firePreDelete(obj);
        this.entityManager.remove(this.entityManager.getReference(this.clazz, (Object)obj.getId()));
        this.firePostDelete(obj);
    }

    @Override
    public T find(String id) {
        Identifiable ret = (Identifiable)this.entityManager.find(this.clazz, (Object)id);
        this.firePostFind(ret);
        return (T)ret;
    }

    @Override
    public Collection<T> findAll() {
        Query query = this.entityManager.createQuery(this.findAllQuery);
        List ret = query.getResultList();
        this.firePostFind(ret);
        return ret;
    }

    @Override
    public T update(T obj) throws ObjectNotFoundException {
        this.firePreUpdate(obj);
        Identifiable ret = (Identifiable)this.entityManager.merge(obj);
        this.firePostUpdate(obj);
        return (T)ret;
    }
}

