/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.filesystem;

import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectNotFoundException;
import com.sas.svcs.data.dao.GenericDAOBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;

public class FileSystemGenericDAO<T extends Identifiable>
extends GenericDAOBase<T> {
    private static final String SEPARATOR = "---SEP---";
    private File baseDir = new File("/temp");
    private long objectType;

    public FileSystemGenericDAO(long objectType) {
        this.objectType = objectType;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
    }

    public void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    private String getFileName(T obj) {
        return this.getFileName(obj.getId());
    }

    private String getFileName(String id) {
        return id + SEPARATOR + this.objectType;
    }

    @Override
    public T create(T obj) {
        this.firePreCreate(obj);
        String id = this.getIdGenerator().generateId();
        obj.setId(id);
        File newFile = new File(this.baseDir, this.getFileName(obj));
        try {
            newFile.createNewFile();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(newFile));
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Shouldn't get here");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.firePostCreate(obj);
        return obj;
    }

    @Override
    public void delete(T obj) throws ObjectNotFoundException {
        this.firePreDelete(obj);
        File file = new File(this.baseDir, this.getFileName(obj));
        if (!file.exists()) {
            throw new ObjectNotFoundException("Object doesn't exist: " + obj);
        }
        file.delete();
        this.firePostDelete(obj);
    }

    @Override
    public T find(String id) {
        File file = new File(this.baseDir, id);
        Identifiable ret = null;
        if (!file.exists()) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if (!desc.getName().equals(Identifiable.class.getName())) {
                    throw new ClassNotFoundException("Unsupported Class: " + desc.getName());
                }
                return super.resolveClass(desc);
            }
        };){
            ret = (Identifiable)ois.readObject();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Shouldn't get here");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.firePostFind(ret);
        return (T)ret;
    }

    @Override
    public T update(T obj) throws ObjectNotFoundException {
        this.firePreUpdate(obj);
        File file = new File(this.baseDir, this.getFileName(obj));
        if (!file.exists()) {
            throw new ObjectNotFoundException("Object doesn't exist: " + obj);
        }
        file.delete();
        try {
            file.createNewFile();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Shouldn't get here");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.firePostUpdate(obj);
        return obj;
    }

    @Override
    public Collection<T> findAll() {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }
}

