/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire.springframework;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.Scope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.StringUtils;

public class GemfireRegionBean<K, V>
implements FactoryBean<Region<K, V>>,
InitializingBean,
BeanNameAware,
DisposableBean,
SmartLifecycle {
    private static final String ENTRY_EXPIRATION_ACTION_DESTROY = "destroy";
    private static final String ENTRY_EXPIRATION_ACTION_INVALIDATE = "invalidate";
    private static final String ENTRY_EXPIRATION_ACTION_LOCAL_DESTROY = "local_destroy";
    private static final String ENTRY_EXPIRATION_ACTION_LOCAL_INVALIDATE = "local_invalidate";
    private static final Map<String, ExpirationAction> ENTRY_EXPIRATION_ACTION_MAP = new HashMap<String, ExpirationAction>();
    private static final String SCOPE_DISTRIBUTED = "distributed";
    private static final String SCOPE_DISTRIBUTED_NO_ACK = "distributed_no_ack";
    private static final String SCOPE_GLOBAL = "global";
    private static final String SCOPE_LOCAL = "local";
    private static final Map<String, Scope> SCOPE_MAP;
    private boolean close;
    private Cache cache;
    private String name;
    private String beanName;
    private boolean statistics;
    private CacheListener<K, V> cacheListener;
    private Scope scope;
    private int entryTimeToLive;
    private ExpirationAction expirationAction = ExpirationAction.INVALIDATE;
    private DiskStore diskStore;
    private String evictionType;
    private int evictionThreshold;
    private String evictionAction;
    private String isLockGrantor;
    private Region<K, V> region;
    private boolean running;
    private boolean persistent;
    private int initialCapacity;
    private static final Logger LOGGER;
    private boolean ignoreJta;

    public boolean isIgnoreJta() {
        return this.ignoreJta;
    }

    public void setIgnoreJta(boolean ignoreJta) {
        this.ignoreJta = ignoreJta;
    }

    public GemfireRegionBean() {
    }

    public GemfireRegionBean(String regionName, boolean close, boolean statistics, Cache cache, CacheListener<K, V> cacheListener, String scope, int entryTimeToLive, String entryExpirationAction, DiskStore diskStore, String evictionType, int evictionThreshold, String evictionAction, String isLockGrantor) {
        this.name = regionName;
        this.cache = cache;
        this.close = close;
        this.statistics = statistics;
        this.cacheListener = cacheListener;
        if (null != scope && !scope.isEmpty()) {
            this.setScope(scope);
        }
        this.entryTimeToLive = entryTimeToLive;
        if (null != entryExpirationAction && !entryExpirationAction.isEmpty()) {
            this.setEntryExpirationAction(entryExpirationAction);
        }
        this.diskStore = diskStore;
        this.evictionType = evictionType;
        this.evictionThreshold = evictionThreshold;
        this.evictionAction = evictionAction;
        this.isLockGrantor = isLockGrantor;
    }

    public GemfireRegionBean(String regionName, boolean close, boolean statistics, Cache cache) {
        this.name = regionName;
        this.cache = cache;
        this.close = close;
        this.statistics = statistics;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public CacheListener<K, V> getCacheListener() {
        return this.cacheListener;
    }

    public void setCacheListener(CacheListener<K, V> listener) {
        this.cacheListener = listener;
    }

    public DiskStore getDiskStore() {
        return this.diskStore;
    }

    public void setDiskStore(DiskStore diskStore) {
        this.diskStore = diskStore;
    }

    public String getEvictionType() {
        return this.evictionType;
    }

    public void setEvictionType(String evictionType) {
        this.evictionType = evictionType;
    }

    public int getEvictionThreshold() {
        return this.evictionThreshold;
    }

    public void setEvictionThreshold(int evictionThreshold) {
        this.evictionThreshold = evictionThreshold;
    }

    public String getEvictionAction() {
        return this.evictionAction;
    }

    public void setEvictionAction(String evictionAction) {
        this.evictionAction = evictionAction;
    }

    public String getIsLockGrantor() {
        return this.isLockGrantor;
    }

    public void setIsLockGrantor(String isLockGrantor) {
        this.isLockGrantor = isLockGrantor;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int capacity) {
        this.initialCapacity = capacity;
    }

    public void setClose(boolean isClose) {
        this.close = isClose;
    }

    public final void setEntryExpirationAction(String action) {
        String key = null == action ? "" : action.toLowerCase();
        ExpirationAction expAction = ENTRY_EXPIRATION_ACTION_MAP.get(key);
        if (null == expAction) {
            throw new IllegalArgumentException("The entry expiration action must be one of: " + ENTRY_EXPIRATION_ACTION_MAP.keySet().toString());
        }
        this.expirationAction = expAction;
        this.statistics = true;
    }

    public void setEntryTimeToLive(int entryTimeToLiveSeconds) {
        this.entryTimeToLive = entryTimeToLiveSeconds;
    }

    public void setName(String arg0) {
        this.name = arg0;
    }

    public final void setScope(String scope) {
        String key = null == scope ? "" : scope.toLowerCase();
        Scope theScope = SCOPE_MAP.get(key);
        if (null == theScope) {
            throw new IllegalArgumentException("The scope must be one of: " + SCOPE_MAP.keySet().toString());
        }
        this.scope = theScope;
    }

    public void setStatistics(boolean isRegionFactoryStatisticsEnabled) {
        this.statistics = isRegionFactoryStatisticsEnabled;
    }

    public Region<K, V> getRegion() {
        return this.region;
    }

    public void destroy() throws Exception {
        if (this.close && this.region != null && !this.region.getRegionService().isClosed()) {
            this.region.close();
            this.region = null;
        }
    }

    public Region<K, V> getObject() throws Exception {
        return this.region;
    }

    public Class<?> getObjectType() {
        return this.region != null ? this.region.getClass() : Region.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String arg0) {
        this.beanName = arg0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        this.name = !StringUtils.hasText((String)this.name) ? this.beanName : this.name;
        Cache cache = this.cache;
        synchronized (cache) {
            this.region = this.cache.getRegion(this.name);
            if (this.region == null) {
                LOGGER.info("Geode region " + this.name + " does not exist. Creating it now.");
                this.region = this.createRegion(this.cache, this.name);
            } else {
                LOGGER.info("Geode region " + this.name + " already exists. Skipping creation.");
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable arg0) {
        this.stop();
        arg0.run();
    }

    private Region<K, V> createRegion(Cache cache, String regionName) {
        RegionFactory regionFactory = this.cache.createRegionFactory();
        regionFactory.setDataPolicy(this.persistent ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE);
        regionFactory.setScope(Scope.DISTRIBUTED_ACK);
        regionFactory.setStatisticsEnabled(this.statistics);
        regionFactory.setIgnoreJTA(true);
        if (this.diskStore != null) {
            regionFactory.setDiskStoreName(this.diskStore.getName());
        }
        if (this.cacheListener != null) {
            regionFactory.addCacheListener(this.cacheListener);
        }
        regionFactory.setLockGrantor(!StringUtils.isEmpty((Object)this.isLockGrantor) && this.isLockGrantor.equalsIgnoreCase("true"));
        if (null != this.scope) {
            regionFactory.setScope(this.scope);
        }
        if (this.entryTimeToLive > 0) {
            regionFactory.setEntryTimeToLive(new ExpirationAttributes(this.entryTimeToLive, this.expirationAction));
        }
        if (!StringUtils.isEmpty((Object)this.evictionType)) {
            EvictionAction action = EvictionAction.DEFAULT_EVICTION_ACTION;
            if (!StringUtils.isEmpty((Object)this.evictionAction)) {
                action = EvictionAction.parseAction((String)this.evictionAction);
            }
            if (this.evictionType.equals("HEAP_PERCENTAGE")) {
                regionFactory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)action));
            } else if (this.evictionType.equals("MEMORY_SIZE")) {
                if (this.evictionThreshold > 0) {
                    regionFactory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)this.evictionThreshold, null, (EvictionAction)action));
                } else {
                    regionFactory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes(null, (EvictionAction)action));
                }
            } else if (this.evictionThreshold > 0) {
                regionFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)this.evictionThreshold, (EvictionAction)action));
            } else {
                regionFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes());
            }
        }
        if (this.initialCapacity > 0) {
            regionFactory.setInitialCapacity(this.initialCapacity);
        }
        return regionFactory.create(this.name);
    }

    static {
        ENTRY_EXPIRATION_ACTION_MAP.put(ENTRY_EXPIRATION_ACTION_DESTROY, ExpirationAction.DESTROY);
        ENTRY_EXPIRATION_ACTION_MAP.put(ENTRY_EXPIRATION_ACTION_INVALIDATE, ExpirationAction.INVALIDATE);
        ENTRY_EXPIRATION_ACTION_MAP.put(ENTRY_EXPIRATION_ACTION_LOCAL_DESTROY, ExpirationAction.LOCAL_DESTROY);
        ENTRY_EXPIRATION_ACTION_MAP.put(ENTRY_EXPIRATION_ACTION_LOCAL_INVALIDATE, ExpirationAction.LOCAL_INVALIDATE);
        SCOPE_MAP = new HashMap<String, Scope>();
        SCOPE_MAP.put(SCOPE_DISTRIBUTED, Scope.DISTRIBUTED_ACK);
        SCOPE_MAP.put(SCOPE_DISTRIBUTED_NO_ACK, Scope.DISTRIBUTED_NO_ACK);
        SCOPE_MAP.put(SCOPE_GLOBAL, Scope.GLOBAL);
        SCOPE_MAP.put(SCOPE_LOCAL, Scope.LOCAL);
        LOGGER = LogManager.getLogger(GemfireRegionBean.class);
    }
}

