/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire.springframework;

import com.sas.svcs.data.caches.gemfire.springframework.GemfireBeanFactoryLocator;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GemfireCacheBean
implements BeanNameAware,
BeanFactoryAware,
BeanClassLoaderAware,
InitializingBean,
DisposableBean,
FactoryBean<Cache> {
    private static final Logger LOGGER = LogManager.getLogger(GemfireCacheBean.class);
    private Cache cache;
    private boolean close;
    private Properties properties;
    private ClassLoader classLoader;
    private boolean useBeanFactoryLocator = true;
    private String beanName;
    private BeanFactory beanFactory;
    private GemfireBeanFactoryLocator factoryLocator;

    public Cache getCache() {
        return this.cache;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setUseBeanFactoryLocator(boolean useBeanFactoryLocator) {
        this.useBeanFactoryLocator = useBeanFactoryLocator;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void destroy() throws Exception {
        if (this.close) {
            if (this.cache != null && !this.cache.isClosed()) {
                this.cache.close();
            }
            this.cache = null;
        }
        if (this.factoryLocator != null) {
            this.factoryLocator.destroy();
            this.factoryLocator = null;
        }
    }

    public Cache getObject() throws Exception {
        this.initCache();
        return this.cache;
    }

    public Class<? extends Cache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.initCache();
    }

    public void setBeanClassLoader(ClassLoader arg0) {
        this.classLoader = arg0;
    }

    public void setBeanFactory(BeanFactory arg0) throws BeansException {
        this.beanFactory = arg0;
    }

    public void setBeanName(String arg0) {
        this.beanName = arg0;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public GemfireBeanFactoryLocator getBeanFactoryLocator() {
        return this.factoryLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCache() {
        LOGGER.info("Initializing Geode cache...");
        if (this.useBeanFactoryLocator && this.factoryLocator == null) {
            this.factoryLocator = new GemfireBeanFactoryLocator();
            this.factoryLocator.setBeanFactory(this.beanFactory);
            this.factoryLocator.setBeanName(this.beanName);
            this.factoryLocator.afterPropertiesSet();
        }
        Thread th = Thread.currentThread();
        ClassLoader oldTCCL = th.getContextClassLoader();
        try {
            th.setContextClassLoader(this.classLoader);
            try {
                if (this.cache == null) {
                    this.cache = CacheFactory.getAnyInstance();
                }
            }
            catch (CacheClosedException ex) {
                CacheFactory factory = new CacheFactory(this.properties);
                if (this.cache == null) {
                    this.cache = factory.create();
                }
            }
        }
        finally {
            th.setContextClassLoader(oldTCCL);
        }
    }
}

