/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class GemfireLock
implements Lock {
    private static final Logger LOGGER = LogManager.getLogger(GemfireLock.class);
    private String lockName;
    private DistributedLockService lockService;
    private long leaseTime = -1L;

    @Autowired
    public void setLockName(String name) {
        this.lockName = name;
    }

    @Autowired
    public void setLockService(DistributedLockService lockService) {
        this.lockService = lockService;
    }

    public void setLockLeaseTime(long leaseTime) {
        this.leaseTime = leaseTime;
    }

    @Override
    public void lock() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Acquiring lock: " + this.lockName);
        }
        this.lockService.lock((Object)this.lockName, -1L, this.leaseTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Acquired lock: " + this.lockName);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to acquire lock: " + this.lockName);
        }
        return this.lockService.lock((Object)this.lockName, 0L, this.leaseTime);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to acquire lock: " + this.lockName);
        }
        return this.lockService.lock((Object)this.lockName, unit.toMillis(time), this.leaseTime);
    }

    @Override
    public void unlock() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unlocking lock: " + this.lockName);
        }
        this.lockService.unlock((Object)this.lockName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unlocked lock: " + this.lockName);
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Conditions not implemented for GemfireLock.");
    }
}

