/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire;

import com.sas.svcs.data.caches.gemfire.ApplicationContextProvider;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class GemFireBasedMap<K, V>
extends AbstractMap<K, V>
implements BeanNameAware {
    private static final Logger LOGGER = LogManager.getLogger(GemFireBasedMap.class);
    private String _beanName;
    private String _regionName;
    private volatile Region<K, V> _region;

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Region<K, V> region = this.getRegion(true);
        if (region.isDestroyed()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("entrySet() called after region destroyed. Returning RegionDestroyedEntrySet.");
            }
            return new RegionDestroyedEntrySet();
        }
        return region.entrySet();
    }

    @Override
    public V get(Object key) {
        Region<K, V> region = this.getRegion(true);
        if (region.isDestroyed()) {
            LOGGER.debug("get() called after region destroyed. Returning null.");
            return null;
        }
        return (V)region.get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.getRegion(true).put(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.getRegion(true).remove(key);
    }

    public void setBeanName(String beanName) {
        this._beanName = beanName;
    }

    public void setRegionName(String regionName) {
        LOGGER.debug("Setting regionName to " + regionName);
        this._regionName = regionName;
    }

    protected void setRegion(Region<K, V> region) {
        this._region = region;
    }

    protected synchronized Region<K, V> getRegion(boolean create) {
        if (this._region == null && create) {
            ApplicationContext applicationContext;
            String name;
            String string = name = StringUtils.hasText((String)this._regionName) ? this._regionName : this._beanName;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Getting region: " + name);
            }
            if ((applicationContext = ApplicationContextProvider.getApplicationContext()) != null) {
                String parentRegionName = ApplicationContextProvider.getGemfireRegionName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Parent region name: " + parentRegionName);
                }
                Region parentRegion = (Region)applicationContext.getBean(parentRegionName);
                this._region = parentRegion.getSubregion(name);
                if (this._region == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Creating region as subregion of parent.");
                    }
                    this._region = parentRegion.createSubregion(this._regionName, parentRegion.getAttributes());
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Application context not available.");
            }
            if (this._region == null) {
                throw new IllegalStateException("Could not create gemfire region named " + name);
            }
        }
        return this._region;
    }

    private final class RegionDestroyedEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private RegionDestroyedEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new IllegalStateException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return GemFireBasedMap.this.getRegion(true).entrySet().add(entry);
        }
    }
}

