/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire;

import com.sas.svcs.data.caches.gemfire.ApplicationContextProvider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.annotation.AnnotationUtils;

public class CacheableBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LogManager.getLogger(CacheableBeanPostProcessor.class);
    private Cache cache;

    @Autowired
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        boolean debugEnabled = LOGGER.isDebugEnabled();
        if (debugEnabled) {
            LOGGER.debug("Searching for gemfire regions to create for the CacheManager - bean name: " + beanName);
        }
        HashSet classes = new HashSet();
        if (AopUtils.isAopProxy((Object)bean)) {
            classes.addAll(Arrays.asList(AopProxyUtils.proxiedUserInterfaces((Object)bean)));
        } else {
            classes.add(bean.getClass());
        }
        HashSet<String> cacheNames = new HashSet<String>();
        for (Class clazz : classes) {
            this.updateCacheNames((Cacheable)AnnotationUtils.findAnnotation((Class)clazz, Cacheable.class), cacheNames);
            if (debugEnabled) {
                LOGGER.debug("Checking type for Cache annotations: " + clazz.getName());
            }
            this.updateCacheNames((Cacheable)AnnotationUtils.findAnnotation((Class)clazz, Cacheable.class), cacheNames);
            this.updateCacheNames((CacheEvict)AnnotationUtils.findAnnotation((Class)clazz, CacheEvict.class), cacheNames);
            this.updateCacheNames((CachePut)AnnotationUtils.findAnnotation((Class)clazz, CachePut.class), cacheNames);
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (debugEnabled) {
                    LOGGER.debug("Checking method for Cache annotations: " + methods[i].getName());
                }
                this.updateCacheNames((Cacheable)AnnotationUtils.findAnnotation((Method)methods[i], Cacheable.class), cacheNames);
                this.updateCacheNames((CacheEvict)AnnotationUtils.findAnnotation((Method)methods[i], CacheEvict.class), cacheNames);
                this.updateCacheNames((CachePut)AnnotationUtils.findAnnotation((Method)methods[i], CachePut.class), cacheNames);
            }
        }
        if (!cacheNames.isEmpty()) {
            String gemfireRegionName = ApplicationContextProvider.getGemfireRegionName();
            Region region = this.cache.getRegion(gemfireRegionName);
            RegionFactory regionFactory = this.cache.createRegionFactory(region.getAttributes());
            for (String cacheName : cacheNames) {
                if (debugEnabled) {
                    LOGGER.debug("CACHE: " + cacheName);
                }
                if (this.cache.getRegion(cacheName) == null) {
                    if (debugEnabled) {
                        LOGGER.debug("Adding bean for cache: " + cacheName);
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Adding bean for cache: " + cacheName);
                    }
                    try {
                        regionFactory.create(cacheName);
                    }
                    catch (RegionExistsException e) {
                        if (!debugEnabled) continue;
                        LOGGER.debug("Region exists exception", (Throwable)e);
                    }
                    continue;
                }
                if (!debugEnabled) continue;
                LOGGER.debug("Region already existed for cache: " + cacheName);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void updateCacheNames(Cacheable ca, Set<String> cacheNames) {
        if (ca != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found Cacheable annotation");
            }
            cacheNames.addAll(Arrays.asList(ca.value()));
        }
    }

    private void updateCacheNames(CacheEvict cea, Set<String> cacheNames) {
        if (cea != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found CacheEvict annotation");
            }
            cacheNames.addAll(Arrays.asList(cea.value()));
        }
    }

    private void updateCacheNames(CachePut cpa, Set<String> cacheNames) {
        if (cpa != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found CachePut annotation");
            }
            cacheNames.addAll(Arrays.asList(cpa.value()));
        }
    }
}

