/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client.impl;

import com.sas.svcs.workspace.client.GeneralServiceExceptionHolder;
import com.sas.svcs.workspace.client.LanguageEventListenerInterface;
import com.sas.svcs.workspace.client.LanguageGlobalStatementEventListenerInterface;
import com.sas.svcs.workspace.client.LanguageLogEventListenerInterface;
import com.sas.svcs.workspace.client.LanguageServiceInterface;
import com.sas.svcs.workspace.client.RemoteLanguageEventListenerInterface;
import com.sas.svcs.workspace.client.impl.AbstractEventHandler;
import com.sas.svcs.workspace.client.types.LanguageGlobalStatementWorkspaceEvent;
import com.sas.svcs.workspace.client.types.LanguageLogWorkspaceEvent;
import com.sas.svcs.workspace.client.types.LanguageWorkspaceEvent;
import com.sas.svcs.workspace.client.types.ProcLanguageWorkspaceEvent;
import com.sas.svcs.workspace.client.types.RemoteLanguageGlobalStatementWorkspaceEvent;
import com.sas.svcs.workspace.client.types.RemoteLanguageProcWorkspaceEvent;
import com.sas.svcs.workspace.client.types.RemoteLanguageWorkspaceEvent;
import com.sas.svcs.workspace.client.types.SubmitCompleteLanguageWorkspaceEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LanguageEventHandler
extends AbstractEventHandler<LanguageEventListenerInterface, LanguageWorkspaceEvent, LanguageServiceInterface>
implements LanguageEventListenerInterface,
LanguageGlobalStatementEventListenerInterface,
LanguageLogEventListenerInterface,
RemoteLanguageEventListenerInterface {
    private final List<LanguageLogEventListenerInterface> _logListeners = new ArrayList<LanguageLogEventListenerInterface>(5);
    private final List<RemoteLanguageEventListenerInterface> _remoteLanguageListeners = new ArrayList<RemoteLanguageEventListenerInterface>(5);
    private final List<LanguageGlobalStatementEventListenerInterface> _languageGlobalStmtListeners = new ArrayList<LanguageGlobalStatementEventListenerInterface>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLogListener(LanguageLogEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasAdded = false;
        if (listener != null) {
            List<LanguageLogEventListenerInterface> list = this._logListeners;
            synchronized (list) {
                wasAdded = this._logListeners.add(listener);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLogListener(LanguageLogEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasRemoved = false;
        if (listener != null) {
            List<LanguageLogEventListenerInterface> list = this._logListeners;
            synchronized (list) {
                wasRemoved = this._logListeners.remove(listener);
            }
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LanguageLogEventListenerInterface[] getLogListeners() {
        LanguageLogEventListenerInterface[] listeners = null;
        List<LanguageLogEventListenerInterface> list = this._logListeners;
        synchronized (list) {
            listeners = new LanguageLogEventListenerInterface[this._logListeners.size()];
            listeners = this._logListeners.toArray(listeners);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRemoteLanguageListener(RemoteLanguageEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasAdded = false;
        if (listener != null) {
            List<RemoteLanguageEventListenerInterface> list = this._remoteLanguageListeners;
            synchronized (list) {
                wasAdded = this._remoteLanguageListeners.add(listener);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRemoteLanguageListener(RemoteLanguageEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasRemoved = false;
        if (listener != null) {
            List<RemoteLanguageEventListenerInterface> list = this._remoteLanguageListeners;
            synchronized (list) {
                wasRemoved = this._remoteLanguageListeners.remove(listener);
            }
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteLanguageEventListenerInterface[] getRemoteLanguageListeners() {
        RemoteLanguageEventListenerInterface[] listeners = null;
        List<RemoteLanguageEventListenerInterface> list = this._remoteLanguageListeners;
        synchronized (list) {
            listeners = new RemoteLanguageEventListenerInterface[this._remoteLanguageListeners.size()];
            listeners = this._remoteLanguageListeners.toArray(listeners);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLanguageGlobalStatementListener(LanguageGlobalStatementEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasAdded = false;
        if (listener != null) {
            List<LanguageGlobalStatementEventListenerInterface> list = this._languageGlobalStmtListeners;
            synchronized (list) {
                wasAdded = this._languageGlobalStmtListeners.add(listener);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLanguageGlobalStatementListener(LanguageGlobalStatementEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasRemoved = false;
        if (listener != null) {
            List<LanguageGlobalStatementEventListenerInterface> list = this._languageGlobalStmtListeners;
            synchronized (list) {
                wasRemoved = this._languageGlobalStmtListeners.remove(listener);
            }
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LanguageGlobalStatementEventListenerInterface[] getLanguageGlobalStatementListeners() {
        LanguageGlobalStatementEventListenerInterface[] listeners = null;
        List<LanguageGlobalStatementEventListenerInterface> list = this._languageGlobalStmtListeners;
        synchronized (list) {
            listeners = new LanguageGlobalStatementEventListenerInterface[this._languageGlobalStmtListeners.size()];
            listeners = this._languageGlobalStmtListeners.toArray(listeners);
        }
        return listeners;
    }

    @Override
    public void handleEvents(List<LanguageWorkspaceEvent> events) {
        for (LanguageWorkspaceEvent event : events) {
            switch (event.getType()) {
                case DATASTEP_COMPLETE: {
                    this.datastepComplete(event);
                    break;
                }
                case DATASTEP_START: {
                    this.datastepStart(event);
                    break;
                }
                case STEP_ERROR: {
                    this.stepError(event);
                    break;
                }
                case PROC_START: {
                    this.procStart((ProcLanguageWorkspaceEvent)event);
                    break;
                }
                case PROC_COMPLETE: {
                    this.procComplete((ProcLanguageWorkspaceEvent)event);
                    break;
                }
                case SUBMIT_COMPLETE: {
                    this.submitComplete((SubmitCompleteLanguageWorkspaceEvent)event);
                    break;
                }
                case ABORT_LIST_LINES: {
                    this.abortListLines((LanguageLogWorkspaceEvent)event);
                    break;
                }
                case ABORT_LOG_LINES: {
                    this.abortLogLines((LanguageLogWorkspaceEvent)event);
                    break;
                }
                case STEP_LIST_LINES: {
                    this.stepListLines((LanguageLogWorkspaceEvent)event);
                    break;
                }
                case STEP_LOG_LINES: {
                    this.stepLogLines((LanguageLogWorkspaceEvent)event);
                    break;
                }
                case REMOTE_DATASTEP_COMPLETE: {
                    this.remoteDatastepComplete((RemoteLanguageWorkspaceEvent)event);
                    break;
                }
                case REMOTE_DATASTEP_START: {
                    this.remoteDatastepStart((RemoteLanguageWorkspaceEvent)event);
                    break;
                }
                case REMOTE_PROC_COMPLETE: {
                    this.remoteProcComplete((RemoteLanguageProcWorkspaceEvent)event);
                    break;
                }
                case REMOTE_PROC_START: {
                    this.remoteProcStart((RemoteLanguageProcWorkspaceEvent)event);
                    break;
                }
                case REMOTE_STEP_ERROR: {
                    this.remoteStepError((RemoteLanguageWorkspaceEvent)event);
                    break;
                }
                case REMOTE_GLOBALSTMT_COMPLETE: {
                    this.remoteGlobalStatementComplete((RemoteLanguageGlobalStatementWorkspaceEvent)event);
                    break;
                }
                case REMOTE_GLOBALSTMT_ERROR: {
                    this.remoteGlobalStatementError((RemoteLanguageGlobalStatementWorkspaceEvent)event);
                    break;
                }
                case GLOBALSTMT_COMPLETE: {
                    this.globalStatementComplete((LanguageGlobalStatementWorkspaceEvent)event);
                    break;
                }
                case GLOBALSTMT_ERROR: {
                    this.globalStatementError((LanguageGlobalStatementWorkspaceEvent)event);
                    break;
                }
            }
        }
    }

    @Override
    public List<LanguageWorkspaceEvent> getEvents() {
        List<LanguageWorkspaceEvent> events = null;
        if (!this.isDestroyed() && null != this._service) {
            try {
                events = ((LanguageServiceInterface)this._service).getLanguageEvents().getListOfEvents();
            }
            catch (GeneralServiceExceptionHolder e) {
                events = Collections.emptyList();
            }
        }
        if (events == null) {
            events = Collections.emptyList();
        }
        return events;
    }

    @Override
    public void datastepComplete(LanguageWorkspaceEvent event) {
        for (LanguageEventListenerInterface listener : this.getListeners()) {
            listener.datastepComplete(event);
        }
    }

    @Override
    public void datastepStart(LanguageWorkspaceEvent event) {
        for (LanguageEventListenerInterface listener : this.getListeners()) {
            listener.datastepStart(event);
        }
    }

    @Override
    public void stepError(LanguageWorkspaceEvent event) {
        for (LanguageEventListenerInterface listener : this.getListeners()) {
            listener.stepError(event);
        }
    }

    @Override
    public void procComplete(ProcLanguageWorkspaceEvent event) {
        for (LanguageEventListenerInterface listener : this.getListeners()) {
            listener.procComplete(event);
        }
    }

    @Override
    public void procStart(ProcLanguageWorkspaceEvent event) {
        for (LanguageEventListenerInterface listener : this.getListeners()) {
            listener.procStart(event);
        }
    }

    @Override
    public void submitComplete(SubmitCompleteLanguageWorkspaceEvent event) {
        for (LanguageEventListenerInterface listener : this.getListeners()) {
            listener.submitComplete(event);
        }
    }

    @Override
    public void globalStatementError(LanguageGlobalStatementWorkspaceEvent event) {
        for (LanguageGlobalStatementEventListenerInterface listener : this.getLanguageGlobalStatementListeners()) {
            listener.globalStatementError(event);
        }
    }

    @Override
    public void globalStatementComplete(LanguageGlobalStatementWorkspaceEvent event) {
        for (LanguageGlobalStatementEventListenerInterface listener : this.getLanguageGlobalStatementListeners()) {
            listener.globalStatementComplete(event);
        }
    }

    @Override
    public void abortListLines(LanguageLogWorkspaceEvent event) {
        for (LanguageLogEventListenerInterface listener : this.getLogListeners()) {
            listener.abortListLines(event);
        }
    }

    @Override
    public void abortLogLines(LanguageLogWorkspaceEvent event) {
        for (LanguageLogEventListenerInterface listener : this.getLogListeners()) {
            listener.abortLogLines(event);
        }
    }

    @Override
    public void stepLogLines(LanguageLogWorkspaceEvent event) {
        for (LanguageLogEventListenerInterface listener : this.getLogListeners()) {
            listener.stepLogLines(event);
        }
    }

    @Override
    public void stepListLines(LanguageLogWorkspaceEvent event) {
        for (LanguageLogEventListenerInterface listener : this.getLogListeners()) {
            listener.stepListLines(event);
        }
    }

    @Override
    public void remoteProcComplete(RemoteLanguageProcWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteProcComplete(event);
        }
    }

    @Override
    public void remoteProcStart(RemoteLanguageProcWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteProcStart(event);
        }
    }

    @Override
    public void remoteDatastepComplete(RemoteLanguageWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteDatastepComplete(event);
        }
    }

    @Override
    public void remoteDatastepStart(RemoteLanguageWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteDatastepStart(event);
        }
    }

    @Override
    public void remoteStepError(RemoteLanguageWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteStepError(event);
        }
    }

    @Override
    public void remoteGlobalStatementError(RemoteLanguageGlobalStatementWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteGlobalStatementError(event);
        }
    }

    @Override
    public void remoteGlobalStatementComplete(RemoteLanguageGlobalStatementWorkspaceEvent event) {
        for (RemoteLanguageEventListenerInterface listener : this.getRemoteLanguageListeners()) {
            listener.remoteGlobalStatementComplete(event);
        }
    }
}

