/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client;

import com.sas.svcs.workspace.client.types.LanguageEventEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class LanguageEventEnums {
    private static final Set<LanguageEventEnum> LANGUAGE_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<LanguageEventEnum>(Arrays.asList(LanguageEventEnum.DATASTEP_COMPLETE, LanguageEventEnum.DATASTEP_START, LanguageEventEnum.PROC_COMPLETE, LanguageEventEnum.PROC_START, LanguageEventEnum.STEP_ERROR, LanguageEventEnum.SUBMIT_COMPLETE)));
    private static final Set<LanguageEventEnum> LANGUAGE_1_1_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<LanguageEventEnum>(Arrays.asList(LanguageEventEnum.GLOBALSTMT_COMPLETE, LanguageEventEnum.GLOBALSTMT_ERROR)));
    private static final Set<LanguageEventEnum> LANGUAGE_LOG_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<LanguageEventEnum>(Arrays.asList(LanguageEventEnum.ABORT_LIST_LINES, LanguageEventEnum.ABORT_LOG_LINES, LanguageEventEnum.STEP_LIST_LINES, LanguageEventEnum.STEP_LOG_LINES)));
    private static final Set<LanguageEventEnum> REMOTE_LANGUAGE_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<LanguageEventEnum>(Arrays.asList(LanguageEventEnum.REMOTE_DATASTEP_COMPLETE, LanguageEventEnum.REMOTE_DATASTEP_START, LanguageEventEnum.REMOTE_GLOBALSTMT_COMPLETE, LanguageEventEnum.REMOTE_GLOBALSTMT_ERROR, LanguageEventEnum.REMOTE_PROC_COMPLETE, LanguageEventEnum.REMOTE_PROC_START, LanguageEventEnum.REMOTE_STEP_ERROR)));

    private LanguageEventEnums() {
    }

    public static Set<LanguageEventEnum> getLanguageEventTypes() {
        return LANGUAGE_EVENT_TYPES;
    }

    public static Set<LanguageEventEnum> getLanguage_1_1_EventTypes() {
        return LANGUAGE_1_1_EVENT_TYPES;
    }

    public static Set<LanguageEventEnum> getLanguageLogEventTypes() {
        return LANGUAGE_LOG_EVENT_TYPES;
    }

    public static Set<LanguageEventEnum> getRemoteLanguageEventTypes() {
        return REMOTE_LANGUAGE_EVENT_TYPES;
    }

    public static boolean containsLanguageEventType(Collection<LanguageEventEnum> eventTypes) {
        return LanguageEventEnums.containsEventType(eventTypes, LANGUAGE_EVENT_TYPES);
    }

    public static boolean containsLanguage_1_1_EventType(Collection<LanguageEventEnum> eventTypes) {
        return LanguageEventEnums.containsEventType(eventTypes, LANGUAGE_1_1_EVENT_TYPES);
    }

    public static boolean containsLanguageLogEventType(Collection<LanguageEventEnum> eventTypes) {
        return LanguageEventEnums.containsEventType(eventTypes, LANGUAGE_LOG_EVENT_TYPES);
    }

    public static boolean containsRemoteLanguageEventType(Collection<LanguageEventEnum> eventTypes) {
        return LanguageEventEnums.containsEventType(eventTypes, REMOTE_LANGUAGE_EVENT_TYPES);
    }

    private static boolean containsEventType(Collection<LanguageEventEnum> eventTypes, Set<LanguageEventEnum> eventTypes2) {
        boolean hasEvent = false;
        if (null != eventTypes) {
            for (LanguageEventEnum eventType : eventTypes2) {
                if (!eventTypes.contains((Object)eventType)) continue;
                hasEvent = true;
                break;
            }
        }
        return hasEvent;
    }
}

