/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.events.client.senders;

import com.sas.svcs.aop.cache.CacheClearMessage;
import com.sas.svcs.events.client.senders.EventSenderInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheClearingEventSender {
    private static final Logger logger = LogManager.getLogger(CacheClearingEventSender.class);
    protected EventSenderInterface eventSender;
    protected String cacheName;

    public CacheClearingEventSender(EventSenderInterface eventSender, String cacheName) {
        if (null == eventSender || null == cacheName) {
            throw new NullPointerException("eventSender and cacheName cannot be null");
        }
        this.eventSender = eventSender;
        this.cacheName = cacheName;
        if (logger.isDebugEnabled()) {
            logger.debug("Configured CacheClearingEventSender for cache '" + cacheName + "' with event sender type " + eventSender.getClass().getName());
        }
    }

    public void clearCache() {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending cache clear message for cache '" + this.cacheName + "'");
        }
        CacheClearMessage message = new CacheClearMessage(this.cacheName);
        this.eventSender.send(message);
        if (logger.isDebugEnabled()) {
            logger.debug("Sent cache clear message for cache '" + this.cacheName + "'");
        }
    }
}

