/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.events.client.messages;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class InternalEvent
extends ApplicationEvent {
    private static final long serialVersionUID = 1L;
    private Object message;
    private SecurityContext securityContext = null;
    private boolean requiresSynchronous = false;

    public InternalEvent(Object message) {
        super((Object)InternalEvent.getComponentName());
        this.message = message;
        this.securityContext = SecurityContextHolder.getContext();
        if (null == this.securityContext.getAuthentication()) {
            this.securityContext = null;
            SecurityContextHolder.clearContext();
        }
    }

    public InternalEvent(Object message, boolean synchronous) {
        this(message);
        this.requiresSynchronous = synchronous;
    }

    public Object getMessage() {
        return this.message;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public boolean requiresSynchronous() {
        return this.requiresSynchronous;
    }

    private static String getComponentName() {
        String applicationName = ClientApplicationNameHolder.getName();
        return applicationName == null ? "SAS Application Infrastructure" : applicationName;
    }
}

