/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.events.client.adapters;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.svcs.events.client.messages.InternalEvent;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ObjectUtils;

public class ApplicationEventAdapter
implements ApplicationListener,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(ApplicationEventAdapter.class);
    private String handlerMethodName = "handleEvent";
    private Object delegate;

    public void setHandlerMethodName(String methodName) {
        this.handlerMethodName = methodName;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.delegate) {
            throw new IllegalStateException("You must provide a 'delegate' property for an ApplicationEventAdapter.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onApplicationEvent(ApplicationEvent event) {
        Object message = event;
        SecurityContext existingSecurityContext = null;
        try {
            if (event instanceof InternalEvent) {
                SecurityContext securityContext;
                InternalEvent ie = (InternalEvent)event;
                ClientApplicationNameHolder.setName((String)event.getSource().toString());
                existingSecurityContext = SecurityContextHolder.getContext();
                if (null == existingSecurityContext.getAuthentication()) {
                    SecurityContextHolder.clearContext();
                    existingSecurityContext = null;
                }
                if (null != (securityContext = ie.getSecurityContext())) {
                    SecurityContextHolder.setContext((SecurityContext)securityContext);
                }
                message = ie.getMessage();
            }
            ArgumentConvertingMethodInvoker invoker = new ArgumentConvertingMethodInvoker();
            invoker.setTargetObject(this.delegate);
            invoker.setTargetMethod(this.handlerMethodName);
            invoker.setArguments(new Object[]{message});
            invoker.prepare();
            invoker.invoke();
        }
        catch (InvocationTargetException ex) {
            logger.error("Handler method '" + this.handlerMethodName + "' for delegate class '" + this.delegate.getClass().getName() + "' threw exception", ex.getTargetException());
            ClientApplicationNameHolder.clear();
            if (event instanceof InternalEvent) {
                if (null != existingSecurityContext) {
                    SecurityContextHolder.setContext((SecurityContext)existingSecurityContext);
                } else {
                    SecurityContextHolder.clearContext();
                }
            }
        }
        catch (Throwable ex2) {
            logger.error("Failed to invoke target method '" + this.handlerMethodName + "' with arguments '" + ObjectUtils.nullSafeToString((Object)message) + "' for delegate class '" + this.delegate.getClass().getName(), ex2);
            {
                catch (Throwable throwable) {
                    ClientApplicationNameHolder.clear();
                    if (event instanceof InternalEvent) {
                        if (null != existingSecurityContext) {
                            SecurityContextHolder.setContext(existingSecurityContext);
                        } else {
                            SecurityContextHolder.clearContext();
                        }
                    }
                    throw throwable;
                }
            }
            ClientApplicationNameHolder.clear();
            if (event instanceof InternalEvent) {
                if (null != existingSecurityContext) {
                    SecurityContextHolder.setContext((SecurityContext)existingSecurityContext);
                } else {
                    SecurityContextHolder.clearContext();
                }
            }
        }
        ClientApplicationNameHolder.clear();
        if (event instanceof InternalEvent) {
            if (null != existingSecurityContext) {
                SecurityContextHolder.setContext((SecurityContext)existingSecurityContext);
            } else {
                SecurityContextHolder.clearContext();
            }
        }
    }
}

