/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.RB;
import com.sas.text.Message;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.ResourceBundle;

@SASScope
final class SocketFactoryConfig {
    private int _port = 0;
    private RMIClientSocketFactory _rmiClientSocketFactory;
    private RMIServerSocketFactory _rmiServerSocketFactory;

    SocketFactoryConfig(int port, RMIClientSocketFactory rmiClientSocketFactory, RMIServerSocketFactory rmiServerSocketFactory) {
        this.setPort(port);
        this.setRMIClientSocketFactory(rmiClientSocketFactory);
        this.setRMIServerSocketFactory(rmiServerSocketFactory);
    }

    int getPort() {
        return this._port;
    }

    void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIServerSocketFactory.invalidPort.ex.fmt.txt", (Object)port));
        }
        this._port = port;
    }

    RMIClientSocketFactory getRMIClientSocketFactory() {
        return this._rmiClientSocketFactory;
    }

    void setRMIClientSocketFactory(RMIClientSocketFactory rmiClientSocketFactory) {
        this._rmiClientSocketFactory = rmiClientSocketFactory;
    }

    RMIServerSocketFactory getRMIServerSocketFactory() {
        return this._rmiServerSocketFactory;
    }

    void setRMIServerSocketFactory(RMIServerSocketFactory rmiServerSocketFactory) {
        this._rmiServerSocketFactory = rmiServerSocketFactory;
    }
}

