/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.RMIExportConfiguration;
import com.sas.net.ssl.RB;
import com.sas.net.ssl.SSLRMIConfiguration;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class SSLRMISocketFactories
implements RMIExportConfiguration {
    private static final SSLRMISocketFactories SSL_RMI_SOCKET_FACTORIES = new SSLRMISocketFactories();
    private SSLRMIConfiguration _sslRMIConfiguration = new SSLRMIConfiguration();

    private SSLRMISocketFactories() {
    }

    public static SSLRMISocketFactories getInstance() {
        return SSL_RMI_SOCKET_FACTORIES;
    }

    public static boolean isJSSEAvailable() {
        boolean isJSSEAvailable = true;
        try {
            KeyManagerFactory.getDefaultAlgorithm();
        }
        catch (NoClassDefFoundError e) {
            isJSSEAvailable = false;
        }
        return isJSSEAvailable;
    }

    public SSLRMIConfiguration getConfiguration() {
        return this._sslRMIConfiguration;
    }

    public void setConfiguration(SSLRMIConfiguration sslRMIConfiguration) throws IllegalArgumentException {
        if (null == sslRMIConfiguration) {
            throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.mustSpecifyConfiguration.ex.txt"));
        }
        this._sslRMIConfiguration = sslRMIConfiguration;
    }

    @Override
    public RMIClientSocketFactory getRMIClientSocketFactory() {
        return this._sslRMIConfiguration.getRMIClientSocketFactory();
    }

    @Override
    public RMIClientSocketFactory getRMIClientSocketFactoryForClass(Class javaClass) throws IllegalArgumentException {
        return this._sslRMIConfiguration.getRMIClientSocketFactoryForClass(javaClass);
    }

    @Override
    public RMIServerSocketFactory getRMIServerSocketFactory() {
        return this._sslRMIConfiguration.getRMIServerSocketFactory();
    }

    @Override
    public RMIServerSocketFactory getRMIServerSocketFactoryForClass(Class javaClass) throws IllegalArgumentException {
        return this._sslRMIConfiguration.getRMIServerSocketFactoryForClass(javaClass);
    }

    @Override
    public int getPortForClass(int requestedPort, Class javaClass) {
        return this._sslRMIConfiguration.getPortForClass(requestedPort, javaClass);
    }
}

