/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl;

import MITI.MIRException;
import MITI.bridges.profiles.MIRProfileId;
import MITI.bridges.profiles.ProfileIds;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.sdk.profiles.ProfiledAttribute;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.SimpleAttributeComparator;
import MITI.sdk.profiles.SimpleLinkComparator;
import MITI.sdk.profiles.impl.DataProvider;
import MITI.sdk.profiles.impl.ProfileCollection;
import MITI.sdk.profiles.impl.memory.MemoryDataProvider;
import MITI.sdk.util.MIRSdkUtil;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.LinkedObject;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.ProfiledObjectDefinition;
import MITI.util.StringUtil;
import MITI.util.XmlUtil;
import MITI.util.config.MimbConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MIRProfiler {
    public static final String DEFAULT_PROFILE_NAME = "Meta Integration";
    public static final String MITI_PROFILE_ORIGINAL_NAME = "Meta Integration Original";
    private static final String MITI_PROFILE_REPOSITORY = "Repository";
    private static final String MITI_PROFILE_SEMANTIC_MAPPING = "Meta Integration Semantic Mapping";
    private static ProfileCollection profiles = new ProfileCollection();
    private static AttributeIdentifier DEFAULT_NAME_ATTRIBUTE = new AttributeIdentifier(174);
    private DataProvider dataProvider = null;

    public static boolean isMetaIntegrationProfile(String string) {
        return string.equals(DEFAULT_PROFILE_NAME) || string.equals(MITI_PROFILE_ORIGINAL_NAME) || string.equals(MITI_PROFILE_SEMANTIC_MAPPING) || string.equals(MITI_PROFILE_REPOSITORY) || string.equals("SAP BusinessObjects Metadata Manager");
    }

    public static void loadProfiles() {
        final ProfileCollection profileCollection = new ProfileCollection();
        File file = new File(MimbConfiguration.getMimbHome(), "conf/MIRProfiles/profiles");
        if (!file.exists()) {
            throw new IllegalStateException(PRFLR.PROFILE_DIRECTORY_NOT_FOUND.getMessage(file.getAbsolutePath()));
        }
        try {
            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (path.getFileName().toString().endsWith(".xml")) {
                        profileCollection.addProfile(MIRProfile.load(Files.newInputStream(path, StandardOpenOption.READ)));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            throw new IllegalStateException(PRFLR.PROFILE_DIRECTORY_NOT_FOUND.getMessage(file.getAbsolutePath()), iOException);
        }
        profiles = profileCollection;
    }

    public static void loadProfiles(File file) throws MIRException {
        if (file.isDirectory()) {
            if (!"include".equalsIgnoreCase(file.getName())) {
                for (File file2 : file.listFiles()) {
                    MIRProfiler.loadProfiles(file2);
                }
            }
        } else if (file.isFile() && file.getName().toLowerCase().endsWith(".xml")) {
            profiles.addProfile(MIRProfile.load(file));
        }
    }

    public static String loadProfile(int n) throws MIRException {
        String string = null;
        File file = new File(MimbConfiguration.getMimbHome(), "conf/MIRProfiles/ids/profileIds.xml");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            for (Element element : XmlUtil.getChildElements(document.getDocumentElement(), "Profile")) {
                if (!String.valueOf(n).equals(element.getAttribute("id"))) continue;
                string = element.getAttribute("name");
                break;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new MIRException(exception.getMessage(), exception);
        }
        if (string != null) {
            MIRProfiler.loadProfile(string);
        }
        return string;
    }

    public static void loadProfile(String string) throws MIRException {
        String string2 = string.replace(" (", "/").replace(")", "") + ".xml";
        File file = new File(MimbConfiguration.getMimbHome(), "conf/MIRProfiles/profiles/" + string2);
        MIRProfiler.loadProfiles(file);
    }

    public static int getProfileId(String string) throws MIRException {
        MIRProfile mIRProfile = profiles.getProfile(string);
        if (mIRProfile != null) {
            return mIRProfile.getProfileId();
        }
        return ProfileIds.META_INTEGRATION;
    }

    public static String[] getProfileNames() {
        return profiles.getProfileNames();
    }

    public static MIRProfile getProfile(String string) {
        MIRProfile mIRProfile = profiles.getProfile(string);
        if (mIRProfile == null) {
            mIRProfile = profiles.getProfile(DEFAULT_PROFILE_NAME);
        }
        if (mIRProfile == null) {
            throw new IllegalStateException(PRFLR.PROFILE_NOT_FOUND.getMessage(string));
        }
        if (mIRProfile.isErrorsInProfile()) {
            System.err.println("Failed to load profile " + string);
            return null;
        }
        return mIRProfile;
    }

    public static boolean existsProfile(String string) {
        MIRProfile mIRProfile = profiles.getProfile(string);
        return mIRProfile != null;
    }

    public MIRProfiler(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public ProfiledAttribute[] get(ObjectDefinition objectDefinition, String string) throws MIRException {
        Map<ProfiledObject, ProfiledAttribute[]> map = this.get(new ObjectDefinition[]{objectDefinition}, string, true);
        if (map == null || map.size() != 1) {
            return null;
        }
        return map.values().iterator().next();
    }

    public Map<ProfiledObject, ProfiledAttribute[]> shallowGet(ObjectDefinition[] objectDefinitionArray, String string) throws MIRException {
        return this.get(objectDefinitionArray, string, false);
    }

    public Map<ProfiledObject, ProfiledAttribute[]> get(ObjectDefinition[] objectDefinitionArray, String string) throws MIRException {
        return this.get(objectDefinitionArray, string, true);
    }

    public ProfiledObject getObject(ObjectDefinition objectDefinition, String string) throws MIRException {
        if (objectDefinition == null) {
            return null;
        }
        Map<ProfiledObject, ProfiledAttribute[]> map = this.get(new ObjectDefinition[]{objectDefinition}, string, false);
        if (map == null || map.size() != 1) {
            return null;
        }
        return map.keySet().iterator().next();
    }

    public Set<ProfiledObject> list(ObjectDefinition objectDefinition, String string) throws MIRException {
        String string2 = this.getGroupName(objectDefinition);
        if (string2 != null) {
            return this.listGroup(objectDefinition, string2, string, false);
        }
        return this.listEntity(objectDefinition, string);
    }

    private String getGroupName(ObjectDefinition objectDefinition) {
        if (objectDefinition instanceof ProfiledObjectDefinition) {
            return ((ProfiledObjectDefinition)objectDefinition).getGroupName();
        }
        return null;
    }

    private Set<ProfiledObject> listGroup(ObjectDefinition objectDefinition, String string, String string2, boolean bl) throws MIRException {
        MIRProfile mIRProfile = MIRProfiler.getProfile(string2);
        if (mIRProfile == null) {
            return null;
        }
        MIRProfileEntity mIRProfileEntity = this.getProfileEntityByObjId(mIRProfile, objectDefinition);
        if (mIRProfileEntity == null) {
            return null;
        }
        HashMap<String, MIRProfileGroup> hashMap = mIRProfileEntity.getGroups();
        if (hashMap == null) {
            return null;
        }
        MIRProfileGroup mIRProfileGroup = hashMap.get(string);
        if (mIRProfileGroup == null) {
            return null;
        }
        TreeSet<ProfiledObject> treeSet = new TreeSet<ProfiledObject>(new SimpleLinkComparator());
        ObjectDefinition objectDefinition2 = new ObjectDefinition(objectDefinition);
        MIRProfileLink[] mIRProfileLinkArray = mIRProfileGroup.getProfileLinks();
        if (mIRProfileLinkArray != null) {
            this.listLinks(objectDefinition2, mIRProfile, mIRProfileLinkArray, treeSet, bl);
        }
        return treeSet;
    }

    public ProfiledObject[] getObjectPath(ObjectDefinition objectDefinition, String string) throws MIRException {
        ObjectDefinition objectDefinition2 = this.dataProvider.getRoot(objectDefinition);
        return this.getObjectPath(objectDefinition, objectDefinition2, string);
    }

    public ProfiledObject[] getObjectPath(ObjectDefinition objectDefinition, ObjectIdentifier objectIdentifier, String string) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition;
        MIRProfile mIRProfile = MIRProfiler.getProfile(string);
        if (mIRProfile == null) {
            return null;
        }
        Stack<ProfiledObject> stack = new Stack<ProfiledObject>();
        ProfiledObjectDefinition profiledObjectDefinition2 = objectDefinition instanceof ProfiledObjectDefinition ? new ProfiledObjectDefinition((ProfiledObjectDefinition)objectDefinition) : new ProfiledObjectDefinition(objectDefinition);
        if (!this.computeParentPath(profiledObjectDefinition2, profiledObjectDefinition = new ProfiledObjectDefinition(objectIdentifier, this.dataProvider.getObjectType(objectIdentifier)), mIRProfile, stack)) {
            return null;
        }
        if (!objectIdentifier.equals(stack.peek().getObjectDefinition())) {
            return null;
        }
        int n = stack.size();
        ProfiledObject[] profiledObjectArray = new ProfiledObject[n];
        for (int i = 0; i < n; ++i) {
            profiledObjectArray[i] = stack.pop();
        }
        return profiledObjectArray;
    }

    private boolean computeParentPath(ProfiledObjectDefinition profiledObjectDefinition, ProfiledObjectDefinition profiledObjectDefinition2, MIRProfile mIRProfile, List<ProfiledObject> list) throws MIRException {
        List<ProfiledObjectDefinition> list2;
        MIRProfileEntity mIRProfileEntity = this.getProfileEntityByObjId(mIRProfile, profiledObjectDefinition);
        if (mIRProfileEntity == null) {
            return false;
        }
        ProfiledObject profiledObject = null;
        String string = this.getGroupName(profiledObjectDefinition);
        if (string != null) {
            List<ProfiledObjectDefinition> list3 = list2 = mIRProfileEntity.getGroups() == null ? null : mIRProfileEntity.getGroups().get(string);
            if (list2 == null) {
                return false;
            }
            profiledObject = this.buildGroupProfiledObject(profiledObjectDefinition, (MIRProfileGroup)((Object)list2));
        } else {
            profiledObject = MIRProfiler.buildProfiledObject(profiledObjectDefinition, mIRProfileEntity, null);
        }
        list.add(profiledObject);
        if (profiledObjectDefinition2.equals(profiledObjectDefinition)) {
            return true;
        }
        list2 = this.listParents(profiledObjectDefinition, profiledObjectDefinition2, mIRProfileEntity, mIRProfile);
        if (list2 == null || list2.size() == 0) {
            return false;
        }
        if (list2.size() == 1) {
            ProfiledObjectDefinition profiledObjectDefinition3 = (ProfiledObjectDefinition)list2.get(0);
            if (string == null && MIRSdkUtil.isTopLevelModelType(profiledObjectDefinition.getObjectType()) && profiledObjectDefinition.getObjectType() != 286 && !MIRProfiler.isMetaIntegrationProfile(mIRProfile.getName())) {
                String string2 = this.dataProvider.getAutoProfile(profiledObjectDefinition3);
                mIRProfile = MIRProfiler.getProfile(string2);
            }
            return this.computeParentPath(profiledObjectDefinition3, profiledObjectDefinition2, mIRProfile, list);
        }
        for (ProfiledObjectDefinition profiledObjectDefinition4 : list2) {
            ArrayList<ProfiledObject> arrayList;
            boolean bl = this.computeParentPath(profiledObjectDefinition4, profiledObjectDefinition2, mIRProfile, arrayList = new ArrayList<ProfiledObject>());
            if (!bl) continue;
            list.addAll(arrayList);
            return true;
        }
        return false;
    }

    private List<ProfiledObjectDefinition> listParents(ProfiledObjectDefinition profiledObjectDefinition, ProfiledObjectDefinition profiledObjectDefinition2, MIRProfileEntity mIRProfileEntity, MIRProfile mIRProfile) throws MIRException {
        ArrayList<ProfiledObjectDefinition> arrayList = new ArrayList<ProfiledObjectDefinition>();
        if (this.getGroupName(profiledObjectDefinition) != null) {
            ProfiledObjectDefinition profiledObjectDefinition3 = new ProfiledObjectDefinition(profiledObjectDefinition);
            profiledObjectDefinition3.setGroupName(null);
            arrayList.add(profiledObjectDefinition3);
            return arrayList;
        }
        if (MIRSdkUtil.isTopLevelModelType(profiledObjectDefinition.getObjectType())) {
            ObjectIdentifier objectIdentifier = this.dataProvider.getInternalContentId(profiledObjectDefinition, profiledObjectDefinition2);
            if (objectIdentifier == null) {
                return null;
            }
            arrayList.add(new ProfiledObjectDefinition(this.dataProvider.get(objectIdentifier, new AttributeIdentifier[0])));
            return arrayList;
        }
        LinkedObject[] linkedObjectArray = this.dataProvider.list((ObjectIdentifier)profiledObjectDefinition, mIRProfileEntity.getLinks(true), mIRProfileEntity.getListAttributes(false, true));
        if (linkedObjectArray != null) {
            for (LinkedObject linkedObject : linkedObjectArray) {
                Object object;
                MIRProfileLink mIRProfileLink;
                MIRProfileEntity mIRProfileEntity2 = this.getProfileEntity(mIRProfile, linkedObject.getObject());
                if (mIRProfileEntity2 == null || (mIRProfileLink = mIRProfileEntity.getParentProfileLink(linkedObject.getLinkIdentifier(), mIRProfileEntity2)) == null) continue;
                if (mIRProfileLink.getOwnerGroup() != null) {
                    object = new ProfiledObjectDefinition(linkedObject.getObject());
                    ((ProfiledObjectDefinition)object).setGroupName(mIRProfileLink.getOwnerGroup().getName());
                    arrayList.add(new ProfiledObjectDefinition((ProfiledObjectDefinition)object));
                    continue;
                }
                object = mIRProfileEntity2.getProfileLink(mIRProfileLink.getLinkIdentifier().reverseLink(), mIRProfileEntity);
                if (object == null || !((MIRProfileLink)object).isChildLinkType()) continue;
                ProfiledObjectDefinition profiledObjectDefinition4 = new ProfiledObjectDefinition(linkedObject.getObject());
                arrayList.add(profiledObjectDefinition4);
            }
        }
        return arrayList;
    }

    private Map<ProfiledObject, ProfiledAttribute[]> get(ObjectDefinition[] objectDefinitionArray, String string, boolean bl) throws MIRException {
        MIRProfile mIRProfile = MIRProfiler.getProfile(string);
        if (mIRProfile == null) {
            return null;
        }
        TreeMap<ProfiledObject, ProfiledAttribute[]> treeMap = new TreeMap<ProfiledObject, ProfiledAttribute[]>();
        for (ObjectDefinition objectDefinition : objectDefinitionArray) {
            ProfiledObject profiledObject;
            MIRProfileEntity mIRProfileEntity;
            AttributeIdentifier[] attributeIdentifierArray;
            ObjectDefinition objectDefinition2;
            MIRProfileEntity[] mIRProfileEntityArray;
            if (this.getGroupName(objectDefinition) != null || (mIRProfileEntityArray = mIRProfile.getProfileEntities(objectDefinition.getObjectType())) == null || mIRProfileEntityArray.length == 0 || (objectDefinition2 = this.dataProvider.get(objectDefinition, attributeIdentifierArray = mIRProfile.getAttributes(mIRProfileEntityArray, false))) == null || (mIRProfileEntity = this.getProfileEntity(mIRProfile, objectDefinition2)) == null || (profiledObject = MIRProfiler.buildProfiledObject(objectDefinition2, mIRProfileEntity, null)) == null) continue;
            ProfiledAttribute[] profiledAttributeArray = null;
            TreeSet<ProfiledAttribute> treeSet = new TreeSet<ProfiledAttribute>(new SimpleAttributeComparator());
            TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
            MIRProfileProperty[] mIRProfilePropertyArray = mIRProfileEntity.getProfileAttributes();
            if (bl && mIRProfilePropertyArray != null) {
                Comparable<ObjectIdentifier> comparable;
                Object object;
                Object object2;
                int n;
                Object[] objectArray = mIRProfilePropertyArray;
                int n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    MIRProfileProperty mIRProfileProperty = objectArray[n];
                    object2 = mIRProfileProperty.getAttributeIdentifier();
                    object = new ProfiledAttribute(new AttributeValue((AttributeIdentifier)object2, mIRProfileProperty.getDefaultValue()));
                    ((ProfiledAttribute)object).setProfilePosition(mIRProfileProperty.getPosition());
                    ((ProfiledAttribute)object).setDisplayName(mIRProfileProperty.getName());
                    ((ProfiledAttribute)object).setReadOnly(((AttributeIdentifier)object2)._isReadOnly());
                    comparable = this.dataProvider.getAttributeValue(objectDefinition, (AttributeIdentifier)object2);
                    if (comparable != null) {
                        ((ProfiledAttribute)object).setValue(((AttributeValue)comparable).getValue());
                        ((ProfiledAttribute)object).setValueType(((AttributeValue)comparable).getValueType());
                    }
                    if (((AttributeIdentifier)object2)._isUdp() && comparable == null) continue;
                    treeSet.add((ProfiledAttribute)object);
                    treeMap2.put(mIRProfileProperty.getName(), object);
                }
                Object[] objectArray2 = objectArray = objectDefinition2.getAttributes();
                n = objectArray2.length;
                for (int i = 0; i < n; ++i) {
                    ProfiledObject profiledObject2;
                    object2 = objectArray2[i];
                    if (!((AttributeIdentifier)object2)._isUdp() || (object = mIRProfileEntity.getProfileAttribute((AttributeIdentifier)object2)) != null || (comparable = ((MemoryDataProvider)this.dataProvider).getUdpDefinition(objectDefinition2, (AttributeIdentifier)object2)) == null || (profiledObject2 = this.getObject((ObjectDefinition)comparable, string)) == null) continue;
                    ProfiledAttribute profiledAttribute = new ProfiledAttribute((AttributeValue)object2);
                    profiledAttribute.setUdp(true);
                    treeSet.add(profiledAttribute);
                }
            }
            if (treeSet.size() > 0) {
                profiledAttributeArray = treeSet.toArray(new ProfiledAttribute[treeSet.size()]);
            }
            treeMap.put(profiledObject, profiledAttributeArray);
        }
        return treeMap;
    }

    private Set<ProfiledObject> listEntity(ObjectDefinition objectDefinition, String string) throws MIRException {
        Object object;
        MIRProfile mIRProfile = MIRProfiler.getProfile(string);
        if (mIRProfile == null) {
            return null;
        }
        MIRProfileEntity mIRProfileEntity = this.getProfileEntityByObjId(mIRProfile, objectDefinition);
        if (mIRProfileEntity == null) {
            return null;
        }
        TreeSet<ProfiledObject> treeSet = new TreeSet<ProfiledObject>(new SimpleLinkComparator());
        HashMap<String, MIRProfileGroup> hashMap = mIRProfileEntity.getGroups();
        if (hashMap != null) {
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                MIRProfileGroup mIRProfileGroup = (MIRProfileGroup)object.next();
                Set<ProfiledObject> set = this.listGroup(objectDefinition, mIRProfileGroup.getName(), string, true);
                if (set == null || set.size() <= 0) continue;
                ProfiledObject profiledObject = this.buildGroupProfiledObject(objectDefinition, mIRProfileGroup);
                treeSet.add(profiledObject);
            }
        }
        if ((object = mIRProfileEntity.getProfileLinks()) != null) {
            this.listLinks(objectDefinition, mIRProfile, (MIRProfileLink[])object, treeSet, false);
        }
        return treeSet;
    }

    private void listLinks(ObjectDefinition objectDefinition, MIRProfile mIRProfile, MIRProfileLink[] mIRProfileLinkArray, Set<ProfiledObject> set, boolean bl) throws MIRException {
        for (MIRProfileLink mIRProfileLink : mIRProfileLinkArray) {
            LinkedObject[] linkedObjectArray = this.dataProvider.list(objectDefinition, mIRProfileLink.getLinkIdentifier(), mIRProfileLink.getOrderBy());
            if (linkedObjectArray == null) continue;
            this.getExtraProperties(linkedObjectArray, mIRProfile, mIRProfileLink, false);
            for (LinkedObject linkedObject : linkedObjectArray) {
                ProfiledObject profiledObject;
                MIRProfileEntity mIRProfileEntity = this.getProfileEntity(mIRProfile, linkedObject.getObject());
                if (mIRProfileEntity == null || !mIRProfileLink.containsChild(mIRProfileEntity) || (profiledObject = MIRProfiler.buildProfiledObject(linkedObject.getObject(), mIRProfileEntity, mIRProfileLink)) == null) continue;
                set.add(profiledObject);
                if (!bl) continue;
                return;
            }
        }
    }

    private ProfiledObject buildGroupProfiledObject(ObjectDefinition objectDefinition, MIRProfileGroup mIRProfileGroup) throws MIRException {
        ProfiledObject profiledObject = new ProfiledObject();
        ProfiledObjectDefinition profiledObjectDefinition = new ProfiledObjectDefinition(objectDefinition);
        profiledObjectDefinition.setObjectName(mIRProfileGroup.getName());
        profiledObjectDefinition.setGroupName(mIRProfileGroup.getName());
        profiledObject.setObjectDefinition(profiledObjectDefinition);
        profiledObject.setIconName(mIRProfileGroup.getIcon());
        profiledObject.setProfilePosition(mIRProfileGroup.getPosition());
        profiledObject.setEntityName(mIRProfileGroup.getOwner().getName());
        return profiledObject;
    }

    private MIRProfileEntity getProfileEntityByObjId(MIRProfile mIRProfile, ObjectDefinition objectDefinition) throws MIRException {
        MIRProfileEntity[] mIRProfileEntityArray = mIRProfile.getProfileEntities(objectDefinition.getObjectType());
        if (mIRProfileEntityArray == null || mIRProfileEntityArray.length == 0) {
            return null;
        }
        AttributeIdentifier[] attributeIdentifierArray = mIRProfile.getAttributes(mIRProfileEntityArray, false);
        ObjectDefinition objectDefinition2 = this.dataProvider.get(objectDefinition, attributeIdentifierArray);
        if (objectDefinition2 == null) {
            return null;
        }
        MIRProfileEntity mIRProfileEntity = this.getProfileEntity(mIRProfile, objectDefinition2);
        if (mIRProfileEntity != null) {
            objectDefinition.setObjectName(MIRProfiler.getObjectName(mIRProfileEntity, objectDefinition2));
        }
        return mIRProfileEntity;
    }

    private void getExtraProperties(LinkedObject[] linkedObjectArray, MIRProfile mIRProfile, MIRProfileLink mIRProfileLink, boolean bl) throws MIRException {
        if (linkedObjectArray != null) {
            Comparable<AttributeIdentifier>[] comparableArray;
            TreeMap<ObjectDefinition, ObjectDefinition> treeMap = new TreeMap<ObjectDefinition, ObjectDefinition>();
            TreeSet<AttributeIdentifier> treeSet = new TreeSet<AttributeIdentifier>();
            MIRProfileEntity[] mIRProfileEntityArray = mIRProfileLink.getAllChildren();
            if (mIRProfileEntityArray != null && (comparableArray = mIRProfile.getAttributes(mIRProfileEntityArray, bl)) != null && comparableArray.length > 0) {
                for (AttributeIdentifier object : comparableArray) {
                    treeSet.add(object);
                }
                for (LinkedObject linkedObject : linkedObjectArray) {
                    treeMap.put(linkedObject.getObject(), linkedObject.getObject());
                }
            }
            if (treeMap.size() > 0) {
                ObjectDefinition objectDefinition;
                comparableArray = this.dataProvider.get(treeMap.values().toArray(new ObjectDefinition[treeMap.size()]), treeSet.toArray(new AttributeIdentifier[treeSet.size()]));
                for (Comparable<AttributeIdentifier> comparable : comparableArray) {
                    objectDefinition = (ObjectDefinition)treeMap.get(comparable);
                    if (objectDefinition == null) continue;
                    objectDefinition._addAttributes(((ObjectDefinition)comparable).getAttributes());
                }
                for (LinkedObject linkedObject : linkedObjectArray) {
                    objectDefinition = linkedObject.getObject();
                    ObjectDefinition objectDefinition2 = (ObjectDefinition)treeMap.get(objectDefinition);
                    if (objectDefinition2 == null || objectDefinition2 == objectDefinition) continue;
                    objectDefinition.setAttributes(objectDefinition2.getAttributes());
                }
            }
        }
    }

    private MIRProfileEntity getProfileEntity(MIRProfile mIRProfile, ObjectDefinition objectDefinition) throws MIRException {
        MIRProfileEntity[] mIRProfileEntityArray = mIRProfile.getProfileEntities(objectDefinition.getObjectType());
        if (mIRProfileEntityArray == null) {
            return null;
        }
        MIRProfileEntity mIRProfileEntity = null;
        MIRProfileEntity mIRProfileEntity2 = null;
        short s = objectDefinition.getObjectType();
        AttributeValue[] attributeValueArray = objectDefinition.getAttributes();
        for (MIRProfileEntity mIRProfileEntity3 : mIRProfileEntityArray) {
            if (mIRProfileEntity3.getElementType() != s || !mIRProfileEntity3.matchCondition(attributeValueArray)) continue;
            if (mIRProfileEntity3.getCondition() != null) {
                if (mIRProfileEntity != null) {
                    throw new MIRException(PRFLR.MORE_THAN_ONE_ENTITY_MATCHES.getMessage(objectDefinition.toString(), "[" + StringUtil.join(mIRProfileEntityArray) + "]", mIRProfile.getName()));
                }
                mIRProfileEntity = mIRProfileEntity3;
                continue;
            }
            mIRProfileEntity2 = mIRProfileEntity3;
        }
        return mIRProfileEntity != null ? mIRProfileEntity : mIRProfileEntity2;
    }

    public static ProfiledObject buildProfiledObject(ObjectDefinition objectDefinition, MIRProfileEntity mIRProfileEntity, MIRProfileLink mIRProfileLink) {
        ProfiledObject profiledObject = new ProfiledObject();
        return MIRProfiler.buildProfiledObject(profiledObject, objectDefinition, mIRProfileEntity, mIRProfileLink);
    }

    private static ProfiledObject buildProfiledObject(ProfiledObject profiledObject, ObjectDefinition objectDefinition, MIRProfileEntity mIRProfileEntity, MIRProfileLink mIRProfileLink) {
        profiledObject.getObjectDefinition().setModelId(objectDefinition.getModelId());
        profiledObject.getObjectDefinition().setObjectId(objectDefinition.getObjectId());
        profiledObject.getObjectDefinition().setObjectName(MIRProfiler.getObjectName(mIRProfileEntity, objectDefinition));
        profiledObject.getObjectDefinition().setObjectType(objectDefinition.getObjectType());
        profiledObject.setEntityName(mIRProfileEntity.getName());
        profiledObject.setIconName(mIRProfileEntity.getIcon());
        profiledObject.setEmpty(mIRProfileEntity.getLinkCount() == 0 && mIRProfileEntity.getGroupCount() == 0);
        if (mIRProfileLink != null) {
            profiledObject.setLinkId(mIRProfileLink.getLinkIdentifier());
            profiledObject.setLinkType(mIRProfileLink.getType());
            profiledObject.setAssociationDisplayName(mIRProfileLink.getRoleName());
            profiledObject.setAssociationGroupName(mIRProfileLink.getGroupName());
            profiledObject.setProfilePosition(mIRProfileLink.getPosition());
        } else {
            profiledObject.setLinkType((byte)3);
        }
        if (objectDefinition.getAttributes() == null) {
            return profiledObject;
        }
        for (AttributeValue attributeValue : objectDefinition.getAttributes()) {
            String string = attributeValue.getValue();
            if (string == null || string.length() == 0 || mIRProfileLink == null || !attributeValue.equals(mIRProfileLink.getOrderBy())) continue;
            profiledObject.setDataPosition(attributeValue);
        }
        return profiledObject;
    }

    private static String getObjectName(MIRProfileEntity mIRProfileEntity, ObjectDefinition objectDefinition) {
        AttributeValue attributeValue;
        AttributeIdentifier attributeIdentifier = mIRProfileEntity.getAttributeByName("Name");
        if (!DEFAULT_NAME_ATTRIBUTE.equals(attributeIdentifier) && (attributeValue = objectDefinition.getAttributeValue(attributeIdentifier)) != null) {
            return attributeValue.getValue();
        }
        return objectDefinition.getObjectName();
    }

    public ProfiledObject getParent(ObjectDefinition objectDefinition, ObjectDefinition objectDefinition2, String string, boolean bl) throws MIRException {
        MIRProfile mIRProfile = MIRProfiler.getProfile(string);
        if (mIRProfile == null) {
            return null;
        }
        if (objectDefinition.equals(objectDefinition2)) {
            return null;
        }
        ProfiledObjectDefinition profiledObjectDefinition = objectDefinition instanceof ProfiledObjectDefinition ? new ProfiledObjectDefinition((ProfiledObjectDefinition)objectDefinition) : new ProfiledObjectDefinition(objectDefinition);
        ProfiledObjectDefinition profiledObjectDefinition2 = objectDefinition2 instanceof ProfiledObjectDefinition ? new ProfiledObjectDefinition((ProfiledObjectDefinition)objectDefinition2) : new ProfiledObjectDefinition(objectDefinition2);
        MIRProfileEntity mIRProfileEntity = this.getProfileEntityByObjId(mIRProfile, profiledObjectDefinition);
        if (mIRProfileEntity == null) {
            return null;
        }
        List<ProfiledObjectDefinition> list = this.listParents(profiledObjectDefinition, profiledObjectDefinition2, mIRProfileEntity, mIRProfile);
        if (list != null) {
            for (ProfiledObjectDefinition profiledObjectDefinition3 : list) {
                Object object;
                Object object2;
                Object object3;
                if (MIRSdkUtil.isTopLevelModelType(objectDefinition.getObjectType()) && objectDefinition.getObjectType() != 286 && !MIRProfiler.isMetaIntegrationProfile(string)) {
                    object3 = this.dataProvider.getAutoProfile(profiledObjectDefinition3);
                    object2 = MIRProfiler.getProfile((String)object3);
                    if (object2 == null) continue;
                    mIRProfile = object2;
                }
                if ((object3 = this.getProfileEntityByObjId(mIRProfile, profiledObjectDefinition3)) == null) continue;
                object2 = null;
                String string2 = this.getGroupName(profiledObjectDefinition3);
                if (string2 != null) {
                    Object object4 = object = ((MIRProfileEntity)object3).getGroups() == null ? null : ((MIRProfileEntity)object3).getGroups().get(string2);
                    if (object == null) continue;
                    object2 = this.buildGroupProfiledObject(profiledObjectDefinition3, (MIRProfileGroup)object);
                }
                if (object2 != null) {
                    if (bl) {
                        object = this.dataProvider.get(((ProfiledObject)object2).getObjectDefinition(), null);
                        object2 = MIRProfiler.buildProfiledObject((ObjectDefinition)object, (MIRProfileEntity)object3, null);
                        return object2;
                    }
                    return object2;
                }
                object2 = MIRProfiler.buildProfiledObject(profiledObjectDefinition3, (MIRProfileEntity)object3, null);
                return object2;
            }
        }
        return null;
    }

    public MIRProfileEntity getProfileEntity(String string, ProfiledObject profiledObject) throws MIRException {
        MIRProfile mIRProfile = MIRProfiler.getProfile(string);
        if (mIRProfile != null) {
            if (profiledObject.getEntityName() != null) {
                return mIRProfile.getProfileEntity(profiledObject.getEntityName());
            }
            return this.getProfileEntityByObjId(mIRProfile, profiledObject.getObjectDefinition());
        }
        return null;
    }

    public static MIRProfileEntity getProfileEntity(int n) {
        MIRProfile mIRProfile = MIRProfiler.getProfile(MIRProfileId.getProfileId(n));
        if (mIRProfile != null) {
            return mIRProfile.getProfileEntityById(n);
        }
        return null;
    }

    public static MIRProfile getProfile(int n) {
        return profiles.getProfile(n);
    }
}

