/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.generators;

import MITI.MIRException;
import MITI.bridges.profiles.MIRProfileId;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEvent;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ValidateProfile {
    private static BufferedLogEventHandler handler = new BufferedLogEventHandler();
    private static final String GEN_PROFILES_DIR = "../../../../MIMB/sdk/Profiles/profiles/";

    public static void main(String[] stringArray) throws MIRException, IOException {
        boolean bl;
        MIRLogger.init(handler);
        File file = stringArray.length > 0 ? new File(stringArray[0]) : new File(GEN_PROFILES_DIR);
        if (!file.exists()) {
            System.err.println("Profile does not exist:" + file.getCanonicalPath());
            System.exit(-1);
            return;
        }
        System.out.println("Processing: " + file.getCanonicalPath());
        File file2 = new File(file, "../ids");
        if (!file2.exists() || !file2.isDirectory()) {
            file2 = null;
        }
        System.exit((bl = ValidateProfile.processDirectory(file, file2)) ? 0 : -1);
    }

    private static boolean processDirectory(File file, File file2) {
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file3 : fileArray = file.listFiles()) {
                if (file3.isDirectory()) {
                    bl &= ValidateProfile.processDirectory(new File(file, file3.getName()), file2 != null ? new File(file2, file3.getName()) : null);
                }
                if (!file3.getName().endsWith(".xml")) continue;
                bl &= ValidateProfile.loadProfile(new File(file, file3.getName()), file2 != null ? new File(file2, file3.getName()) : null);
            }
        } else {
            bl &= ValidateProfile.loadProfile(file, file2);
        }
        return bl;
    }

    private static boolean loadProfile(File file, File file2) {
        boolean bl = true;
        if (!file.getName().equals("Meta Integration.xml")) {
            boolean bl2 = false;
            Exception exception = null;
            try {
                MIRProfile mIRProfile = MIRProfile.load(file);
                bl &= !mIRProfile.isErrorsInProfile;
                bl2 |= mIRProfile.isWarningsInProfile;
                if (file2 != null && file2.exists()) {
                    Element element;
                    int n;
                    HashMap<String, Integer> object = new HashMap<String, Integer>();
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
                    HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(file2);
                    Element element2 = document.getDocumentElement();
                    int n2 = Integer.parseInt(element2.getAttribute("id"));
                    NodeList nodeList = element2.getElementsByTagName("Entity");
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        element = (Element)nodeList.item(n);
                        object.put(element.getAttribute("name"), Integer.parseInt(element.getAttribute("id")));
                    }
                    nodeList = element2.getElementsByTagName("Property");
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        element = (Element)nodeList.item(n);
                        hashMap.put(element.getAttribute("name"), Integer.parseInt(element.getAttribute("id")));
                    }
                    nodeList = element2.getElementsByTagName("Link");
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        element = (Element)nodeList.item(n);
                        hashMap2.put(element.getAttribute("name"), Integer.parseInt(element.getAttribute("id")));
                    }
                    nodeList = element2.getElementsByTagName("Group");
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        element = (Element)nodeList.item(n);
                        hashMap3.put(element.getAttribute("name"), Integer.parseInt(element.getAttribute("id")));
                    }
                    for (MIRProfileEntity mIRProfileEntity : mIRProfile.getProfileEntities()) {
                        Integer n3 = (Integer)object.get(mIRProfileEntity.getName());
                        if (n3 == null) {
                            bl = false;
                            PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Missing id for entity: " + mIRProfileEntity.getName());
                        } else if (MIRProfileId.getId(n2, n3) != mIRProfileEntity.getId()) {
                            bl = false;
                            PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Id mismatch for entity: " + mIRProfileEntity.getName());
                        }
                        if (mIRProfileEntity.getProfileAttributes() != null) {
                            for (MIRProfileProperty mIRProfileProperty : mIRProfileEntity.getProfileAttributes()) {
                                if (hashMap.containsKey(mIRProfileProperty.getName())) continue;
                                bl = false;
                                PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Missing id for property: " + mIRProfileProperty.getName());
                            }
                        }
                        if (mIRProfileEntity.getProfileLinks() != null) {
                            for (MIRProfileLink mIRProfileLink : mIRProfileEntity.getProfileLinks()) {
                                if (mIRProfileLink.getRoleName().isEmpty() || hashMap2.containsKey(mIRProfileLink.getRoleName())) continue;
                                bl = false;
                                PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Missing id for link role name: " + mIRProfileLink.getRoleName());
                            }
                        }
                        if (mIRProfileEntity.getGroups() != null) {
                            for (MIRProfileGroup mIRProfileGroup : mIRProfileEntity.getProfileGroups()) {
                                if (hashMap3.containsKey(mIRProfileGroup.getName())) continue;
                                bl = false;
                                PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Missing id for group: " + mIRProfileGroup.getName());
                            }
                        }
                        if (mIRProfileEntity.isExcluded()) continue;
                        HashSet hashSet = new HashSet();
                        HashSet<String> hashSet2 = new HashSet<String>();
                        HashSet<String> hashSet3 = new HashSet<String>();
                        if (mIRProfileEntity.getAttributeByName("Name") == null) {
                            bl = false;
                            PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Missing Name for entity: " + mIRProfileEntity.getName());
                        }
                        if (mIRProfileEntity.getProfileAttributes() != null) {
                            for (Object object2 : mIRProfileEntity.getProfileAttributes()) {
                                short s;
                                if (!hashSet.add(((MIRProfileProperty)object2).getName())) {
                                    bl = false;
                                    PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Duplicate member found: " + mIRProfileEntity.getName() + "." + ((MIRProfileProperty)object2).getName());
                                }
                                if ("Name".equals(((MIRProfileProperty)object2).getName())) {
                                    s = ((MIRProfileProperty)object2).getAttributeIdentifier().getType();
                                    if (s == 174 || s == 106 || s == -2) continue;
                                    bl = false;
                                    PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Invalid attribute identifier for property: " + mIRProfileEntity.getName() + "." + ((MIRProfileProperty)object2).getName());
                                    continue;
                                }
                                if ("Description".equals(((MIRProfileProperty)object2).getName())) {
                                    s = ((MIRProfileProperty)object2).getAttributeIdentifier().getType();
                                    if (s == 65 || s == 103) continue;
                                    bl = false;
                                    PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Invalid attribute identifier for property: " + mIRProfileEntity.getName() + "." + ((MIRProfileProperty)object2).getName());
                                    continue;
                                }
                                if (!"Documentation".equals(((MIRProfileProperty)object2).getName()) || (s = ((MIRProfileProperty)object2).getAttributeIdentifier().getType()) == 103) continue;
                                bl = false;
                                PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Invalid attribute identifier for property: " + mIRProfileEntity.getName() + "." + ((MIRProfileProperty)object2).getName());
                            }
                        }
                        if (mIRProfileEntity.getProfileLinks() != null) {
                            for (Object object2 : mIRProfileEntity.getProfileLinks()) {
                                if (!((MIRProfileLink)object2).getGroupName().isEmpty()) {
                                    if (!hashSet3.add(((MIRProfileLink)object2).getGroupName()) || hashSet.add(((MIRProfileLink)object2).getGroupName())) continue;
                                    bl = false;
                                    PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Duplicate member found: " + mIRProfileEntity.getName() + "." + ((MIRProfileLink)object2).getGroupName());
                                    continue;
                                }
                                if (((MIRProfileLink)object2).getRoleName().isEmpty() || !hashSet2.add(((MIRProfileLink)object2).getRoleName()) || hashSet.add(((MIRProfileLink)object2).getRoleName())) continue;
                                bl = false;
                                PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Duplicate member found: " + mIRProfileEntity.getName() + "." + ((MIRProfileLink)object2).getRoleName());
                            }
                        }
                        if (mIRProfileEntity.getGroups() == null) continue;
                        for (Object object2 : mIRProfileEntity.getProfileGroups()) {
                            if (!hashSet3.add(((MIRProfileGroup)object2).getName()) || hashSet.add(((MIRProfileGroup)object2).getName())) continue;
                            bl = false;
                            PRFLR.ERR_IN_PROFILE.log(mIRProfile.getName(), "Duplicate member found: " + mIRProfileEntity.getName() + "." + ((MIRProfileGroup)object2).getName());
                        }
                    }
                }
            }
            catch (MIRException | IOException | ParserConfigurationException | SAXException exception2) {
                bl = false;
                exception = exception2;
            }
            if (!bl || bl2) {
                for (LogEvent logEvent : handler.getEvents()) {
                    System.err.println(logEvent.toString());
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                    System.err.flush();
                }
            }
            handler.clear();
        }
        return bl;
    }
}

