/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.MIRException;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileLinkList;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.Condition;
import MITI.server.services.common.mir.LinkIdentifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MIRProfileEntity {
    public static final String NAME_ATTRIBUTE = "Name";
    public static final AttributeIdentifier DEFAULT_NAME_ATT_ID = new AttributeIdentifier(174);
    private static Comparator<MIRProfileEntity> entityComparator = new Comparator<MIRProfileEntity>(){

        @Override
        public int compare(MIRProfileEntity mIRProfileEntity, MIRProfileEntity mIRProfileEntity2) {
            return mIRProfileEntity.position - mIRProfileEntity2.position;
        }
    };
    private MIRProfile profile = null;
    private short elementType = (short)-1;
    private String name = null;
    private String icon = null;
    private TreeMap<AttributeIdentifier, MIRProfileProperty> attributes = new TreeMap();
    MIRProfileLinkList links = null;
    MIRProfileLinkList parentLinks = null;
    private Condition condition = null;
    private int position = 0;
    private HashMap<String, MIRProfileGroup> groups = null;
    private int id;
    private String contentProfile = null;
    private String searchGroup;
    private boolean exclude = false;

    public static Comparator<MIRProfileEntity> getComparator() {
        return entityComparator;
    }

    public short getElementType() {
        return this.elementType;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public int getPosition() {
        return this.position;
    }

    public int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public MIRProfileProperty getProfileAttribute(AttributeIdentifier attributeIdentifier) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attributeIdentifier);
    }

    public MIRProfileProperty[] getProfileAttributes() {
        if (this.attributes == null) {
            return null;
        }
        TreeSet<MIRProfileProperty> treeSet = new TreeSet<MIRProfileProperty>(MIRProfileProperty.getComparator());
        treeSet.addAll(this.attributes.values());
        return treeSet.toArray(new MIRProfileProperty[treeSet.size()]);
    }

    public int getLinkCount() {
        return this.links.getCount();
    }

    public MIRProfileLink getProfileLink(LinkIdentifier linkIdentifier, MIRProfileEntity mIRProfileEntity) {
        return this.links.getProfileLink(linkIdentifier, mIRProfileEntity);
    }

    public MIRProfileLink getParentProfileLink(LinkIdentifier linkIdentifier, MIRProfileEntity mIRProfileEntity) {
        return this.parentLinks.getProfileLink(linkIdentifier, mIRProfileEntity);
    }

    public MIRProfileLink[] getProfileLinks() {
        return this.links.getProfileLinks();
    }

    public MIRProfileGroup[] getProfileGroups() {
        if (this.groups == null) {
            return null;
        }
        TreeSet<MIRProfileGroup> treeSet = new TreeSet<MIRProfileGroup>(MIRProfileGroup.getComparator());
        treeSet.addAll(this.groups.values());
        return treeSet.toArray(new MIRProfileGroup[treeSet.size()]);
    }

    public MIRProfileLink[] getParentProfileLinks() {
        return this.parentLinks.getProfileLinks();
    }

    public MIRProfileEntity(String string, short s, MIRProfile mIRProfile, int n, int n2) {
        this.profile = mIRProfile;
        this.name = string;
        this.elementType = s;
        this.links = new MIRProfileLinkList();
        this.parentLinks = new MIRProfileLinkList();
        this.id = n;
        this.position = n2;
    }

    public MIRProfile getProfile() {
        return this.profile;
    }

    void addAttribute(MIRProfileProperty mIRProfileProperty) {
        if (this.attributes == null) {
            this.attributes = new TreeMap();
        }
        this.attributes.put(mIRProfileProperty.getAttributeIdentifier(), mIRProfileProperty);
        mIRProfileProperty.setPosition(this.attributes.size());
    }

    public void addLink(MIRProfileLink mIRProfileLink) throws MIRException {
        this.links.addLink(mIRProfileLink);
    }

    void addGroup(MIRProfileGroup mIRProfileGroup) throws MIRException {
        if (this.groups == null) {
            this.groups = new HashMap();
        }
        this.groups.put(mIRProfileGroup.getName(), mIRProfileGroup);
    }

    public HashMap<String, MIRProfileGroup> getGroups() {
        return this.groups;
    }

    void addParentLink(MIRProfileLink mIRProfileLink) throws MIRException {
        LinkIdentifier linkIdentifier = mIRProfileLink.getLinkIdentifier().reverseLink();
        if (linkIdentifier == null) {
            return;
        }
        MIRProfileLink mIRProfileLink2 = new MIRProfileLink(linkIdentifier, this, mIRProfileLink.getOwnerGroup(), mIRProfileLink.getOwner().getName());
        mIRProfileLink2.setPosition(this.parentLinks.getCount());
        this.parentLinks.addLink(mIRProfileLink2);
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setIcon(String string) {
        if (string != null && string.length() != 0) {
            this.icon = string;
        }
    }

    MIRProfileProperty getProfileProperty(AttributeIdentifier attributeIdentifier) {
        if (this.attributes != null) {
            return this.attributes.get(attributeIdentifier);
        }
        return null;
    }

    AttributeIdentifier[] getAttributes() {
        HashSet<AttributeIdentifier> hashSet = new HashSet<AttributeIdentifier>();
        if (this.attributes != null) {
            hashSet.addAll(this.attributes.keySet());
        }
        if (this.condition != null) {
            hashSet.addAll(Arrays.asList(this.condition.listAttributes()));
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet.toArray(new AttributeIdentifier[hashSet.size()]);
    }

    public LinkIdentifier[] getLinks(boolean bl) {
        if (bl) {
            return this.parentLinks.getLinkIdentifiers();
        }
        return this.links.getLinkIdentifiers();
    }

    public AttributeIdentifier[] getListAttributes(boolean bl, boolean bl2) {
        if (bl2) {
            return this.parentLinks.getListAttributes(bl);
        }
        return this.links.getListAttributes(bl);
    }

    public AttributeIdentifier getAttributeByName(String string) {
        Set<AttributeIdentifier> set = this.attributes.keySet();
        for (AttributeIdentifier attributeIdentifier : set) {
            MIRProfileProperty mIRProfileProperty = this.attributes.get(attributeIdentifier);
            if (!mIRProfileProperty.getName().equals(string)) continue;
            return attributeIdentifier;
        }
        return null;
    }

    public AttributeIdentifier[] getConditionAttributes() {
        if (this.condition == null) {
            return null;
        }
        return this.condition.listAttributes();
    }

    public boolean matchCondition(AttributeValue[] attributeValueArray) {
        if (this.condition == null) {
            return true;
        }
        return this.condition.match(attributeValueArray);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof MIRProfileEntity) {
            MIRProfileEntity mIRProfileEntity = (MIRProfileEntity)object;
            return this.profile == mIRProfileEntity.profile && this.name.equals(((MIRProfileEntity)object).getName());
        }
        return false;
    }

    public int hashCode() {
        if (this.getCondition() != null) {
            return this.getElementType() ^ this.getCondition().toMPath().hashCode();
        }
        return this.getElementType();
    }

    public boolean isClassifier() {
        return MIR_Object.isInstanceOf(this.elementType, (short)75);
    }

    public boolean isReportItem() {
        return MIR_Object.isInstanceOf(this.elementType, (short)124);
    }

    public boolean isFeature() {
        return MIR_Object.isInstanceOf(this.elementType, (short)77);
    }

    public boolean isDataPackage() {
        return MIR_Object.isInstanceOf(this.elementType, (short)141);
    }

    public boolean isDirectoryContent() {
        return MIR_Object.isInstanceOf(this.elementType, (short)159);
    }

    public MIRProfileLinkList getProfileLinkList() {
        return this.links;
    }

    public boolean isRoot() {
        return MIR_Object.isInstanceOf(this.elementType, (short)218);
    }

    public int getId() {
        return this.id;
    }

    public boolean linkExists(MIRProfileLink mIRProfileLink) {
        return this.links.exists(mIRProfileLink);
    }

    public int getGroupCount() {
        if (this.groups == null) {
            return 0;
        }
        return this.groups.size();
    }

    public String getContentProfile() {
        return this.contentProfile;
    }

    public void setContentProfile(String string) {
        this.contentProfile = string;
    }

    public MIRProfileLink[] getProfileLinks(LinkIdentifier linkIdentifier) {
        return this.links.getProfileLinks(linkIdentifier);
    }

    public void setSearchGroup(String string) {
        this.searchGroup = string;
    }

    public String getSearchGroup() {
        return this.searchGroup;
    }

    public void setExcluded(boolean bl) {
        this.exclude = bl;
    }

    public boolean isExcluded() {
        return this.exclude;
    }
}

