/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.streaming.client;

import com.sas.svcs.streaming.client.BinaryStreamServiceInterface;
import com.sas.svcs.streaming.client.GeneralServiceExceptionHolder;
import com.sas.svcs.streaming.client.UnsupportedOperationExceptionHolder;
import com.sas.svcs.streaming.client.types.ExceptionType;
import java.io.IOException;

public class OutputStream
extends java.io.OutputStream {
    private final BinaryStreamServiceInterface _binaryStream;
    private boolean isClosed;

    public OutputStream(BinaryStreamServiceInterface binaryStream) {
        if (binaryStream == null) {
            throw new IllegalArgumentException("A non-null binary stream must be specified.");
        }
        this._binaryStream = binaryStream;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
        byte myByte = (byte)b;
        try {
            this._binaryStream.writeBytes(new byte[]{myByte});
        }
        catch (GeneralServiceExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
        catch (UnsupportedOperationExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
        if (b == null) {
            throw new NullPointerException("A non-null byte array must be specified.");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("The offset index must be greater than or equal to zero.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("The length must be greater than zero.");
        }
        if (off + len < 0) {
            throw new IndexOutOfBoundsException("The offset " + off + " plus length " + len + " must be greater than zero.");
        }
        if (off > b.length) {
            throw new IndexOutOfBoundsException("Offset index " + off + " should be less than the byte array length " + b.length + '.');
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("The offset " + off + " plus length " + len + " can not exceed the length of the byte array " + b.length + '.');
        }
        if (len == 0) {
            return;
        }
        byte[] bytesToWrite = null;
        if (off == 0 && len == b.length) {
            bytesToWrite = b;
        } else {
            bytesToWrite = new byte[len];
            System.arraycopy(b, off, bytesToWrite, 0, len);
        }
        try {
            this._binaryStream.writeBytes(bytesToWrite);
        }
        catch (GeneralServiceExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
        catch (UnsupportedOperationExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this._binaryStream.destroy();
        }
        catch (GeneralServiceExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
    }
}

