/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.util;

import com.sas.tools.webappconfig.util.Logger;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.Task;

public final class Localization {
    private static final int _ARGUMENT_BUFFER_REQUIREMENT = 20;
    private static final int _EXCEPTION_BUFFER_SIZE = 200;
    private ResourceBundle _resourceBundle = ResourceBundle.getBundle("com.sas.tools.webappconfig.WebAppConfigMessages", Localization.getLocale());
    private Collator _collator = Collator.getInstance(Localization.getLocale());
    private static final String _PROPERTY_NAME = "com.sas.tools.webappconfig.WebAppConfigMessages";
    private static Localization _instance = null;

    private Localization() {
    }

    public static Collator getCollator() {
        return Localization.getInstance()._collator;
    }

    public static String getString(Task task, String key) {
        if (null == key) {
            throw new NullPointerException();
        }
        try {
            return Localization.getInstance()._resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            Logger.log(0, task, "Couldn't find property \"", key, "\"");
            return key;
        }
    }

    public static String processFormat(Task task, String formatKey, Object o0) {
        Object[] args = new Object[]{o0};
        return Localization.getInstance().internalProcessFormat(task, formatKey, args);
    }

    public static String toLowerCase(String input) {
        return null == input ? null : input.toLowerCase(Localization.getLocale());
    }

    private static Locale getLocale() {
        return Locale.getDefault();
    }

    public static String processFormat(Task task, String formatKey, Object o0, Object o1) {
        Object[] args = new Object[]{o0, o1};
        return Localization.getInstance().internalProcessFormat(task, formatKey, args);
    }

    private static Localization getInstance() {
        if (null == _instance) {
            _instance = new Localization();
        }
        return _instance;
    }

    private String internalProcessFormat(Task task, String key, Object[] args) {
        if (null == key) {
            throw new NullPointerException();
        }
        try {
            return MessageFormat.format(this._resourceBundle.getString(key), args);
        }
        catch (MissingResourceException e) {
            Logger.log(0, task, "Couldn't find format property \"", key, "\"");
            return key;
        }
        catch (NullPointerException e) {
            Localization.processRuntimeException(task, key, args, e);
            return key;
        }
        catch (ClassCastException e) {
            Localization.processRuntimeException(task, key, args, e);
            return key;
        }
        catch (IllegalArgumentException e) {
            Localization.processRuntimeException(task, key, args, e);
            return key;
        }
    }

    private static void processRuntimeException(Task task, String key, Object[] args, RuntimeException e) {
        StringBuffer header = new StringBuffer(200);
        header.append("Unexpected exception: format property \"");
        header.append(key);
        header.append("\" exception is ");
        Logger.log(0, task, header, e, Localization.makeDataArguments(args));
    }

    private static StringBuffer makeDataArguments(Object[] args) {
        StringBuffer argsBuffer = new StringBuffer(20 * args.length);
        argsBuffer.append("Data is ");
        for (int k = 0; k < args.length; ++k) {
            if (0 != k) {
                argsBuffer.append(", ");
            }
            argsBuffer.append(args[k]);
        }
        return argsBuffer;
    }

    static String processFormat(Task task, String formatKey, Object o0, Object o1, Object o2) {
        Object[] args = new Object[]{o0, o1, o2};
        return Localization.getInstance().internalProcessFormat(task, formatKey, args);
    }

    static String processFormat(Task task, String formatKey, Object o0, Object o1, Object o2, Object o3) {
        Object[] args = new Object[]{o0, o1, o2, o3};
        return Localization.getInstance().internalProcessFormat(task, formatKey, args);
    }
}

