/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.util;

import com.sas.app.VersionSpec;
import com.sas.tools.webappconfig.propertymgmt.FilePropertySource;
import com.sas.tools.webappconfig.propertymgmt.PropertySourceInterface;
import com.sas.tools.webappconfig.util.Localization;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;

public final class ErrorHandling {
    private static final String _COMMA = ", ";
    private static final String _APPENDING_TO_LOG_FILE = "webappconfig.appending.to.log.file.fmt.txt";
    private static final String _CANNOT_ACCESS_PROPERTIES = "webappconfig.cannot.access.properties.txt";
    private static final String _CANNOT_ACCESS_SAS_METADATA_SERVER = "webappconfig.cannot.access.SAS.metadata.server.fmt.txt";
    private static final String _CANNOT_ACCESS_VJR = "webappconfig.cannot.access.vjr.txt";
    private static final String _CANNOT_ADD_ENTRY = "webappconfig.cannot.add.entry.fmt.txt";
    private static final String _CANNOT_CONNECT_TO_SAS_METADATA_SERVER = "webappconfig.cannot.connect.to.SAS.metadata.server.fmt.txt";
    private static final String _CANNOT_COPY_DIRECTORY = "webappconfig.cannot.copy.directory.fmt.txt";
    private static final String _CANNOT_COPY_FILE = "webappconfig.cannot.copy.file.fmt.txt";
    private static final String _CANNOT_CREATE_DIRECTORY = "webappconfig.cannot.create.directory.fmt.txt";
    private static final String _CANNOT_CREATE_LOG_FILE = "webappconfig.cannot.create.log.file.fmt.txt";
    private static final String _CANNOT_DELETE_FILE = "webappconfig.cannot.delete.file.fmt.txt";
    private static final String _CANNOT_ENCRYPT_NULL_PASSWORD = "webappconfig.cannot.encrypt.null.password.txt";
    private static final String _CANNOT_ENCRYPT_PASSWORD = "webappconfig.cannot.encrypt.password.txt";
    private static final String _CANNOT_EXPAND_PROPERTY = "webappconfig.cannot.expand.property.fmt.txt";
    private static final String _CANNOT_FIND_CONTENT_IN_VJR = "webappconfig.cannot.find.content.in.versioned.jar.repository.txt";
    private static final String _CANNOT_FIND_REPOSITORY = "webappconfig.cannot.find.repository.fmt.txt";
    private static final String _CANNOT_FIND_SAS_MASTER_CONFIGURATION = "webappconfig.cannot.find.SAS.master.configuration.fmt.txt";
    private static final String _CANNOT_GET_LIST_OF_AVAILABLE_REPOSITORIES = "webappconfig.cannot.get.list.of.available.repositories.txt";
    private static final String _CANNOT_OPEN_FILE = "webappconfig.cannot.open.file.fmt.txt";
    private static final String _CANNOT_PROCESS_EXPANSION = "webappconfig.cannot.process.expansion.fmt.txt";
    private static final String _CANNOT_PROCESS_EXPANSIONS = "webappconfig.cannot.process.expansions.fmt.txt";
    private static final String _CANNOT_PROCESS_PASSWORD_RULE = "webappconfig.cannot.process.password.rule.txt";
    private static final String _CANNOT_PROCESS_SCRIPT = "webappconfig.cannot.process.script.fmt.txt";
    private static final String _CANNOT_PROCESS_SUBSTITUTIONS = "webappconfig.cannot.process.substitutions.fmt.txt";
    private static final String _CANNOT_READ_FILE = "webappconfig.cannot.read.file.fmt.txt";
    private static final String _CANNOT_REDEFINE_PROPERTY = "webappconfig.cannot.redefine.property.fmt.txt";
    private static final String _CANNOT_RENAME_FILE = "webappconfig.cannot.rename.file.fmt.txt";
    private static final String _CANNOT_REUSE_PROPERTYSOURCELIST_ID = "webappconfig.cannot.reuse.propertysourcelist.id.fmt.txt";
    private static final String _CANNOT_VALIDATE_PASSWORD = "webappconfig.cannot.validate.password.fmt.txt";
    private static final String _CANNOT_VALIDATE_PASSWORD_REASON = "webappconfig.cannot.validate.password.reason.fmt.txt";
    private static final String _CANNOT_WRITE_TO_FILE = "webappconfig.cannot.write.to.file.fmt.txt";
    private static final String _CANNOT_WRITE_TO_LOG_FILE = "webappconfig.cannot.write.to.log.file.fmt.txt";
    private static final String _COPYING_DIRECTORY = "webappconfig.copying.directory.fmt.txt";
    private static final String _DEPRECATED_ATTRIBUTE = "webappconfig.deprecated.attribute.fmt.txt";
    private static final String _DID_NOT_FIND_STRING = "webappconfig.did.not.find.string.fmt.txt";
    private static final String _DIRECTORY_IS_NOT_A_DIRECTORY = "webappconfig.directory.is.not.a.directory.fmt.txt";
    private static final String _DIRECTORY_NUMBER_MISMATCH = "webappconfig.directory.number.mismatch.fmt.txt";
    private static final String _DUPLICATE_NAMESPACE_SOURCE = "webappconfig.duplicate.namespace.source.fmt.txt";
    private static final String _EMPTY_PARAMETER = "webappconfig.empty.parameter.fmt.txt";
    private static final String _EXECUTING_TASK = "webappconfig.executing.task.fmt.txt";
    private static final String _FILE_NUMBER_MISMATCH = "webappconfig.file.number.mismatch.fmt.txt";
    private static final String _FOUND_EXCLUDED_STRING = "webappconfig.found.excluded.string.fmt.txt";
    private static final String _IGNORING_WAR_FILE = "webappconfig.ignoring.war.file.txt";
    private static final String _IMBALANCED_DELIMITERS = "webappconfig.imbalanced.delimiters.fmt.txt";
    private static final String _INCOMPATIBLE_JAR = "webappconfig.incompatible.jar.fmt.txt";
    private static final String _INVALID_PARAMETER_VALUE = "webappconfig.invalid.parameter.value.fmt.txt";
    private static final String _INVALID_WAR_FILE_NAME = "webappconfig.invalid.war.file.name.fmt.txt";
    private static final String _LOADING_VERSIONED_JAR = "webappconfig.loading.versioned.jar.fmt.txt";
    private static final String _LOADING_VERSIONED_JAR_FILE = "webappconfig.loading.versioned.jar.file.fmt.txt";
    private static final String _LOOP_IN_PROPERTIES = "webappconfig.loop.in.properties.fmt.txt";
    private static final String _MISCONFIGURED_PROPERTYSOURCEREFERENCE = "webappconfig.misconfigured.propertysourcereference.txt";
    private static final String _MISSING_BASE = "webappconfig.missing.base.txt";
    private static final String _MISSING_PARAMETER = "webappconfig.missing.parameter.fmt.txt";
    private static final String _MISSING_PORT_ID = "webappconfig.missing.port.id.txt";
    private static final String _MISSING_PROPERTIES = "webappconfig.missing.properties.fmt.txt";
    private static final String _MISSING_PROPERTY = "webappconfig.missing.property.fmt.txt";
    private static final String _MISSING_SERVER_NAME = "webappconfig.missing.server.name.txt";
    private static final String _MULTIPLE_CONFIGURATION_PROPERTYGROUPS_DETECTED = "webappconfig.multiple.configuration.propertygroups.detected.txt";
    private static final String _NO_CHANGES_MADE_TO_FILE = "webappconfig.no.changes.made.to.file.fmt.txt";
    private static final String _NO_FILES_FOUND_MATCHING_PATTERN = "webappconfig.no.files.found.matching.pattern.fmt.txt";
    private static final String _NO_PASSWORDS_CHANGED = "webappconfig.no.passwords.changed.txt";
    private static final String _NO_PASSWORDS_FOUND_IN_FILE = "webappconfig.no.passwords.found.in.file.fmt.txt";
    private static final String _NO_PROPERTIES_FILES_DEFINED = "webappconfig.no.properties.defined.txt";
    private static final String _NO_PROPERTY_SOURCES_KNOWN = "webappconfig.no.property.sources.known.txt";
    private static final String _PASSWORD_CHANGED = "webappconfig.password.changed.fmt.txt";
    private static final String _PASSWORD_DEFINITION_NOT_FOUND_IN_FILE = "webappconfig.password.definition.not.found.in.file.fmt.txt";
    private static final String _PASSWORD_LISTING_HEADER = "webappconfig.password.listing.header.txt";
    private static final String _PASSWORD_LISTING_ITEM = "webappconfig.password.listing.item.fmt.txt";
    private static final String _PERCENT_COMPLETE = "webappconfig.percent.complete.fmt.txt";
    private static final String _PROCESSING_DIRECTORY = "webappconfig.processing.directory.fmt.txt";
    private static final String _PROCESSING_FILE = "webappconfig.processing.file.fmt.txt";
    private static final String _PROPERTY_IS_NOT_DIRECTORY = "webappconfig.property.is.not.directory.fmt.txt";
    private static final String _PROPERTY_SET = "webappconfig.property.set.fmt.txt";
    private static final String _PROPERTY_SHOULD_HAVE_VALUE = "webappconfig.property.should.have.value.fmt.txt";
    private static final String _PROPERTY_UNDEFINED = "webappconfig.property.undefined.fmt.txt";
    private static final String _STRIPPING_ROOT_CONTEXT = "webappconfig.stripping.root.context.fmt.txt";
    private static final String _TIMEOUT_TRYING_ACCESSING_REPOSITORY = "webappconfig.timeout.trying.accessing.repository.txt";
    private static final String _TIMEOUT_TRYING_READING_PICKLIST = "webappconfig.timeout.trying.reading.picklist.txt";
    private static final String _TIMEOUT_TRYING_READING_REPOSITORY = "webappconfig.timeout.trying.reading.repository.txt";
    private static final String _UNDEFINED_OPTIONAL_PROPERTIES = "webappconfig.undefined.optional.properties.fmt.txt";
    private static final String _UNDEFINED_REQUIRED_PROPERTIES = "webappconfig.undefined.required.properties.fmt.txt";
    private static final String _UNEXPECTED_EXCEPTION = "webappconfig.unexpected.exception.txt";
    private static final String _UNRECOGNIZED_KEYWORD_IN_FILE = "webappconfig.unrecognized.keyword.in.file.fmt.txt";
    private static final String _UNRECOGNIZED_SYNTAX_IN_FILE = "webappconfig.unrecognized.syntax.in.file.fmt.txt";
    private static final String _VALIDATING_DIRECTORY = "webappconfig.validating.directory.fmt.txt";
    private static final String _VALIDATING_XML_FILE = "webappconfig.validating.xml.file.fmt.txt";
    private static final String _WARFILE_DOES_NOT_EXIST = "webappconfig.warfile.does.not.exist.fmt.txt";
    private static final String _WEB_LOGIC_PATH = "webappconfig.weblogic.path.fmt.txt";
    private static final String _RPOSMGR_DOES_NOT_EXIST = "webappconfig.metadatasrv.path.rposmgr.error.txt";
    private static final String _REPOS_LOCATION_INFORMATION = "webappconfig.metadatasrv.path.rposabs.inform.txt";
    private static final String _REPOS_LOCATION_DOES_NOT_EXIST = "webappconfig.metadatasrv.path.rposabs.error.txt";
    private static final String _REPOS_PATH_DOES_NOT_EXIST = "webappconfig.metadatasrv.path.rposrel.error.txt";
    private static final String _PROJECT_REPOS_DELETED = "webappconfig.metadatasrv.repos.delete.inform.txt";
    private static final String _PROJECT_REPOS_DELETE_ERROR = "webappconfig.metadatasrv.repos.delete.error.txt";
    private static final String _CREATED_SERVER_WORKSPACE = "webappconfig.metadatasrv.server.workspace.inform.txt";
    private static final String _SERVER_WORKSPACE_EXCEPTION = "webappconfig.metadatasrv.server.workspace.error.txt";
    private static final String _METADATA_SERVER_CONNECTION = "webappconfig.metadatasrv.connect.omr.inform.txt";
    private static final String _SERVER_MIGRATION_FAILURE = "webappconfig.metadatasrv.migrate.server.error.txt";
    private static final String _SERVER_MIGRATION_WARNING = "webappconfig.metadatasrv.migrate.server.warning.txt";
    private static final String _SERVER_MIGRATION_COMPLETE = "webappconfig.metadatasrv.migrate.server.inform.txt";
    private static final String _IOM_CONNECTION_FAILURE = "webappconfig.metadatasrv.connect.iom.error.txt";
    private static final String _OMR_CONNECTION_EXCEPTION = "webappconfig.metadatasrv.connect.omr.error.txt";
    private static final String _SERVER_CONNECTION_CLOSED = "webappconfig.metadatasrv.connect.close.inform.txt";
    private static final String _SERVER_CONNECTION_EXCEPTION = "webappconfig.metadatasrv.connect.close.error.txt";
    private static final String _SERVER_VERSION_MESSAGE = "webappconfig.metadatasrv.server.version.inform.txt";
    private static final String _RPOSMGR_VERSION_MESSAGE = "webappconfig.metadatasrv.rposmgr.version.inform.txt";
    private static final String _RPOSMGR_MIGRATION_COMPLETE = "webappconfig.metadatasrv.migrate.rposmgr.inform.txt";
    private static final String _SERVER_CONTROL_REMOTE_EXCEPTION = "webappconfig.metadatasrv.iserver.error.rmxcpt.txt";
    private static final String _SERVER_CONTROL_MDEXCEPTION = "webappconfig.metadatasrv.iserver.error.mdxcpt.txt";
    private static final String _RPOSMGR_MIGRATION_REMOTE_EXCEPTION = "webappconfig.metadatasrv.rposmgr.error.rmxcpt.txt";
    private static final String _RPOSMGR_MIGRATION_MDEXCEPTION = "webappconfig.metadatasrv.rposmgr.error.mdxcpt.txt";
    private static final String _GET_REPOSITORIES_EXCEPTION = "webappconfig.metadatasrv.migrate.getrpos.error.txt";
    private static final String _REPOSITORY_PATH_UPDATED = "webappconfig.metadatasrv.migrate.rpospath.inform.txt";
    private static final String _REPOSITORY_PATH_MIGRATION_EXCEPTION = "webappconfig.metadatasrv.migrate.rpospath.error.txt";
    private static final String _REPOSITORY_PATH_MIGRATION_COMPLETE = "webappconfig.metadatasrv.migrate.allpaths.inform.txt";
    private static final String _RPOSMGR_ACCESS_MODE_ONLINE = "webappconfig.metadatasrv.online.rposmgr.inform.txt";
    private static final String _RPOSMGR_ONLINE_REMOTE_EXCEPTION = "webappconfig.metadatasrv.online.error.rmxcpt.txt";
    private static final String _METADATASRV_GENERIC_ERROR = "webappconfig.metadatasrv.migrate.error.generr.txt";
    private static final String _RPOSMGR_ONLINE_MDEXCEPTION = "webappconfig.metadatasrv.online.error.mdxcpt.txt";
    private static final String _EXECUTING_RUNTIME_PROCESS_INFO = "webappconfig.metadatasrv.secrpt.rtproc.inform.txt";
    private static final String _FILE_NOT_FOUND_EXCEPTION = "webappconfig.metadatasrv.file.not.found.error.txt";
    private static final String _UNSUPPORTED_ENCODING_EXCEPTION = "webappconfig.metadatasrv.unsupported.encoding.error.txt";
    private static final String _METADATASRV_IO_EXCEPTION = "webappconfig.metadatasrv.io.exception.error.txt";
    private static final String _RUNTIME_PROCESS_INTERRUPT_EXCEPTION = "webappconfig.metadatasrv.secrpt.ntxcpt.error.txt";
    private static final String _RUNTIME_PROCESS_EXECUTION_ERROR = "webappconfig.metadatasrv.secrpt.report.error.txt";
    private static final String _UPGRADE_REPOSITORIES_COMPLETE = "webappconfig.metadatasrv.upgrad.driver.inform.txt";
    private static final String _UPGRADE_REPOSITORIES_WARNING = "webappconfig.metadatasrv.upgrad.driver.warning.txt";
    private static final String _UPGRADE_REPOSITORIES_NONFATAL_ERROR = "webappconfig.metadatasrv.upgrad.driver.error.txt";
    private static final String _UPGRADE_REPOSITORIES_FATAL_ERROR = "webappconfig.metadatasrv.upgrad.driver.fatal.txt";
    private static final String _RUNTIME_PROCESS_LOG_EXCEPTION = "webappconfig.metadatasrv.secrpt.logxst.error.txt";
    private static final String _SECURITY_REPORT_UNSUCCESSFUL = "webappconfig.metadatasrv.secrpt.report.warning.txt";
    private static final String _SECURITY_EXTRACT_UNSUCCESSFUL = "webappconfig.metadatasrv.secrpt.xtract.warning.txt";
    private static final String _SECURITY_EXTRACT_UTF8_UNAVAILABLE = "webappconfig.metadatasrv.secrpt.xtract.noutf8.warning.txt";
    private static final String _MIGRATION_MD_EXCEPTION = "webappconfig.metadatasrv.migrate.error.mdxcpt.txt";
    private static final String _MIGRATION_REMOTE_EXCEPTION = "webappconfig.metadatasrv.migrate.error.rmxcpt.txt";
    private static final String _MIGRATION_GENERIC_EXCEPTION = "webappconfig.metadatasrv.migrate.error.except.txt";
    private static final String _MIGRATION_EXCEPTION_DISCLAIMER = "webappconfig.metadatasrv.migrate.error.disclaimer.txt";
    private static final String _USER_ADDED_INFORM = "webappconfig.metadatasrv.migrate.user.added.inform.txt";
    private static final String _USER_ADDED_ERROR = "webappconfig.metadatasrv.migrate.user.added.error.txt";
    private static final String _DUPLICATE_LOGIN_ERROR = "webappconfig.metadatasrv.migrate.login.duplicate.error.txt";
    private static final String _PERSON_ALREADY_UPDATED = "webappconfig.metadatasrv.migrate.person.already.updated.inform.txt";
    private static final String _PERSON_UPDATE_UNNECESARY = "webappconfig.metadatasrv.migrate.person.update.noreq.inform.txt";
    private static final String _PERSON_UPDATED_INFORM = "webappconfig.metadatasrv.migrate.person.updated.inform.txt";
    private static final String _PERSON_UPDATED_ERROR = "webappconfig.metadatasrv.migrate.person.updated.error.txt";
    private static final String _CANDIDATE_PERSON_ERROR = "webappconfig.metadatasrv.migrate.person.candidate.error.txt";
    private static final String _MULTIPLE_PERSON_ERROR = "webappconfig.metadatasrv.migrate.person.multiple.error.txt";
    private static final String _INTERNALLOGIN_CREATED_INFORM = "webappconfig.metadatasrv.migrate.internallogin.created.inform.txt";
    private static final String _INTERNALLOGIN_DELETED_INFORM = "webappconfig.metadatasrv.migrate.internallogin.deleted.inform.txt";
    private static final String _LOGIN_ADDED_INFORM = "webappconfig.metadatasrv.migrate.login.added.inform.txt";
    private static final String _LOGIN_ADDED_ERROR = "webappconfig.metadatasrv.migrate.login.added.error.txt";
    private static final String _LOGIN_DELETED_INFORM = "webappconfig.metadatasrv.migrate.login.deleted.inform.txt";
    private static final String _LOGIN_DELETED_ERROR = "webappconfig.metadatasrv.migrate.login.deleted.error.txt";
    private static final String _LOGIN_UPDATED_INFORM = "webappconfig.metadatasrv.migrate.login.updated.inform.txt";
    private static final String _LOGIN_UPDATED_ERROR = "webappconfig.metadatasrv.migrate.login.updated.error.txt";
    private static final String _SAS_ADMIN_ACCOUNT_SUMMARY = "webappconfig.metadatasrv.migrate.summary.account.admin.txt";
    private static final String _SAS_DEMO_ACCOUNT_SUMMARY = "webappconfig.metadatasrv.migrate.summary.account.demo.txt";
    private static final String _SAS_TRUSTED_ACCOUNT_SUMMARY = "webappconfig.metadatasrv.migrate.summary.account.trustusr.txt";
    private static final String _SAS_LOGIN_LIST_SUMMARY = "webappconfig.metadatasrv.migrate.summary.account.loginlist.txt";
    private static final String _SAS_ACCOUNT_LOGIN_LIST = "webappconfig.metadatasrv.migrate.docpart.login.list.txt";
    private static final String _SAS_ACCOUNT_FRAGMENT_LOGIN = "webappconfig.metadatasrv.migrate.docpart.fragment.login.txt";
    private static final String _SAS_ACCOUNT_FRAGMENT_AUTHDOMAIN = "webappconfig.metadatasrv.migrate.docpart.fragment.authdomain.txt";
    private static final String _GROUP_MEMBER_ASSIGNMENT = "webappconfig.metadatasrv.migrate.admin.users.inform.txt";
    private static final String _ASSIGNED_GROUP_MEMBER = "webappconfig.metadatasrv.migrate.group.assign.inform.txt";
    private static final String _GROUP_MEMBER_WARNING = "webappconfig.metadatasrv.migrate.group.assign.warning.txt";
    private static final String _EXISTING_GROUP_MEMBER = "webappconfig.metadatasrv.migrate.group.member.inform.txt";
    private static final String _USERID_NOT_IN_METADATA = "webappconfig.metadatasrv.migrate.userid.noexist.inform.txt";
    private static final String _ADMIN_USER_RESTRICTED = "webappconfig.metadatasrv.migrate.admin.restricted.inform.txt";
    private static final String _MIGRATE_SERVER_DEFINITION = "webappconfig.metadatasrv.migrate.server.definition.inform.txt";
    private static final String _ASSIGNED_SERVER_HOST = "webappconfig.metadatasrv.migrate.server.host.inform.txt";
    private static final String _SERVER_HOST_WARNING = "webappconfig.metadatasrv.migrate.server.host.warning.txt";
    private static final String _ASSIGNED_SERVER_PORT = "webappconfig.metadatasrv.migrate.server.port.inform.txt";
    private static final String _SERVER_PORT_WARNING = "webappconfig.metadatasrv.migrate.server.port.warning.txt";
    private static final String _ASSIGNED_CLIENT_CONNECTION = "webappconfig.metadatasrv.migrate.client.connection.inform.txt";
    private static final String _CLIENT_CONNECTION_WARNING = "webappconfig.metadatasrv.migrate.client.connection.warning.txt";
    private static final String _ASSIGNED_LB_TRANSFORMATION = "webappconfig.metadatasrv.migrate.lb.transformation.inform.txt";
    private static final String _LB_TRANSFORMATION_WARNING = "webappconfig.metadatasrv.migrate.lb.transformation.warning.txt";
    private static final String _ASSIGNED_CONNECTION_PORT = "webappconfig.metadatasrv.migrate.connection.port.inform.txt";
    private static final String _CONNECTION_PORT_WARNING = "webappconfig.metadatasrv.migrate.connection.port.warning.txt";
    private static final String _MIGRATED_SERVER_DEFINITION = "webappconfig.metadatasrv.migrate.server.migrate.inform.txt";
    private static final String _SERVER_DEFINITION_WARNING = "webappconfig.metadatasrv.migrate.server.migrate.warning.txt";
    private static final String _MIGRATE_LOGICAL_SERVER = "webappconfig.metadatasrv.migrate.logical.server.inform.txt";
    private static final String _UPGRADED_LOGICAL_SERVER = "webappconfig.metadatasrv.migrate.logical.server.upgrade.txt";
    private static final String _LOGICAL_SERVER_WARNING = "webappconfig.metadatasrv.migrate.logical.server.warning.txt";
    private static final String _CLEANUP_SERVER_DEFINITIONS = "webappconfig.metadatasrv.migrate.server.definition.cleanup.txt";
    private static final String _TARGET_SERVER_COMPONENT = "webappconfig.metadatasrv.migrate.server.component.inform.txt";
    private static final String _SERVER_COMPONENT_REPLACEMENT = "webappconfig.metadatasrv.migrate.server.replaced.inform.txt";
    private static final String _PARENT_OBJECT_CHANGED = "webappconfig.metadatasrv.migrate.parent.changed.inform.txt";
    private static final String _ORPHAN_OBJECT_WARNING = "webappconfig.metadatasrv.migrate.orphan.object.warning.txt";
    private static final String _METADATA_OBJECT_DELETED = "webappconfig.metadatasrv.migrate.object.deleted.inform.txt";
    private static final String _PROJECT_REPOS_CLEAN_INFORM = "webappconfig.metadatasrv.project.repos.clean.inform.txt";
    private static final String _BACKUP_RESTORE_CLEAN_INFORM = "webappconfig.metadatasrv.backup.restore.clean.inform.txt";
    private static final String _PROJECT_REPOS_OWNER_INFORM = "webappconfig.metadatasrv.project.repos.owner.inform.txt";
    private static final String _PROJECT_REPOS_GROUP_ERROR = "webappconfig.metadatasrv.project.repos.owngrp.error.txt";
    private static final String _PROJECT_REPOS_OWNER_ERROR = "webappconfig.metadatasrv.project.repos.owner.error.txt";
    private static final String _PROJECT_REPOS_OWNER_EXCEPT = "webappconfig.metadatasrv.project.repos.owner.error.except.txt";
    private static final String _PROJECT_REPOS_DELETE_INFORM = "webappconfig.metadatasrv.project.repos.delete.inform.txt";
    private static final String _PROJECT_REPOS_DELETE_EXCEPT = "webappconfig.metadatasrv.project.repos.delete.error.except.txt";
    private static final String _PROJECT_REPOS_REINIT_INFORM = "webappconfig.metadatasrv.project.repos.reinit.inform.txt";
    private static final String _PROJECT_REPOS_REINIT_EXCEPT = "webappconfig.metadatasrv.project.repos.reinit.error.except.txt";
    private static final String _PROJECT_REPOS_UNLOCK_INFORM = "webappconfig.metadatasrv.project.repos.unlock.inform.txt";
    private static final String _PROJECT_REPOS_UNLOCK_MDXCPT = "webappconfig.metadatasrv.project.repos.unlock.error.mdxcpt.txt";
    private static final String _PROJECT_REPOS_UNLOCK_RMXCPT = "webappconfig.metadatasrv.project.repos.unlock.error.rmxcpt.txt";
    private static final String _PROJECT_REPOS_UPGRADE_INFORM = "webappconfig.metadatasrv.project.repos.upgrad.inform.txt";
    private static final String _PROJECT_REPOS_UPGRADE_EXCEPT = "webappconfig.metadatasrv.project.repos.upgrad.error.except.txt";
    private static final String _MIGRATION_QUERY_EXCEPTION = "webappconfig.metadatasrv.migrate.query.error.except.txt";
    private static final String _FILE_READ_MEMBERS = "webappconfig.metadatasrv.migrate.file.users.retrieve.txt";
    private static final String _FILE_MEMBER_UPDATE = "webappconfig.metadatasrv.migrate.file.users.update.inform.txt";
    private static final String _FILE_WRITE_MEMBERS = "webappconfig.metadatasrv.migrate.file.users.update.txt";
    private static final String _FILE_MEMBER_DUPLICATE = "webappconfig.metadatasrv.migrate.file.users.duplicate.warn.txt";
    private static final String _FILE_MEMBER_UPDATE_COUNT = "webappconfig.metadatasrv.migrate.file.users.update.total.txt";
    private static final String _FILE_READ_UNSUCCESSFUL = "webappconfig.objectspawnr.read.error.txt";
    private static final String _FILE_READ_UNSUCCESSFUL_FILENAME = "webappconfig.objectspawnr.file.read.error.txt";
    private static final String _FILE_CREATION_UNSUCCESSFUL = "webappconfig.objectspawnr.file.create.error.txt";
    private static final String _INTERNAL_ACCOUNT_FAILURE = "webappconfig.metadatasrv.internal.account.error.txt";
    private static final String _INTERNAL_ACCOUNT_WARNING = "webappconfig.metadatasrv.internal.account.warning.txt";
    private static final String _INTERNAL_ACCOUNT_COMPLETE = "webappconfig.metadatasrv.internal.account.inform.txt";
    private static final String _INTERNAL_ACCOUNT_GENERR = "webappconfig.metadatasrv.internal.account.generr.txt";
    private static final String _INTERNAL_ACCOUNT_EXCEPTION = "webappconfig.metadatasrv.internal.account.exception.txt";
    private static final String _INTERNAL_ACCOUNT_RETRIEVED = "webappconfig.metadatasrv.internal.account.retrieved.txt";
    private static final String _INTERNAL_ACCOUNT_LOCKOUT_OVERRIDE = "webappconfig.metadatasrv.internal.account.lockout.option.txt";
    private static final String _INTERNAL_ACCOUNT_PASSWORD_OVERRIDE = "webappconfig.metadatasrv.internal.account.password.option.txt";
    private static final String _INTERNAL_ACCOUNT_UPDATED = "webappconfig.metadatasrv.internal.account.updated.txt";
    private static final String _SECURITY_INTERFACE_ACQUIRED = "webappconfig.metadatasrv.security.interface.acquired.txt";
    private static final String _SECURITY_INTERFACE_FAILURE = "webappconfig.metadatasrv.security.interface.error.txt";

    private ErrorHandling() {
    }

    public static String generateCannotCopyDirectoryErrorMessage(Task task, File inFile) {
        return Localization.processFormat(task, _CANNOT_COPY_DIRECTORY, inFile);
    }

    public static String generateCannotCopyFileErrorMessage(Task task, File inFile, File outFile) {
        return Localization.processFormat(task, _CANNOT_COPY_FILE, inFile, outFile);
    }

    public static String generateCannotCreateDirectoryErrorMessage(Task task, File directory) {
        return Localization.processFormat(task, _CANNOT_CREATE_DIRECTORY, directory);
    }

    public static String generateCannotCreateLogFileErrorMessage(Task task, String logFileName) {
        return Localization.processFormat(task, _CANNOT_CREATE_LOG_FILE, logFileName);
    }

    public static String generateCannotDeleteFileErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _CANNOT_DELETE_FILE, filename);
    }

    public static String generateCannotExpandPropertyErrorMessage(Task task, String property) {
        return Localization.processFormat(task, _CANNOT_EXPAND_PROPERTY, property);
    }

    public static String generateCannotOpenFileErrorMessage(Task task, File outFile) {
        return Localization.processFormat(task, _CANNOT_OPEN_FILE, outFile);
    }

    public static String generateCannotOpenFileErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _CANNOT_OPEN_FILE, filename);
    }

    public static String generateCannotProcessExpansionErrorMessage(Task task, String expansion) {
        return Localization.processFormat(task, _CANNOT_PROCESS_EXPANSION, expansion);
    }

    public static String generateCannotProcessExpansionsErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _CANNOT_PROCESS_EXPANSIONS, filename);
    }

    public static String generateCannotReadFileErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _CANNOT_READ_FILE, filename);
    }

    public static String generateCannotProcessPasswordRuleErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_PROCESS_PASSWORD_RULE);
    }

    public static String generateCannotProcessScriptErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _CANNOT_PROCESS_SCRIPT, filename);
    }

    public static String generateCannotProcessSubstitutionsErrorMessage(Task task, String oldFilename, String newFilename) {
        return Localization.processFormat(task, _CANNOT_PROCESS_SUBSTITUTIONS, oldFilename, newFilename);
    }

    public static String generateCannotRenameFileErrorMessage(Task task, String oldName, String newName) {
        return Localization.processFormat(task, _CANNOT_RENAME_FILE, oldName, newName);
    }

    public static String generateCannotWriteToLogFileErrorMessage(Task task, String logFileName) {
        return Localization.processFormat(task, _CANNOT_WRITE_TO_LOG_FILE, logFileName);
    }

    public static String generateCopyingDirectoryInfoMessage(Task task, File from, File to) {
        return Localization.processFormat(task, _COPYING_DIRECTORY, from, to);
    }

    public static String generateDirectoryIsNotADirectoryErrorMessage(Task task, File directory) {
        return Localization.processFormat(task, _DIRECTORY_IS_NOT_A_DIRECTORY, directory);
    }

    public static String generateDirectoryNumberMismatchErrorMessage(Task task, String list1, String list2) {
        return Localization.processFormat(task, _DIRECTORY_NUMBER_MISMATCH, list1, list2);
    }

    public static String generateEmptyParameterErrorMessage(Task task, int count, String parameterName) {
        return Localization.processFormat(task, _EMPTY_PARAMETER, new Integer(count), parameterName);
    }

    public static String generateExecutingTaskInfoMessage(Task task, String taskIdentifier) {
        return Localization.processFormat(task, _EXECUTING_TASK, taskIdentifier);
    }

    public static String generateCannotRedefinePropertyErrorMessage(Task task, String property) {
        return Localization.processFormat(task, _CANNOT_REDEFINE_PROPERTY, property);
    }

    public static String generateFileNumberMismatchErrorMessage(Task task, String list1, String list2) {
        return Localization.processFormat(task, _FILE_NUMBER_MISMATCH, list1, list2);
    }

    public static String generateImbalancedDelimitersErrorMessage(Task task, String line, String filename) {
        return Localization.processFormat(task, _IMBALANCED_DELIMITERS, line, filename);
    }

    public static String generateMissingParameterErrorMessage(Task task, String paramName) {
        return Localization.processFormat(task, _MISSING_PARAMETER, paramName);
    }

    public static String generateNoPropertiesFilesDefinedErrorMessage(Task task) {
        return Localization.getString(task, _NO_PROPERTIES_FILES_DEFINED);
    }

    public static String generateProcessingFileInfoMessage(Task task, String filename) {
        return Localization.processFormat(task, _PROCESSING_FILE, filename);
    }

    public static String generatePropertyUndefinedErrorMessage(Task task, String property) {
        return Localization.processFormat(task, _PROPERTY_UNDEFINED, property);
    }

    public static String generateUnexpectedExceptionErrorMessage(Task task) {
        return Localization.getString(task, _UNEXPECTED_EXCEPTION);
    }

    public static String generateValidatingDirectoryInfoMessage(Task task, File directory) {
        return Localization.processFormat(task, _VALIDATING_DIRECTORY, directory);
    }

    public static String generateValidatingXMLFileInfoMessage(Task task, String filename) {
        return Localization.processFormat(task, _VALIDATING_XML_FILE, filename);
    }

    public static String generateIncompatibleJarErrorMessage(Task task, File file) {
        return Localization.processFormat(task, _INCOMPATIBLE_JAR, file);
    }

    public static String generateLoopInPropertiesErrorMessage(Task task, String propertyName) {
        return Localization.processFormat(task, _LOOP_IN_PROPERTIES, propertyName);
    }

    public static String generateInvalidWarFileNameErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _INVALID_WAR_FILE_NAME, filename);
    }

    public static String generateMissingBaseErrorMessage(Task task) {
        return Localization.getString(task, _MISSING_BASE);
    }

    public static String generateMisconfiguredPropertySourceReferenceErrorMessage(Task task) {
        return Localization.getString(task, _MISCONFIGURED_PROPERTYSOURCEREFERENCE);
    }

    public static String generatePasswordListingHeader(Task task) {
        return Localization.getString(task, _PASSWORD_LISTING_HEADER);
    }

    public static String generatePasswordListingItem(Task task, String userid, String password, String filename) {
        return Localization.processFormat(task, _PASSWORD_LISTING_ITEM, userid, password, filename);
    }

    public static String generatePercentCompleteInfoMessage(Task task, int percentage) {
        return Localization.processFormat(task, _PERCENT_COMPLETE, new Integer(percentage));
    }

    public static String generateWarfileDoesNotExistErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _WARFILE_DOES_NOT_EXIST, filename);
    }

    public static String generateCannotReadFileErrorMessage(Task task, File file) {
        return Localization.processFormat(task, _CANNOT_READ_FILE, file);
    }

    public static String generateDidNotFindStringErrorMessage(Task task, String str, String filename) {
        return Localization.processFormat(task, _DID_NOT_FIND_STRING, str, filename);
    }

    public static String generateFoundExcludedStringErrorMessage(Task task, String str, String filename) {
        return Localization.processFormat(task, _FOUND_EXCLUDED_STRING, str, filename);
    }

    public static String generateCannotAddEntryErrorMessage(Task task, String entryName) {
        return Localization.processFormat(task, _CANNOT_ADD_ENTRY, entryName);
    }

    public static String generateCannotAddEntryErrorMessage(Task task, File entry) {
        return Localization.processFormat(task, _CANNOT_ADD_ENTRY, entry);
    }

    public static String generateIgnoringWarFileInfoMEssage(Task task) {
        return Localization.getString(task, _IGNORING_WAR_FILE);
    }

    public static String generateProcessingDirectoryInfoMessage(Task task, File file) {
        return Localization.processFormat(task, _PROCESSING_DIRECTORY, file);
    }

    public static String generateAppendingToLogFileInfoMessage(Task task, String filename) {
        return Localization.processFormat(task, _APPENDING_TO_LOG_FILE, filename);
    }

    public static String generateWebLogicPathInfoMessage(Task task, File directory) {
        return Localization.processFormat(task, _WEB_LOGIC_PATH, directory);
    }

    public static String generateUndefinedOptionalPropertiesWarningMessage(Task task, Set properties, PropertySourceInterface source) {
        return Localization.processFormat(task, _UNDEFINED_OPTIONAL_PROPERTIES, ErrorHandling.setToString(properties), source);
    }

    public static String generateUndefinedRequiredPropertiesErrorMessage(Task task, Set properties, PropertySourceInterface source) {
        return Localization.processFormat(task, _UNDEFINED_REQUIRED_PROPERTIES, ErrorHandling.setToString(properties), source);
    }

    private static StringBuffer setToString(Set properties) {
        int bufferSize = _COMMA.length() * (properties.size() - 1);
        for (String property : properties) {
            bufferSize += property.length();
        }
        StringBuffer propertiesBuffer = new StringBuffer(bufferSize);
        boolean first = true;
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            if (!first) {
                propertiesBuffer.append(_COMMA);
            }
            first = false;
            propertiesBuffer.append(iter.next());
        }
        return propertiesBuffer;
    }

    public static String generateInvalidParameterValueErrorMessage(Task task, String on_error_parameter, String onerror) {
        return Localization.processFormat(task, _INVALID_PARAMETER_VALUE, on_error_parameter, onerror);
    }

    public static String generateMissingPropertiesErrorMessage(Task task, String refid) {
        return Localization.processFormat(task, _MISSING_PROPERTIES, refid);
    }

    public static String generateMissingPropertyErrorMessage(Task task, String property, PropertySourceInterface source) {
        return Localization.processFormat(task, _MISSING_PROPERTY, property, source);
    }

    public static String generatePropertyShouldHaveValue(Task task, String property, String value, PropertySourceInterface source) {
        return Localization.processFormat(task, _PROPERTY_SHOULD_HAVE_VALUE, property, source, value);
    }

    public static String generatePropertyIsNotDirectory(Task task, String value, String propertyName) {
        return Localization.processFormat(task, _PROPERTY_IS_NOT_DIRECTORY, value, propertyName);
    }

    public static String generatePropertySetMessage(Task task, String property, String setting) {
        return Localization.processFormat(task, _PROPERTY_SET, property, setting);
    }

    public static String generateDuplicateNamespaceSourceErrorMessage(Task task, String namespace, PropertySourceInterface oldSource, PropertySourceInterface source) {
        return Localization.processFormat(task, _DUPLICATE_NAMESPACE_SOURCE, namespace, oldSource, source);
    }

    public static PropertySourceInterface generateNoPropertySourcesKnownErrorMessage(Task task) {
        return new FilePropertySource(Localization.getString(task, _NO_PROPERTY_SOURCES_KNOWN), false);
    }

    public static String generateStrippingRootContextMessage(Task task, String filename) {
        return Localization.processFormat(task, _STRIPPING_ROOT_CONTEXT, filename);
    }

    public static String generateDeprecatedAttributeWarningMessage(Task task, String preferredAttr, String deprecatedAttr) {
        return Localization.processFormat(task, _DEPRECATED_ATTRIBUTE, preferredAttr, deprecatedAttr);
    }

    public static String getVersionSpecDescription(VersionSpec version) {
        return version.isRange() ? version.toRangeString(false) : version.toVersionString();
    }

    public static String generateCannotAccessVJRErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_ACCESS_VJR);
    }

    public static String generateLoadingVersionedJarInfoMessage(Task task, String pluginName, VersionSpec pluginVersion) {
        return Localization.processFormat(task, _LOADING_VERSIONED_JAR, pluginName, ErrorHandling.getVersionSpecDescription(pluginVersion));
    }

    public static String generateLoadingVersionedJarFileInfoMessage(Task task, File file) {
        return Localization.processFormat(task, _LOADING_VERSIONED_JAR_FILE, file.getName());
    }

    public static String generateCannotConnectToSASMetadataServerErrorMessage(Task task, String host, String port) {
        return Localization.processFormat(task, _CANNOT_CONNECT_TO_SAS_METADATA_SERVER, host, port);
    }

    public static String generateCannotAccessSASMetadataServerErrorMessage(Task task, String host, String port) {
        return Localization.processFormat(task, _CANNOT_ACCESS_SAS_METADATA_SERVER, host, port);
    }

    public static String generateCannotFindSASMasterConfigurationErrorMessage(Task task, String repositoryName) {
        return Localization.processFormat(task, _CANNOT_FIND_SAS_MASTER_CONFIGURATION, repositoryName);
    }

    public static String generateMultipleConfigurationPropertyGroupsDetectedErrorMessage(Task task) {
        return Localization.getString(task, _MULTIPLE_CONFIGURATION_PROPERTYGROUPS_DETECTED);
    }

    public static String generateCannotAccessPropertiesErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_ACCESS_PROPERTIES);
    }

    public static String generateCannotGetListOfAvailableRepositoriesErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_GET_LIST_OF_AVAILABLE_REPOSITORIES);
    }

    public static String generateCannotFindRepositoryErrorMessage(Task task, String repositoryName) {
        return Localization.processFormat(task, _CANNOT_FIND_REPOSITORY, repositoryName);
    }

    public static String generateCannotReusePropertySourceListId(Task task, String id) {
        return Localization.processFormat(task, _CANNOT_REUSE_PROPERTYSOURCELIST_ID, id);
    }

    public static String generateCannotFindContentInVJRErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_FIND_CONTENT_IN_VJR);
    }

    public static String generateCannotEncryptNullPasswordErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_ENCRYPT_NULL_PASSWORD);
    }

    public static String generateCannotEncryptPasswordErrorMessage(Task task) {
        return Localization.getString(task, _CANNOT_ENCRYPT_PASSWORD);
    }

    public static String generateNoFilesFoundMatchingPatternWarning(Task task, String pattern) {
        return Localization.processFormat(task, _NO_FILES_FOUND_MATCHING_PATTERN, pattern);
    }

    public static String generatePasswordDefinitionNotFoundInFile(Task task, Pattern pattern, String filename) {
        return Localization.processFormat(task, _PASSWORD_DEFINITION_NOT_FOUND_IN_FILE, pattern, filename);
    }

    public static String generateNoPasswordsChangedInfoMessage(Task task) {
        return Localization.getString(task, _NO_PASSWORDS_CHANGED);
    }

    public static String generateNoPasswordsFoundInFileErrorMessage(Task task, String filename) {
        return Localization.processFormat(task, _NO_PASSWORDS_FOUND_IN_FILE, filename);
    }

    public static String generateNoChangesMadeToFileMessage(Task task, String filename) {
        return Localization.processFormat(task, _NO_CHANGES_MADE_TO_FILE, filename);
    }

    public static String generatePasswordChangedMessage(Task task, String userid, String filename) {
        return Localization.processFormat(task, _PASSWORD_CHANGED, userid, filename);
    }

    public static String generateCannotWriteToFileErrorMessage(Task task, File file) {
        return Localization.processFormat(task, _CANNOT_WRITE_TO_FILE, file);
    }

    public static String generateUnrecognizedKeywordInFileErrorMessage(Task task, String keyword, File file) {
        return Localization.processFormat(task, _UNRECOGNIZED_KEYWORD_IN_FILE, keyword, file);
    }

    public static String generateUnrecognizedSyntaxInFileErrorMessage(Task task, String line, File file) {
        return Localization.processFormat(task, _UNRECOGNIZED_SYNTAX_IN_FILE, line, file);
    }

    public static String generateCannotValidatePasswordErrorMessage(Task task, String userid, String hostname, String port, Object why) {
        return Localization.processFormat(task, _CANNOT_VALIDATE_PASSWORD, userid, hostname, port, why);
    }

    public static String generateCannotValidatePasswordReasonText(Task task, String errorType, String errorMessage) {
        return Localization.processFormat(task, _CANNOT_VALIDATE_PASSWORD_REASON, errorType, errorMessage);
    }

    public static String generateMissingPortIDErrorMessage(Task task) {
        return Localization.getString(task, _MISSING_PORT_ID);
    }

    public static String generateMissingServerNameErrorMessage(Task task) {
        return Localization.getString(task, _MISSING_SERVER_NAME);
    }

    public static String generateTimeoutReadingPicklistErrorMessage(Task task) {
        return Localization.getString(task, _TIMEOUT_TRYING_READING_PICKLIST);
    }

    public static String generateTimeoutAccessingRepositoryErrorMessage(Task task) {
        return Localization.getString(task, _TIMEOUT_TRYING_ACCESSING_REPOSITORY);
    }

    public static String generateTimeoutReadingRepositoryErrorMessage(Task task) {
        return Localization.getString(task, _TIMEOUT_TRYING_READING_REPOSITORY);
    }

    public static String generateRposMgrPathErrorMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_DOES_NOT_EXIST);
    }

    public static String generateRepositoryLocationInfoMessage(Task task, String repositoryPath) {
        return Localization.processFormat(task, _REPOS_LOCATION_INFORMATION, repositoryPath);
    }

    public static String generateRepositoryLocationErrorMessage(Task task, String repositoryPath) {
        return Localization.processFormat(task, _REPOS_LOCATION_DOES_NOT_EXIST, repositoryPath);
    }

    public static String generateRepositoryPathErrorMessage(Task task, String repositoryName, String repositoryPath) {
        return Localization.processFormat(task, _REPOS_PATH_DOES_NOT_EXIST, repositoryName, repositoryPath);
    }

    public static String generateRepositoryDeleteInformMessage(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_DELETED, repositoryName);
    }

    public static String generateRepositoryDeleteErrorMessage(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_DELETE_ERROR, repositoryName);
    }

    public static String generateMetadataServerWorkspaceInfoMessage(Task task) {
        return Localization.getString(task, _CREATED_SERVER_WORKSPACE);
    }

    public static String generateMetadataServerWorkspaceErrorMessage(Task task) {
        return Localization.getString(task, _SERVER_WORKSPACE_EXCEPTION);
    }

    public static String generateMetadataServerConnectionInfoMessage(Task task, String hostname, String port, String userid) {
        return Localization.processFormat(task, _METADATA_SERVER_CONNECTION, hostname, port, userid);
    }

    public static String generateMetadataServerMigrationErrorMessage(Task task) {
        return Localization.getString(task, _SERVER_MIGRATION_FAILURE);
    }

    public static String generateMetadataServerMigrationWarningMessage(Task task) {
        return Localization.getString(task, _SERVER_MIGRATION_WARNING);
    }

    public static String generateMetadataServerMigrationInfoMessage(Task task) {
        return Localization.getString(task, _SERVER_MIGRATION_COMPLETE);
    }

    public static String generateIOMServerConnectionErrorMessage(Task task) {
        return Localization.getString(task, _IOM_CONNECTION_FAILURE);
    }

    public static String generateOMRServerConnectionErrorMessage(Task task) {
        return Localization.getString(task, _OMR_CONNECTION_EXCEPTION);
    }

    public static String generateMetadataServerCloseConnectionInfoMessage(Task task) {
        return Localization.getString(task, _SERVER_CONNECTION_CLOSED);
    }

    public static String generateMetadataServerConnectionErrorMessage(Task task) {
        return Localization.getString(task, _SERVER_CONNECTION_EXCEPTION);
    }

    public static String generateMetadataServerVersionInfoMessage(Task task, int version) {
        return Localization.processFormat(task, _SERVER_VERSION_MESSAGE, new Integer(version));
    }

    public static String generateRepositoryManagerVersionInfoMessage(Task task, int version) {
        return Localization.processFormat(task, _RPOSMGR_VERSION_MESSAGE, new Integer(version));
    }

    public static String generateRepositoryManagerMigrationInfoMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_MIGRATION_COMPLETE);
    }

    public static String generateServerControlRemoteXcptErrorMessage(Task task) {
        return Localization.getString(task, _SERVER_CONTROL_REMOTE_EXCEPTION);
    }

    public static String generateServerControlMdXcptErrorMessage(Task task) {
        return Localization.getString(task, _SERVER_CONTROL_MDEXCEPTION);
    }

    public static String generateRposMgrMigrationRemoteXcptErrorMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_MIGRATION_REMOTE_EXCEPTION);
    }

    public static String generateRposMgrMigrationMdXcptErrorMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_MIGRATION_MDEXCEPTION);
    }

    public static String generateGetRepositoriesErrorMessage(Task task) {
        return Localization.getString(task, _GET_REPOSITORIES_EXCEPTION);
    }

    public static String generateRepositoryPathMigrationInfoMessage(Task task, String repositoryName, String repositoryPath) {
        return Localization.processFormat(task, _REPOSITORY_PATH_UPDATED, repositoryName, repositoryPath);
    }

    public static String generate(Task task) {
        return Localization.getString(task, _REPOSITORY_PATH_MIGRATION_EXCEPTION);
    }

    public static String generateRepositoryPathsUpdatedInfoMessage(Task task) {
        return Localization.getString(task, _REPOSITORY_PATH_MIGRATION_COMPLETE);
    }

    public static String generateRepositoryManagerOnlineInfoMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_ACCESS_MODE_ONLINE);
    }

    public static String generateRposMgrOnlineRemoteXcptErrorMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_ONLINE_REMOTE_EXCEPTION);
    }

    public static String generateGenericErrorMessage(Task task) {
        return Localization.getString(task, _METADATASRV_GENERIC_ERROR);
    }

    public static String generateRposMgrOnlineMdXcptErrorMessage(Task task) {
        return Localization.getString(task, _RPOSMGR_ONLINE_MDEXCEPTION);
    }

    public static String generateExecutingRuntimeProcessInfoMessage(Task task, String commandLine) {
        return Localization.processFormat(task, _EXECUTING_RUNTIME_PROCESS_INFO, commandLine);
    }

    public static String generateFileNotFoundMessage(Task task, String path) {
        return Localization.processFormat(task, _FILE_NOT_FOUND_EXCEPTION, path);
    }

    public static String generateUnsupportedEncodingMessage(Task task, String path) {
        return Localization.processFormat(task, _UNSUPPORTED_ENCODING_EXCEPTION, path);
    }

    public static String generateIOExceptionErrorMessage(Task task, String path) {
        return Localization.processFormat(task, _METADATASRV_IO_EXCEPTION, path);
    }

    public static String generateRuntimeProcessInterruptXcptErrorMessage(Task task) {
        return Localization.getString(task, _RUNTIME_PROCESS_INTERRUPT_EXCEPTION);
    }

    public static String generateRuntimeProcessExecutionErrorMessage(Task task, String command) {
        return Localization.processFormat(task, _RUNTIME_PROCESS_EXECUTION_ERROR, command);
    }

    public static String generateUpgradeRepositoriesCompleteMessage(Task task) {
        return Localization.getString(task, _UPGRADE_REPOSITORIES_COMPLETE);
    }

    public static String generateUpgradeRepositoriesWarningMessage(Task task, String logPath) {
        return Localization.processFormat(task, _UPGRADE_REPOSITORIES_WARNING, logPath);
    }

    public static String generateUpgradeRepositoriesErrorMessage(Task task, int rc, String logPath) {
        return Localization.processFormat(task, _UPGRADE_REPOSITORIES_NONFATAL_ERROR, new Integer(rc), logPath);
    }

    public static String generateUpgradeRepositoriesFatalMessage(Task task, int rc, String logPath) {
        return Localization.processFormat(task, _UPGRADE_REPOSITORIES_FATAL_ERROR, new Integer(rc), logPath);
    }

    public static String generateRuntimeProcessLogExceptionMessage(Task task) {
        return Localization.getString(task, _RUNTIME_PROCESS_LOG_EXCEPTION);
    }

    public static String generateSecurityReportWarningMessage(Task task) {
        return Localization.getString(task, _SECURITY_REPORT_UNSUCCESSFUL);
    }

    public static String generateSecurityExtractWarningMessage(Task task) {
        return Localization.getString(task, _SECURITY_EXTRACT_UNSUCCESSFUL);
    }

    public static String generateSecurityExtractUTF8WarningMessage(Task task) {
        return Localization.getString(task, _SECURITY_EXTRACT_UTF8_UNAVAILABLE);
    }

    public static String generateMigrationMdException(Task task) {
        return Localization.getString(task, _MIGRATION_MD_EXCEPTION);
    }

    public static String generateMigrationRemoteException(Task task) {
        return Localization.getString(task, _MIGRATION_REMOTE_EXCEPTION);
    }

    public static String generateMigrationGenericException(Task task) {
        return Localization.getString(task, _MIGRATION_GENERIC_EXCEPTION);
    }

    public static String generateMigrationExceptionDisclaimer(Task task) {
        return Localization.getString(task, _MIGRATION_EXCEPTION_DISCLAIMER);
    }

    public static String generateUserAddedInformation(Task task, String userName) {
        return Localization.processFormat(task, _USER_ADDED_INFORM, userName);
    }

    public static String generateUserAddedError(Task task, String userName) {
        return Localization.processFormat(task, _USER_ADDED_ERROR, userName);
    }

    public static String generateDuplicateLoginError(Task task, String userName, String userId) {
        return Localization.processFormat(task, _DUPLICATE_LOGIN_ERROR, userName, userId);
    }

    public static String generatePersonAlreadyUpdated(Task task, String userName) {
        return Localization.processFormat(task, _PERSON_ALREADY_UPDATED, userName);
    }

    public static String generatePersonUpdateUnnecessary(Task task, String userName) {
        return Localization.processFormat(task, _PERSON_UPDATE_UNNECESARY, userName);
    }

    public static String generatePersonUpdatedInformation(Task task, String userName) {
        return Localization.processFormat(task, _PERSON_UPDATED_INFORM, userName);
    }

    public static String generatePersonUpdatedError(Task task, String userName) {
        return Localization.processFormat(task, _PERSON_UPDATED_ERROR, userName);
    }

    public static String generateCandidatePersonError(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _CANDIDATE_PERSON_ERROR, displayName, userName);
    }

    public static String generateMultiplePersonError(Task task, String userName) {
        return Localization.processFormat(task, _MULTIPLE_PERSON_ERROR, userName);
    }

    public static String generateInternalAccountCreatedInformation(Task task, String displayName) {
        return Localization.processFormat(task, _INTERNALLOGIN_CREATED_INFORM, displayName);
    }

    public static String generateInternalAccountDeletedInformation(Task task, String displayName) {
        return Localization.processFormat(task, _INTERNALLOGIN_DELETED_INFORM, displayName);
    }

    public static String generateLoginAddedInformation(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _LOGIN_ADDED_INFORM, userName, displayName);
    }

    public static String generateLoginAddedError(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _LOGIN_ADDED_ERROR, userName, displayName);
    }

    public static String generateLoginDeletedInformation(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _LOGIN_DELETED_INFORM, displayName, userName);
    }

    public static String generateLoginDeletedError(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _LOGIN_DELETED_ERROR, displayName, userName);
    }

    public static String generateLoginUpdatedInformation(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _LOGIN_UPDATED_INFORM, displayName, userName);
    }

    public static String generateLoginUpdatedError(Task task, String displayName, String userName) {
        return Localization.processFormat(task, _LOGIN_UPDATED_ERROR, displayName, userName);
    }

    public static String generateAdminAccountSummary(Task task, String displayName, String userName, String authDomain) {
        return Localization.processFormat(task, _SAS_ADMIN_ACCOUNT_SUMMARY, displayName, userName, authDomain);
    }

    public static String generateDemoAccountSummary(Task task, String displayName, String userName, String authDomain) {
        return Localization.processFormat(task, _SAS_DEMO_ACCOUNT_SUMMARY, displayName, userName, authDomain);
    }

    public static String generateTrustedAccountSummary(Task task, String displayName, String userName, String authDomain) {
        return Localization.processFormat(task, _SAS_TRUSTED_ACCOUNT_SUMMARY, displayName, userName, authDomain);
    }

    public static String generateAccountLoginListSummary(Task task) {
        return Localization.getString(task, _SAS_LOGIN_LIST_SUMMARY);
    }

    public static String generateAccountDocpartLoginList(Task task, String userName, String authDomain) {
        return Localization.processFormat(task, _SAS_ACCOUNT_LOGIN_LIST, userName, authDomain);
    }

    public static String generateAccountDocpartFragmentLogin(Task task, String loginLabel, String userName) {
        return Localization.processFormat(task, _SAS_ACCOUNT_FRAGMENT_LOGIN, loginLabel, userName);
    }

    public static String generateAccountDocpartFragmentAuthDomain(Task task, String domainLabel, String authDomain) {
        return Localization.processFormat(task, _SAS_ACCOUNT_FRAGMENT_AUTHDOMAIN, domainLabel, authDomain);
    }

    public static String generateGroupMemberAssignment(Task task) {
        return Localization.getString(task, _GROUP_MEMBER_ASSIGNMENT);
    }

    public static String generateAssignedGroupMember(Task task, String identityName, String groupName) {
        return Localization.processFormat(task, _ASSIGNED_GROUP_MEMBER, identityName, groupName);
    }

    public static String generateGroupMemberWarning(Task task, String identityName, String groupName) {
        return Localization.processFormat(task, _GROUP_MEMBER_WARNING, identityName, groupName);
    }

    public static String generateExistingGroupMember(Task task, String identityName, String groupName) {
        return Localization.processFormat(task, _EXISTING_GROUP_MEMBER, identityName, groupName);
    }

    public static String generateAdminUserNotInMetadata(Task task, String adminUserId) {
        return Localization.processFormat(task, _USERID_NOT_IN_METADATA, adminUserId);
    }

    public static String generateAdminUserNotUnrestricted(Task task, String identityName) {
        return Localization.processFormat(task, _ADMIN_USER_RESTRICTED, identityName);
    }

    public static String generateMigrateServerDefinition(Task task) {
        return Localization.getString(task, _MIGRATE_SERVER_DEFINITION);
    }

    public static String generateAssignedServerHost(Task task, String serverHost, String serverName) {
        return Localization.processFormat(task, _ASSIGNED_SERVER_HOST, serverHost, serverName);
    }

    public static String generateServerHostWarning(Task task, String serverHost, String serverName) {
        return Localization.processFormat(task, _SERVER_HOST_WARNING, serverHost, serverName);
    }

    public static String generateAssignedServerPort(Task task, String serverPort, String serverName) {
        return Localization.processFormat(task, _ASSIGNED_SERVER_PORT, serverPort, serverName);
    }

    public static String generateServerPortWarning(Task task, String serverPort, String serverName) {
        return Localization.processFormat(task, _SERVER_PORT_WARNING, serverPort, serverName);
    }

    public static String generateAssignedClientConnection(Task task, String connectionName, String serverName) {
        return Localization.processFormat(task, _ASSIGNED_CLIENT_CONNECTION, connectionName, serverName);
    }

    public static String generateClientConnectionWarning(Task task, String connectionName, String serverName) {
        return Localization.processFormat(task, _CLIENT_CONNECTION_WARNING, connectionName, serverName);
    }

    public static String generateAssignedLbTransformation(Task task, String transformationName, String clusterName) {
        return Localization.processFormat(task, _ASSIGNED_LB_TRANSFORMATION, transformationName, clusterName);
    }

    public static String generateLbTransformationWarning(Task task, String transformationName, String clusterName) {
        return Localization.processFormat(task, _LB_TRANSFORMATION_WARNING, transformationName, clusterName);
    }

    public static String generateAssignedConnectionPort(Task task, String serverPort, String connectionName) {
        return Localization.processFormat(task, _ASSIGNED_CONNECTION_PORT, serverPort, connectionName);
    }

    public static String generateConnectionPortWarning(Task task, String serverPort, String connectionName) {
        return Localization.processFormat(task, _CONNECTION_PORT_WARNING, serverPort, connectionName);
    }

    public static String generateUpgradedServerDefinition(Task task, String serverName) {
        return Localization.processFormat(task, _MIGRATED_SERVER_DEFINITION, serverName);
    }

    public static String generateServerDefinitionWarning(Task task, String serverName) {
        return Localization.processFormat(task, _SERVER_DEFINITION_WARNING, serverName);
    }

    public static String generateMigrateLogicalServer(Task task) {
        return Localization.getString(task, _MIGRATE_LOGICAL_SERVER);
    }

    public static String generateUpgradedLogicalServer(Task task, String serverName) {
        return Localization.processFormat(task, _UPGRADED_LOGICAL_SERVER, serverName);
    }

    public static String generateLogicalServerWarning(Task task, String serverName) {
        return Localization.processFormat(task, _LOGICAL_SERVER_WARNING, serverName);
    }

    public static String generateCleanupServerDefinitions(Task task) {
        return Localization.getString(task, _CLEANUP_SERVER_DEFINITIONS);
    }

    public static String generateTargetServerComponent(Task task, String metadataType, String objectName, String objectId) {
        return Localization.processFormat(task, _TARGET_SERVER_COMPONENT, metadataType, objectName, objectId);
    }

    public static String generateServerComponentReplacement(Task task, String metadataType, String objectName, String objectId, String newObjectName) {
        return Localization.processFormat(task, _SERVER_COMPONENT_REPLACEMENT, metadataType, objectName, objectId, newObjectName);
    }

    public static String generateParentObjectChanged(Task task, String metadataType, String objectName, String objectId, String newParentName) {
        return Localization.processFormat(task, _PARENT_OBJECT_CHANGED, metadataType, objectName, objectId, newParentName);
    }

    public static String generateOrphanContextWarning(Task task, String metadataType, String objectName, String objectId) {
        return Localization.processFormat(task, _ORPHAN_OBJECT_WARNING, metadataType, objectName, objectId);
    }

    public static String generateMetadataObjectDeleted(Task task, String metadataType, String objectName, String objectId) {
        return Localization.processFormat(task, _METADATA_OBJECT_DELETED, metadataType, objectName, objectId);
    }

    public static String generateProjectRepositoryCleanUp(Task task) {
        return Localization.getString(task, _PROJECT_REPOS_CLEAN_INFORM);
    }

    public static String generateBackupRestoreCleanUp(Task task) {
        return Localization.getString(task, _BACKUP_RESTORE_CLEAN_INFORM);
    }

    public static String generateProjectRepositoryOwner(Task task, String repositoryName, String ownerName) {
        return Localization.processFormat(task, _PROJECT_REPOS_OWNER_INFORM, repositoryName, ownerName);
    }

    public static String generateProjectRepositoryGroup(Task task, String repositoryName, String ownerName) {
        return Localization.processFormat(task, _PROJECT_REPOS_GROUP_ERROR, repositoryName, ownerName);
    }

    public static String generateProjectRepositoryNoOwner(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_OWNER_ERROR, repositoryName);
    }

    public static String generateProjectRepositoryOwnerXcpt(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_OWNER_EXCEPT, repositoryName);
    }

    public static String generateProjectRepositoryDelete(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_DELETE_INFORM, repositoryName);
    }

    public static String generateProjectRepositoryDeleteExcept(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_DELETE_EXCEPT, repositoryName);
    }

    public static String generateProjectRepositoryReinit(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_REINIT_INFORM, repositoryName);
    }

    public static String generateProjectRepositoryReinitExcept(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_REINIT_EXCEPT, repositoryName);
    }

    public static String generateProjectRepositoryUnlock(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_UNLOCK_INFORM, repositoryName);
    }

    public static String generateProjectRepositoryUnlockMdXcpt(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_UNLOCK_MDXCPT, repositoryName);
    }

    public static String generateProjectRepositoryUnlockRmXcpt(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_UNLOCK_RMXCPT, repositoryName);
    }

    public static String generateProjectRepositoryUpgrade(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_UPGRADE_INFORM, repositoryName);
    }

    public static String generateProjectRepositoryUpgradeXcpt(Task task, String repositoryName) {
        return Localization.processFormat(task, _PROJECT_REPOS_UPGRADE_EXCEPT, repositoryName);
    }

    public static String generateMigrationQueryException(Task task) {
        return Localization.getString(task, _MIGRATION_QUERY_EXCEPTION);
    }

    public static String generateReadFileMembers(Task task, String strFileName) {
        return Localization.processFormat(task, _FILE_READ_MEMBERS, strFileName);
    }

    public static String generateUpdateFileMember(Task task, String strOldMemberName, String strNewMemberName, String strFileName) {
        return Localization.processFormat(task, _FILE_MEMBER_UPDATE, strOldMemberName, strNewMemberName, strFileName);
    }

    public static String generateWriteFileMembers(Task task, String strFileName) {
        return Localization.processFormat(task, _FILE_WRITE_MEMBERS, strFileName);
    }

    public static String generateDuplicateMemberWarning(Task task, String strMemberName, String strFileName) {
        return Localization.processFormat(task, _FILE_MEMBER_DUPLICATE, strMemberName, strFileName);
    }

    public static String generateUpdateFileMemberCount(Task task, int updateCount, int recordCount, String strFileName) {
        return Localization.processFormat(task, _FILE_MEMBER_UPDATE_COUNT, new Integer(updateCount), new Integer(recordCount), strFileName);
    }

    public static String generateFileReadingError(Task task) {
        return Localization.getString(task, _FILE_READ_UNSUCCESSFUL);
    }

    public static String generateFileReadingErrorWithFilename(Task task, String strFileName) {
        return Localization.processFormat(task, _FILE_READ_UNSUCCESSFUL_FILENAME, strFileName);
    }

    public static String generateFileCreationError(Task task, String strFileName) {
        return Localization.processFormat(task, _FILE_CREATION_UNSUCCESSFUL, strFileName);
    }

    public static String generateInternalAccountErrorMessage(Task task) {
        return Localization.getString(task, _INTERNAL_ACCOUNT_FAILURE);
    }

    public static String generateInternalAccountWarningMessage(Task task) {
        return Localization.getString(task, _INTERNAL_ACCOUNT_WARNING);
    }

    public static String generateInternalAccountInfoMessage(Task task) {
        return Localization.getString(task, _INTERNAL_ACCOUNT_COMPLETE);
    }

    public static String generateInternalAccountGenErrMessage(Task task, String accessVerb, String strUserName) {
        return Localization.processFormat(task, _INTERNAL_ACCOUNT_GENERR, accessVerb, strUserName);
    }

    public static String generateInternalAccountExceptionMessage(Task task, String accessVerb, String strUserName) {
        return Localization.processFormat(task, _INTERNAL_ACCOUNT_EXCEPTION, accessVerb, strUserName);
    }

    public static String generateInternalAccountInformationRetrievedMessage(Task task, String strUserName) {
        return Localization.processFormat(task, _INTERNAL_ACCOUNT_RETRIEVED, strUserName);
    }

    public static String generateInternalAccountLockoutOverrideMessage(Task task, String strUserName) {
        return Localization.processFormat(task, _INTERNAL_ACCOUNT_LOCKOUT_OVERRIDE, strUserName);
    }

    public static String generateInternalAccountPasswordOverrideMessage(Task task, String strUserName) {
        return Localization.processFormat(task, _INTERNAL_ACCOUNT_PASSWORD_OVERRIDE, strUserName);
    }

    public static String generateInternalAccountInformationUpdatedMessage(Task task, String strUserName) {
        return Localization.processFormat(task, _INTERNAL_ACCOUNT_UPDATED, strUserName);
    }

    public static String generateSecurityInterfaceAcquiredMessage(Task task) {
        return Localization.getString(task, _SECURITY_INTERFACE_ACQUIRED);
    }

    public static String generateSecurityInterfaceFailedMessage(Task task) {
        return Localization.getString(task, _SECURITY_INTERFACE_FAILURE);
    }
}

