/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.util;

import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Task;

public final class CommonUtils {
    private static final String _WINDOWS_FS = ";";
    private static final String _WAR_EXTENSION = ".war";
    private static final int _WAR_EXTENSION_LENGTH = ".war".length();
    private static final int _MAX_BUFFER_SIZE = 65536;
    public static final String TRUE_LONG = "true";
    public static final String TRUE_SHORT = "t";
    public static final String FALSE_LONG = "false";
    public static final String FALSE_SHORT = "f";
    private static final String _UTF_8 = "UTF-8";
    private static final String _UTF8_UNRECOGNIZED = "Impossible: UTF-8 is not a supported encoding!";
    private static final String _PROPERTIES = ".properties";
    private static final String _CONFIG = ".config";
    private static final String _POLICY = ".policy";
    private static final String[] _PROPERTY_FILE_EXTENSIONS = new String[]{".properties", ".config", ".policy"};

    public static BufferedReader getUTF8Reader(Task task, String filename) throws FileNotFoundException {
        if (null == filename) {
            throw new FileNotFoundException();
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), _UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            CommonUtils.logUTF8Unrecognized(task);
            return new BufferedReader(new FileReader(filename));
        }
    }

    private static BufferedReader getUTF8Reader(Task task, File file) throws FileNotFoundException {
        if (null == file) {
            throw new FileNotFoundException();
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), _UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            CommonUtils.logUTF8Unrecognized(task);
            return new BufferedReader(new FileReader(file));
        }
    }

    public static BufferedWriter getUTF8Writer(Task task, String filename) throws IOException {
        if (null == filename) {
            throw new IOException();
        }
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), _UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            CommonUtils.logUTF8Unrecognized(task);
            return new BufferedWriter(new FileWriter(filename));
        }
    }

    private static void logUTF8Unrecognized(Task task) {
        Logger.log(0, task, _UTF8_UNRECOGNIZED);
    }

    public static String getParameter(Map params, String paramName) {
        Object value;
        if (null != params && null != (value = params.get(paramName))) {
            return value.toString();
        }
        return "";
    }

    public static boolean isEmpty(String value) {
        return null == value || 0 == value.trim().length();
    }

    public static String replaceAll(String input, String from, String to) {
        if (from.equals(to)) {
            return input;
        }
        int start = input.indexOf(from);
        if (CommonUtils.endOfUnsubstitutedVariableNotFound(start)) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(input);
        int fromLength = from.length();
        int toLength = to.length();
        while (CommonUtils.maybeHasUnsubstitutedVariable(start)) {
            start = buffer.replace(start, start + fromLength, to).indexOf(from, start + toLength);
        }
        return buffer.toString();
    }

    public static void destroyDirectory(File directory) {
        String[] contents;
        if (null == directory) {
            return;
        }
        if (directory.isDirectory() && null != (contents = directory.list())) {
            for (int k = 0; k < contents.length; ++k) {
                CommonUtils.destroyDirectory(new File(directory, contents[k]));
            }
        }
        directory.delete();
    }

    public static void ensureDirectoryExists(Task task, File directory) throws WebAppConfigException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new WebAppConfigException(ErrorHandling.generateDirectoryIsNotADirectoryErrorMessage(task, directory), null);
            }
        } else if (!directory.mkdirs()) {
            throw new WebAppConfigException(ErrorHandling.generateCannotCreateDirectoryErrorMessage(task, directory), null);
        }
    }

    public static boolean isPropertiesFile(String filename) {
        if (null == filename) {
            return false;
        }
        for (int k = 0; k < _PROPERTY_FILE_EXTENSIONS.length; ++k) {
            if (!filename.endsWith(_PROPERTY_FILE_EXTENSIONS[k])) continue;
            return true;
        }
        return false;
    }

    public static boolean isSet(String value, boolean defaultValue) {
        if (CommonUtils.isEmpty(value)) {
            return defaultValue;
        }
        String caseInsensitive = value.toLowerCase().trim();
        if (FALSE_SHORT.equals(caseInsensitive) || FALSE_LONG.equals(caseInsensitive)) {
            return false;
        }
        if (TRUE_SHORT.equals(caseInsensitive) || TRUE_LONG.equals(caseInsensitive)) {
            return true;
        }
        return defaultValue;
    }

    public static void copyToDir(Task task, File inFile, File dir, boolean recurse) throws WebAppConfigException {
        if (inFile.isDirectory()) {
            if (recurse) {
                Logger.log(3, task, ErrorHandling.generateCopyingDirectoryInfoMessage(task, inFile, dir));
                CommonUtils.ensureDirectoryExists(task, dir);
                File[] files = inFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    CommonUtils.copyToDir(task, files[i], new File(dir, files[i].getName()), recurse);
                }
            }
        } else if (inFile.getName().equals(dir.getName())) {
            CommonUtils.copyFile(task, inFile, dir);
        } else {
            CommonUtils.copyFile(task, inFile, new File(dir, inFile.getName()));
        }
    }

    public static void copyFile(Task task, File inFile, File outFile) throws WebAppConfigException {
        if (null == inFile || null == outFile || inFile.equals(outFile)) {
            throw new WebAppConfigException(ErrorHandling.generateCannotCopyFileErrorMessage(task, inFile, outFile), new NullPointerException());
        }
        if (inFile.isDirectory()) {
            throw new WebAppConfigException(ErrorHandling.generateCannotCopyDirectoryErrorMessage(task, inFile), null);
        }
        CommonUtils.ensureDirectoryExists(task, outFile.getParentFile());
        BufferedInputStream inF = CommonUtils.openFileForRead(task, inFile);
        BufferedOutputStream outF = CommonUtils.openFileForWrite(task, outFile, inF);
        try {
            byte[] b = new byte[(int)Math.max(1L, Math.min(65536L, inFile.length()))];
            int count = inF.read(b);
            while (CommonUtils.notAtEOF(count)) {
                outF.write(b, 0, count);
                count = inF.read(b);
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotCopyFileErrorMessage(task, inFile, outFile), e);
        }
        finally {
            CommonUtils.closeInputStream(inF);
            CommonUtils.closeOutputStream(outF);
        }
    }

    public static void closeOutputStream(OutputStream outF) {
        try {
            outF.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeInputStream(InputStream inF) {
        if (null != inF) {
            try {
                inF.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeReader(Reader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static BufferedOutputStream openFileForWrite(Task task, File outFile, BufferedInputStream inF) throws WebAppConfigException {
        try {
            return new BufferedOutputStream(new FileOutputStream(outFile));
        }
        catch (FileNotFoundException e) {
            CommonUtils.closeInputStream(inF);
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, outFile), e);
        }
    }

    private static BufferedInputStream openFileForRead(Task task, File inFile) throws WebAppConfigException {
        try {
            return new BufferedInputStream(new FileInputStream(inFile));
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, inFile), e);
        }
    }

    private static boolean notAtEOF(int count) {
        return -1 != count;
    }

    private static boolean endOfUnsubstitutedVariableNotFound(int endIndex) {
        return -1 == endIndex;
    }

    private static boolean maybeHasUnsubstitutedVariable(int startIndex) {
        return -1 != startIndex;
    }

    public static void extractSetOfLinesFromFile(Task task, Set set, File file) throws WebAppConfigException {
        BufferedReader infile = null;
        try {
            infile = CommonUtils.getUTF8Reader(task, file);
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, file), e);
        }
        try {
            String line = null;
            while (null != (line = infile.readLine())) {
                if (CommonUtils.isEmpty(line)) continue;
                set.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(task, file), e);
        }
        try {
            infile.close();
        }
        catch (IOException e) {
            Logger.log(0, task, e);
        }
    }

    public static boolean isValidWarFileName(Task task, String war) throws WebAppConfigException {
        return !CommonUtils.isInvalidWarFileName(task, war);
    }

    private static boolean isInvalidWarFileName(Task task, String war) throws WebAppConfigException {
        if (CommonUtils.isEmpty(war)) {
            String errorMessage = ErrorHandling.generateInvalidWarFileNameErrorMessage(task, war);
            throw new WebAppConfigException(errorMessage, null);
        }
        int fileNameLength = war.length();
        int substringLength = fileNameLength - _WAR_EXTENSION_LENGTH;
        return _WAR_EXTENSION_LENGTH > fileNameLength || !_WAR_EXTENSION.equalsIgnoreCase(war.substring(substringLength));
    }

    public static String convertWarFileNameToFolderName(Task task, String war) throws WebAppConfigException {
        if (CommonUtils.isInvalidWarFileName(task, war)) {
            String errorMessage = ErrorHandling.generateInvalidWarFileNameErrorMessage(task, war);
            throw new WebAppConfigException(errorMessage, null);
        }
        String warNameMinusExtension = war.substring(0, war.length() - _WAR_EXTENSION_LENGTH);
        return new File(warNameMinusExtension).getName();
    }

    public static String[] parseCommaDelimitedInput(String input, boolean retainEmptyTokens) {
        return CommonUtils.parseDelimitedString(input, retainEmptyTokens, ",");
    }

    public static String[] parsePath(String input) {
        if (CommonUtils.isEmpty(input)) {
            return new String[0];
        }
        boolean containsWindowsFS = input.contains(_WINDOWS_FS);
        if (!containsWindowsFS) {
            String[] rval = new String[]{input.trim()};
            return rval;
        }
        return CommonUtils.parseDelimitedString(input, false, _WINDOWS_FS);
    }

    private static String[] parseDelimitedString(String input, boolean retainEmptyTokens, String splitString) {
        ArrayList<String> results = new ArrayList<String>();
        if (!CommonUtils.isEmpty(input)) {
            String[] splits = input.split(splitString, -1);
            for (int i = 0; i < splits.length; ++i) {
                String candidate = splits[i].trim();
                if (!retainEmptyTokens && CommonUtils.isEmpty(candidate)) continue;
                results.add(candidate);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public static String[] parseCommaDelimitedInput(String input) {
        return CommonUtils.parseCommaDelimitedInput(input, false);
    }
}

