/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.tools.webappconfig.tasks.GlobalRootProperties;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class WebinfpltfmProperties
implements ModeledPropertyInterface {
    private static final String CONTENT_SERVER_CLASSID = "DAC0D7F0-10DA-11D6-8816-AA0004006D06";
    private static final String CONTENT_SERVER_TYPE = "ServerComponent";
    private static final String CONTENT_SERVER_ENGLISH_NAME = "SAS Content Server";
    private static final String HTTP_SERVER_NAME_PROPERTY = "iomsrv.httpserver.name";
    private static final String SAS_APPLICATION_INFRASTRUCTURE_NAME = "SAS Application Infrastructure";
    private static final String APPLICATION_CONFIGURATION_NAME = "Application Configuration";
    private static final String PROPERTY_TYPE = "Property";
    private static final String CSRF_PERFORMCHECK_PROPERTY = "sas.web.csrf.referers.performcheck";
    private static final String CSRF_ALLOWNULL_PROPERTY = "sas.web.csrf.referers.allownull";
    private static final String CSRF_SKIPMETHODS_PROPERTY = "sas.web.csrf.referers.skipmethods";
    private static final String CSRF_KNOWNHOSTS_PROPERTY = "sas.web.csrf.referers.knownhosts";
    private static final String CSRF_BLACKLIST_PROPERTY = "sas.web.csrf.referers.blacklist";

    @Override
    public Properties getModeledProperties(Root root) {
        Properties prop = new Properties();
        if (root == null) {
            return prop;
        }
        try {
            Logger.log(2, null, "CONFIGURABLE OBJECT : " + root.getName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.loadSCSProperties(prop, root);
        this.loadCSRFProperties(prop, root);
        return prop;
    }

    private void loadSCSProperties(Properties prop, Root root) {
        try {
            Properties unmodeledPublicProps = GlobalRootProperties.getPropertiesfromConfigurableObj(root, "Public");
            String sdwPropVal = unmodeledPublicProps.getProperty(HTTP_SERVER_NAME_PROPERTY);
            String httpServerName = null;
            if (sdwPropVal == null) {
                Logger.log(1, null, "Could not find config property: iomsrv.httpserver.name");
                httpServerName = CONTENT_SERVER_ENGLISH_NAME;
            } else {
                Logger.log(3, null, "Found property: iomsrv.httpserver.name");
                Logger.log(3, null, "  Value is: " + sdwPropVal);
                httpServerName = sdwPropVal;
            }
            Logger.log(2, null, "HTTP Server name for content server is: " + httpServerName);
            String repository = "A0000001." + root.getRepositoryID();
            int my_flags = 392;
            String filter = "<XMLSelect search=\"*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06' and @Name='" + httpServerName + "']\" />";
            MdFactory factory = root.getObjectStore().getFactory();
            MdObjectStore store = (MdObjectStore)root.getObjectStore();
            List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository, CONTENT_SERVER_TYPE, my_flags, filter);
            if (list == null || list.size() == 0) {
                Logger.log(1, null, "No Content Server definition was found.");
                return;
            }
            ServerComponent server = null;
            try {
                server = (ServerComponent)list.get(0);
            }
            catch (ClassCastException ex) {
                Logger.log(0, null, ex);
                return;
            }
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                TCPIPConnection connection = (TCPIPConnection)connectionList.get(0);
                String protocol = connection.getApplicationProtocol();
                if (protocol != null && protocol.length() > 0) {
                    prop.put("iomsrv.httpserver.protocol.type", protocol);
                    Logger.log(2, null, "Using SAS Content Server metadata to define property: iomsrv.httpserver.protocol.type=" + protocol);
                }
                prop.put("iomsrv.httpserver.host", connection.getHostName());
                prop.put("iomsrv.httpserver.port", String.valueOf(connection.getPort()));
                prop.put("iomsrv.httpserver.authdomain", connection.getDomain().getName());
                Logger.log(2, null, "Using SAS Content Server metadata to define property: iomsrv.httpserver.host=" + connection.getHostName());
                Logger.log(2, null, "Using SAS Content Server metadata to define property: iomsrv.httpserver.port=" + String.valueOf(connection.getPort()));
                Logger.log(2, null, "Using SAS Content Server metadata to define property: iomsrv.httpserver.authdomain=" + connection.getDomain().getName());
            }
        }
        catch (MdException ex) {
            Logger.log(0, null, "EXCEPTION Occured : " + ex.getMessage());
        }
        catch (RemoteException ex) {
            Logger.log(0, null, "EXCEPTION Occured : " + ex.getMessage());
        }
    }

    private void loadCSRFProperties(Properties prop, Root root) {
        Properties unmodeledPublicProps = GlobalRootProperties.getPropertiesfromConfigurableObj(root, "Public");
        String performcheck = unmodeledPublicProps.getProperty(CSRF_PERFORMCHECK_PROPERTY);
        String allownull = unmodeledPublicProps.getProperty(CSRF_ALLOWNULL_PROPERTY);
        String skipmethods = unmodeledPublicProps.getProperty(CSRF_SKIPMETHODS_PROPERTY);
        String knownhosts = unmodeledPublicProps.getProperty(CSRF_KNOWNHOSTS_PROPERTY);
        String blacklist = unmodeledPublicProps.getProperty(CSRF_BLACKLIST_PROPERTY);
        prop.put(CSRF_PERFORMCHECK_PROPERTY, this.getModeledProperty(CSRF_PERFORMCHECK_PROPERTY, performcheck, root));
        prop.put(CSRF_ALLOWNULL_PROPERTY, this.getModeledProperty(CSRF_ALLOWNULL_PROPERTY, allownull, root));
        prop.put(CSRF_SKIPMETHODS_PROPERTY, this.getModeledProperty(CSRF_SKIPMETHODS_PROPERTY, skipmethods, root));
        prop.put(CSRF_KNOWNHOSTS_PROPERTY, this.getModeledProperty(CSRF_KNOWNHOSTS_PROPERTY, knownhosts, root));
        prop.put(CSRF_BLACKLIST_PROPERTY, this.getModeledProperty(CSRF_BLACKLIST_PROPERTY, blacklist, root));
    }

    String getModeledProperty(String propertyName, String defaultValue, Root root) {
        String value = defaultValue;
        StringBuilder filter = new StringBuilder(100);
        filter.append("<XMLSelect search=\"*[@Name='");
        filter.append(propertyName);
        filter.append("'][AssociatedPropertySet/PropertySet[@Name='");
        filter.append(APPLICATION_CONFIGURATION_NAME);
        filter.append("']/OwningObject/SoftwareComponent[@Name='");
        filter.append(SAS_APPLICATION_INFRASTRUCTURE_NAME);
        filter.append("']\" />");
        int my_flags = 392;
        String repository = null;
        List list = null;
        try {
            repository = "A0000001." + root.getRepositoryID();
            MdFactory factory = root.getObjectStore().getFactory();
            MdObjectStore store = (MdObjectStore)root.getObjectStore();
            list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository, PROPERTY_TYPE, my_flags, filter.toString());
            if (list == null || list.size() == 0) {
                Logger.log(1, null, "No SAS Application Infrastructure performCheck property was found.");
                return value;
            }
            Property p = null;
            try {
                p = (Property)list.get(0);
            }
            catch (ClassCastException ex) {
                Logger.log(0, null, ex);
                return value;
            }
            value = p.getDefaultValue();
        }
        catch (MdException ex) {
            Logger.log(0, null, "EXCEPTION Occured : " + ex.getMessage());
        }
        catch (RemoteException ex) {
            Logger.log(0, null, "EXCEPTION Occured : " + ex.getMessage());
        }
        Logger.log(2, null, "Using modeled metadata to define property: " + propertyName + "=" + value);
        return value;
    }
}

