/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.tasks.Unwar;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class WebLogicDeploy
extends TaskImpl {
    public static final String _P2_PROPERTY_NAME = "sas.webappconfig.weblogic.deploy.p2";
    public static final String _P3_PROPERTY_NAME = "sas.webappconfig.weblogic.deploy.p3";

    @Override
    protected boolean doWork() throws WebAppConfigException {
        File dir;
        String war = this.getWarFileName();
        if (!this.unwar(war, dir = this.getDirectory(war))) {
            return false;
        }
        Logger.log(3, this, ErrorHandling.generateWebLogicPathInfoMessage(this, dir));
        return true;
    }

    private String getWarFileName() throws WebAppConfigException {
        String p3 = this.getProperty(_P3_PROPERTY_NAME);
        if (!CommonUtils.isEmpty(p3)) {
            return p3;
        }
        String p2 = this.getProperty(_P2_PROPERTY_NAME);
        if (!CommonUtils.isEmpty(p2) && CommonUtils.isValidWarFileName(this, p2)) {
            return p2;
        }
        return this.getValue("war");
    }

    private File getDirectory(String war) throws WebAppConfigException {
        File weblogicFolder = null;
        String deploymentFolder = null;
        if (!CommonUtils.isEmpty(this.getProperty(_P3_PROPERTY_NAME))) {
            deploymentFolder = this.getProperty(_P2_PROPERTY_NAME);
            weblogicFolder = new File(Unwar.getUnwarDirectoryName(this));
        } else {
            String p2 = this.getProperty(_P2_PROPERTY_NAME);
            if (!CommonUtils.isEmpty(p2)) {
                deploymentFolder = CommonUtils.isValidWarFileName(this, p2) ? CommonUtils.convertWarFileNameToFolderName(this, p2) : p2;
                weblogicFolder = new File(Unwar.getUnwarDirectoryName(this));
            } else {
                deploymentFolder = new File(CommonUtils.convertWarFileNameToFolderName(this, war)).getName();
                File rawDir = new File(Unwar.getUnwarDirectoryName(this));
                weblogicFolder = rawDir.getName().equals(new File(deploymentFolder).getName()) ? rawDir.getParentFile() : rawDir;
            }
        }
        if (!weblogicFolder.exists() || !weblogicFolder.isDirectory()) {
            this.createAndThrowWebAppConfigException(weblogicFolder, null);
        }
        File rval = new File(weblogicFolder, deploymentFolder);
        this.validateDirectory(rval);
        return rval;
    }

    private void validateDirectory(File dir) throws WebAppConfigException {
        if (dir.exists()) {
            this.checkIsDirectory(dir);
        } else {
            this.forceExistence(dir);
        }
    }

    private void checkIsDirectory(File dir) throws WebAppConfigException {
        if (!dir.isDirectory()) {
            this.createAndThrowWebAppConfigException(dir, null);
        }
    }

    private void forceExistence(File dir) throws WebAppConfigException {
        try {
            if (!dir.mkdirs()) {
                this.createAndThrowWebAppConfigException(dir, null);
            }
        }
        catch (SecurityException e) {
            this.createAndThrowWebAppConfigException(dir, e);
        }
    }

    private void createAndThrowWebAppConfigException(File dir, Throwable e) throws WebAppConfigException {
        throw new WebAppConfigException(ErrorHandling.generateDirectoryIsNotADirectoryErrorMessage(this, dir), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unwar(String war, File dir) throws WebAppConfigException {
        boolean bl;
        String directory = dir.getCanonicalPath();
        Map parameters = Unwar.prepareParameters(war, directory, true);
        String oldDirectoryName = Unwar.getUnwarDirectoryName(this);
        Unwar.setUnwarDirectoryName(directory);
        try {
            bl = new Unwar().process(parameters);
        }
        catch (Throwable throwable) {
            try {
                Unwar.setUnwarDirectoryName(oldDirectoryName);
                throw throwable;
            }
            catch (IOException e) {
                this.createAndThrowWebAppConfigException(dir, e);
                return false;
            }
        }
        Unwar.setUnwarDirectoryName(oldDirectoryName);
        return bl;
    }
}

