/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.tools.webappconfig.tasks.ConnectionAntProperties;
import com.sas.tools.webappconfig.tasks.PropertyData;
import com.sas.tools.webappconfig.tasks.WebappBaseModeledProperties;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VaBaseModeledProperties
extends WebappBaseModeledProperties {
    public String getContextRootFromURI(String URI2) {
        Pattern startsWithSlash = Pattern.compile("^/");
        Matcher contextRootMatch = startsWithSlash.matcher(URI2);
        String contextRoot = contextRootMatch.find() ? URI2.substring(1) : URI2;
        return contextRoot;
    }

    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = new Properties();
        try {
            TCPIPConnection sourceConnection;
            DeployedComponent deployedComponent;
            ConnectionAntProperties connectionAntProps;
            PropertySet appConfig;
            List propDataList = this.getPropertyData();
            if (propDataList != null && (appConfig = this.getPropertySetNamed(root, "Application Configuration")) != null) {
                AssociationList omrProps = appConfig.getSetProperties();
                block3: for (Property omrProp : omrProps) {
                    for (PropertyData propData : propDataList) {
                        if (!omrProp.getName().equals(propData.getOmrPropertyName())) continue;
                        retval.setProperty(propData.getAntPropertyName(), omrProp.getDefaultValue());
                        continue block3;
                    }
                }
            }
            if ((connectionAntProps = this.getConnectionAntProperties()) != null && (deployedComponent = this.getDeployedComponentNamed(root, "Registered SAS Application")) != null && (sourceConnection = this.getSourceConnectionNamed(deployedComponent, "Connection URI")) != null) {
                String protocolName = connectionAntProps.getProtocolName();
                String protocol = sourceConnection.getCommunicationProtocol();
                if (protocolName != null) {
                    retval.setProperty(protocolName, protocol);
                }
                String hostName = connectionAntProps.getHostName();
                String host = sourceConnection.getHostName();
                if (hostName != null) {
                    retval.setProperty(hostName, host);
                }
                String portName = connectionAntProps.getPortName();
                String port = "" + sourceConnection.getPort();
                if (portName != null) {
                    retval.setProperty(portName, port);
                }
                String urlName = connectionAntProps.getUrlName();
                String url = sourceConnection.getService();
                if (urlName != null) {
                    retval.setProperty(urlName, url);
                }
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, e.getMessage());
        }
        catch (MdException e) {
            Logger.log(0, null, e.getMessage());
        }
        return retval;
    }

    private PropertySet getPropertySetNamed(Root owner, String name) throws RemoteException, MdException {
        PropertySet retval = null;
        AssociationList propSets = owner.getPropertySets();
        for (PropertySet propSet : propSets) {
            if (!propSet.getName().equals(name)) continue;
            retval = propSet;
            break;
        }
        return retval;
    }

    private DeployedComponent getDeployedComponentNamed(Root owner, String name) throws RemoteException, MdException {
        DeployedComponent retval = null;
        SoftwareComponent sc = (SoftwareComponent)owner;
        AssociationList deployedComponents = sc.getDeployedComponents();
        for (DeployedComponent deployedComponent : deployedComponents) {
            if (!deployedComponent.getName().equals(name)) continue;
            retval = deployedComponent;
            break;
        }
        return retval;
    }

    private TCPIPConnection getSourceConnectionNamed(DeployedComponent owner, String name) throws RemoteException, MdException {
        TCPIPConnection retval = null;
        AssociationList sourceConnections = owner.getSourceConnections();
        for (TCPIPConnection sourceConnection : sourceConnections) {
            if (!sourceConnection.getName().equals(name)) continue;
            retval = sourceConnection;
            break;
        }
        return retval;
    }
}

