/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.tools.ant.Task;

public final class Unwar
extends TaskImpl {
    public static final String UNWAR_DIRECTORY_PROPERTY = "sas.webappconfig.unwar.directory";
    private static final int _INITIAL_DIRECTORY_ESTIMATE = 16;
    private static final int _BUFFER_SIZE = 8192;
    private byte[] _buffer = new byte[8192];
    private String _warfilename = null;
    private boolean _overwrite = true;
    private Map _subdirectories = new HashMap(16);

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this._overwrite = this.getValueAsBool("clean", true);
        this._warfilename = this.getValue("warfile");
        String directory = Unwar.getUnwarDirectoryName(this);
        if (CommonUtils.isEmpty(directory)) {
            directory = this.getValue("directory");
        }
        return this.openWarFile(directory);
    }

    static String getUnwarDirectoryName(TaskImpl user) {
        return user.getProperty(UNWAR_DIRECTORY_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openWarFile(String destination) throws WebAppConfigException {
        File warFile = new File(this._warfilename);
        if (!warFile.exists()) {
            throw new WebAppConfigException(ErrorHandling.generateWarfileDoesNotExistErrorMessage(this, this._warfilename), null);
        }
        JarFile war = null;
        try {
            war = new JarFile(warFile);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, this._warfilename), e);
        }
        File directory = new File(destination);
        if (this._overwrite) {
            CommonUtils.destroyDirectory(directory);
        }
        CommonUtils.ensureDirectoryExists(this, directory);
        Enumeration<JarEntry> warEntries = war.entries();
        int expectedCount = war.size();
        int actualCount = 0;
        int currentPercentage = 0;
        try {
            while (warEntries.hasMoreElements()) {
                int newPercentage;
                JarEntry entry = warEntries.nextElement();
                this.copyEntry(entry, directory, war);
                if ((newPercentage = 10 * ++actualCount / expectedCount) <= currentPercentage) continue;
                Logger.log(2, this, ErrorHandling.generatePercentCompleteInfoMessage(this, 10 * newPercentage));
                currentPercentage = newPercentage;
            }
        }
        finally {
            try {
                war.close();
            }
            catch (IOException e) {
                Logger.log(0, this, e);
            }
        }
        for (Map.Entry entry : this._subdirectories.entrySet()) {
            ((File)entry.getKey()).setLastModified(((JarEntry)entry.getValue()).getTime());
        }
        return true;
    }

    private void copyEntry(JarEntry entry, File directory, JarFile war) throws WebAppConfigException {
        String entryName = entry.getName();
        if (CommonUtils.isEmpty(entryName)) {
            return;
        }
        File fileEntry = new File(directory, entryName);
        if (entry.isDirectory()) {
            this.makeDirectory(entry, fileEntry);
        } else {
            this.makeFile(entry, fileEntry, war);
        }
    }

    private void makeDirectory(JarEntry entry, File fileEntry) throws WebAppConfigException {
        long timestamp;
        CommonUtils.ensureDirectoryExists(this, fileEntry);
        if (this._overwrite && -1L != (timestamp = entry.getTime())) {
            this._subdirectories.put(fileEntry, entry);
        }
    }

    private void makeFile(JarEntry entry, File fileEntry, JarFile war) throws WebAppConfigException {
        if (!this._overwrite && fileEntry.exists()) {
            return;
        }
        CommonUtils.ensureDirectoryExists(this, fileEntry.getParentFile());
        InputStream input = null;
        try {
            input = war.getInputStream(entry);
        }
        catch (ZipException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, entry.getName()), e);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, entry.getName()), e);
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(fileEntry);
        }
        catch (FileNotFoundException e) {
            CommonUtils.closeInputStream(input);
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, fileEntry), e);
        }
        boolean done = false;
        try {
            while (!done) {
                int count = input.read(this._buffer);
                if (-1 == count) {
                    done = true;
                    continue;
                }
                ((OutputStream)output).write(this._buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotCopyFileErrorMessage(this, new File(this._warfilename), fileEntry), e);
        }
        finally {
            CommonUtils.closeInputStream(input);
            CommonUtils.closeOutputStream(output);
            long timestamp = entry.getTime();
            if (-1L != timestamp) {
                fileEntry.setLastModified(timestamp);
            }
        }
    }

    public static Map prepareParameters(String war, String folder, boolean b) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("warfile", war);
        params.put("directory", folder);
        params.put("clean", b ? "true" : "false");
        return params;
    }

    static void setUnwarDirectoryName(String directory) {
        System.setProperty(UNWAR_DIRECTORY_PROPERTY, directory);
    }
}

