/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.tasks.Unwar;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TomcatDeploy
extends TaskImpl {
    public static final String CATALINA_HOME_PROPERTY = "sas.webappconfig.catalina.home";
    public static final String CATALINA_WEBAPPS_FOLDER = "webapps";
    public static final String CATALINA_APP_BASE = "sas.webappconfig.catalina.appBase";
    private String _tomcatBase;
    private String _applicationBase;
    private static final List _PROBLEMATIC_JARS;

    @Override
    protected boolean doWork() throws WebAppConfigException {
        String war = this.getValue("war");
        String context = this.getValue("context");
        this.setTomcatBase();
        this.setApplicationBase();
        if (!this.ensureTomcatIsSafe()) {
            return false;
        }
        if (!this.unwar(war)) {
            return false;
        }
        this.deleteWarFile(war);
        this.copyContextFile(context);
        return true;
    }

    private void deleteWarFile(String war) {
        File warFile = this.getFile(war);
        if (warFile.exists()) {
            warFile.delete();
        }
    }

    private boolean ensureTomcatIsSafe() {
        boolean checkXerces = this.getValueAsBool("checkXerces", true);
        if (!checkXerces) {
            return true;
        }
        File commonEndorsedFolder = TomcatDeploy.getTomcatJarDir(this._tomcatBase);
        boolean isSafe = true;
        Iterator iter = TomcatDeploy.getBadJarIterator();
        while (iter.hasNext()) {
            File jar = new File(commonEndorsedFolder, (String)iter.next());
            if (!jar.exists()) continue;
            Logger.log(0, this, ErrorHandling.generateIncompatibleJarErrorMessage(this, jar));
            isSafe = false;
        }
        return isSafe;
    }

    public static Iterator getBadJarIterator() {
        return _PROBLEMATIC_JARS.iterator();
    }

    public static File getTomcatJarDir(String tomcatBase) {
        return new File(new File(new File(tomcatBase), "common"), "endorsed");
    }

    private void copyContextFile(String context) throws WebAppConfigException {
        CommonUtils.copyFile(this, new File(context), this.getFile(context));
    }

    private boolean unwar(String war) throws WebAppConfigException {
        Map parameters = Unwar.prepareParameters(war, this.getFolder(war), true);
        return this.callTask(new Unwar(), parameters);
    }

    private void setApplicationBase() {
        this._applicationBase = this.getProperty(CATALINA_APP_BASE);
        if (CommonUtils.isEmpty(this._applicationBase)) {
            this._applicationBase = CATALINA_WEBAPPS_FOLDER;
        }
    }

    private void setTomcatBase() throws WebAppConfigException {
        this._tomcatBase = this.getProperty(CATALINA_HOME_PROPERTY);
        if (CommonUtils.isEmpty(this._tomcatBase)) {
            throw new WebAppConfigException(ErrorHandling.generateMissingBaseErrorMessage(this), null);
        }
    }

    private String getFolder(String war) throws WebAppConfigException {
        String warFileFolder = CommonUtils.convertWarFileNameToFolderName(this, war);
        return this.getFile(warFileFolder).toString();
    }

    private File getFile(String file) {
        return new File(new File(this._tomcatBase, this._applicationBase), new File(file).getName());
    }

    static {
        ArrayList<String> badJars = new ArrayList<String>(2);
        badJars.add("xercesImpl.jar");
        badJars.add("xmlParserAPIs.jar");
        _PROBLEMATIC_JARS = Collections.unmodifiableList(badJars);
    }
}

