/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.AbstractPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.FileListPropertySource;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.propertymgmt.PropertySourceInterface;
import com.sas.tools.webappconfig.propertymgmt.PropertySourceList;
import com.sas.tools.webappconfig.tasks.TaskInterface;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public abstract class TaskImpl
extends Task
implements TaskInterface,
TaskContainer {
    private Map _params;
    private String _name;
    private Map _initialParams = new HashMap();
    private PropertySourceInterface _propertySource;

    protected TaskImpl() {
    }

    public void execute() throws BuildException {
        boolean rval = false;
        try {
            rval = this.performWork();
        }
        catch (WebAppConfigException e) {
            throw new BuildException((Throwable)e);
        }
        if (!rval) {
            throw new BuildException();
        }
    }

    public final boolean performWork() throws WebAppConfigException {
        return this.process(Collections.unmodifiableMap(this._initialParams));
    }

    @Override
    public final boolean process(Map params) throws WebAppConfigException {
        this._params = params;
        try {
            return this.meetsAllConditions() ? this._doWork() : true;
        }
        catch (WebAppConfigException e) {
            Logger.log(0, this, e);
            throw e;
        }
        catch (Throwable t) {
            WebAppConfigException.logUnexpectedException(this, t);
            return false;
        }
    }

    public final void setCaseinsensitive(String arg) {
        this.addParameter("caseinsensitive", arg);
    }

    public final void setCheckXerces(String arg) {
        this.addParameter("checkXerces", arg);
    }

    public final void setClean(String arg) {
        this.addParameter("clean", arg);
    }

    public final void setContext(String arg) {
        this.addParameter("context", arg);
    }

    public final void setDefinitions(String arg) {
        this.addParameter("definitions", arg);
    }

    public final void setDestDirMacros(String arg) {
        this.addParameter("destDirMacros", arg);
    }

    public final void setDestFileMacros(String arg) {
        this.addParameter("destFileMacros", arg);
    }

    public final void setDestination(String arg) {
        this.addParameter("destination", arg);
    }

    public final void setDirectory(String arg) {
        this.addParameter("directory", arg);
    }

    public final void setExcluded(String arg) {
        this.addParameter("excluded", arg);
    }

    public final void setFailOnError(String arg) {
        this.addParameter("failonerror", arg);
    }

    public void setFiles(String arg) {
        this.addParameter("files", arg);
    }

    public final void setCheckdirs(String arg) {
        this.addParameter("checkdirs", arg);
    }

    public final void setFixups(String arg) {
        this.addParameter("fixups", arg);
    }

    public final void setIftrue(String arg) {
        this.addParameter("iftrue", arg);
    }

    public final void setMove(String arg) {
        this.addParameter("move", arg);
    }

    public final void setName(String arg) {
        this._name = arg;
    }

    public final void setNamespace(String arg) {
        this.addParameter("namespace", arg);
    }

    public final void setNegate(String arg) {
        this.addParameter("negate", arg);
    }

    public final void setOnerror(String arg) {
        this.addParameter("onerror", arg);
    }

    public final void setOptional(String arg) {
        this.addParameter("optional", arg);
    }

    public final void setPicklist(String arg) {
        this.addParameter("picklist", arg);
    }

    public final void setProperties(String arg) {
        this.addParameter("properties", arg);
    }

    public final void setProperty(String arg) {
        this.addParameter("property", arg);
    }

    public final void setPropertyname(String arg) {
        this.addParameter("propertyname", arg);
    }

    public final void setPropsFileName(String arg) {
        this.addParameter("propsFileName", arg);
    }

    public final void setRecurse(String arg) {
        this.addParameter("recurse", arg);
    }

    public final void setRequired(String arg) {
        this.addParameter("required", arg);
    }

    public final void setSource(String arg) {
        this.addParameter("source", arg);
    }

    public final void setSourceDirs(String arg) {
        this.addParameter("sourceDirs", arg);
    }

    public final void setSourceFiles(String arg) {
        this.addParameter("sourceFiles", arg);
    }

    public final void setStripRootContext(String arg) {
        this.addParameter("stripRootContext", arg);
    }

    public final void setValue(String arg) {
        this.addParameter("value", arg);
    }

    public final void setWar(String arg) {
        this.addParameter("war", arg);
    }

    public final void setWarfile(String arg) {
        this.addParameter("warfile", arg);
    }

    public void addTask(Task nestedTask) {
    }

    public final String getProperty(String propertyName) {
        Project myProject;
        String rval = System.getProperty(propertyName);
        if (CommonUtils.isEmpty(rval) && null != (myProject = this.getProject())) {
            rval = myProject.getProperty(propertyName);
        }
        return rval;
    }

    public final void setProperty(String propertyName, String value) {
        String oldValue = this.getProperty(propertyName);
        if (!CommonUtils.isEmpty(oldValue)) {
            if (!oldValue.equals(value)) {
                Logger.log(1, this, ErrorHandling.generateCannotRedefinePropertyErrorMessage(this, propertyName));
            }
            return;
        }
        Project myProject = this.getProject();
        if (null != myProject) {
            myProject.setNewProperty(propertyName, value);
        } else {
            System.setProperty(propertyName, value);
        }
    }

    protected void addParameter(String paramName, String paramValue) {
        this._initialParams.put(paramName, paramValue);
    }

    protected abstract boolean doWork() throws WebAppConfigException;

    protected final boolean callTask(TaskImpl task, Map parameters) throws WebAppConfigException {
        task.setProject(this.getProject());
        task.setTaskName(this.getTaskName());
        return task.process(parameters);
    }

    protected final boolean paramExists(String name) {
        return this._params.containsKey(name);
    }

    protected final String getValue(String name) throws WebAppConfigException {
        String value = CommonUtils.getParameter(this._params, name);
        if (CommonUtils.isEmpty(value)) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(this, name), null);
        }
        return value;
    }

    protected final String getValue(String preferredName, String deprecatedName) throws WebAppConfigException {
        String value = CommonUtils.getParameter(this._params, preferredName);
        if (CommonUtils.isEmpty(value)) {
            value = CommonUtils.getParameter(this._params, deprecatedName);
            if (CommonUtils.isEmpty(value)) {
                throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(this, preferredName), null);
            }
            Logger.log(1, this, ErrorHandling.generateDeprecatedAttributeWarningMessage(this, preferredName, deprecatedName));
        }
        return value;
    }

    protected final boolean getValueAsBool(String name, boolean fallback) {
        return CommonUtils.isSet(CommonUtils.getParameter(this._params, name), fallback);
    }

    private boolean _doWork() throws WebAppConfigException {
        if (null != this._name) {
            Logger.log(2, this, ErrorHandling.generateExecutingTaskInfoMessage(this, this._name));
        }
        return this.doWork();
    }

    private boolean meetsAllConditions() {
        String[] variables = CommonUtils.parseCommaDelimitedInput((String)this._params.get("iftrue"));
        for (int i = 0; i < variables.length; ++i) {
            String variable = variables[i];
            boolean negate = false;
            while (variable.startsWith("!")) {
                variable = variable.substring(1);
                negate = !negate;
            }
            boolean rval = CommonUtils.isSet(variable, true);
            if (negate) {
                boolean bl = rval = !rval;
            }
            if (rval) continue;
            return false;
        }
        return true;
    }

    protected PropertyMap readProperties(AbstractPropertyPreprocessor preprocessor, String parameterName, String alternateParameterName) throws WebAppConfigException {
        if (this.paramExists(parameterName)) {
            this._propertySource = new FileListPropertySource(this, this.getValue(parameterName), preprocessor);
            return this.resolveProperties();
        }
        if (this.paramExists(alternateParameterName)) {
            this._propertySource = new FileListPropertySource(this, this.getValue(parameterName, alternateParameterName), preprocessor);
            return this.resolveProperties();
        }
        if (null != this._propertySource) {
            if (null != preprocessor) {
                this._propertySource.setPreprocessor(preprocessor);
            }
            return this.resolveProperties();
        }
        return PropertyMap.EMPTY_PROPERTY_MAP;
    }

    protected final PropertySourceInterface getPropertySource() {
        return this._propertySource;
    }

    private PropertyMap resolveProperties() throws WebAppConfigException {
        return new PropertyMap(false, this._propertySource.resolveProperties(this));
    }

    public void addConfiguredPropertysourcelist(PropertySourceList source) {
        this._propertySource = source;
    }
}

