/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.FileURLPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.PropertyMaker;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.Task;

public final class Substitute
extends TaskImpl {
    private static final String _PRIMARY_TEMPLATE_EXTENSION = ".orig";
    private static final String _SECONDARY_TEMPLATE_EXTENSION = ".ori";

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this.processInputFiles(this.getValue("files"), this.processDefinitionFiles("definitions"));
        return true;
    }

    private void processInputFiles(String files, PropertyMap substitutions) throws WebAppConfigException {
        String[] filenames = CommonUtils.parseCommaDelimitedInput(files);
        for (int i = 0; i < filenames.length; ++i) {
            String filename = filenames[i];
            Logger.log(3, this, ErrorHandling.generateProcessingFileInfoMessage(this, filename));
            this.processInputFile(substitutions, filename);
        }
    }

    private void processInputFile(PropertyMap substitutions, String filename) throws WebAppConfigException {
        boolean isPropertiesFile = CommonUtils.isPropertiesFile(filename);
        Input input = this.getInputFile(filename);
        BufferedReader infile = input.getReader();
        BufferedWriter outfile = null;
        try {
            outfile = CommonUtils.getUTF8Writer(this, filename);
        }
        catch (IOException e) {
            CommonUtils.closeReader(infile);
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, filename), e);
        }
        try {
            String line = null;
            while (null != (line = infile.readLine())) {
                for (Map.Entry entry : substitutions.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (isPropertiesFile) {
                        value = CommonUtils.replaceAll(value, "\\", "\\\\");
                    }
                    if (this.keyIsWrappedBy(key, "$") || this.keyIsWrappedBy(key, "@")) {
                        line = CommonUtils.replaceAll(line, key, value);
                        continue;
                    }
                    String wrappedKey = this.wrapKey(key, "@");
                    if (line.indexOf(wrappedKey) != -1) {
                        line = CommonUtils.replaceAll(line, wrappedKey, value);
                        continue;
                    }
                    wrappedKey = this.wrapKey(key, "$");
                    if (line.indexOf(wrappedKey) != -1) {
                        line = CommonUtils.replaceAll(line, wrappedKey, value);
                        continue;
                    }
                    line = CommonUtils.replaceAll(line, key, value);
                }
                outfile.write(line);
                outfile.newLine();
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessSubstitutionsErrorMessage(this, input.getInputFileName(), filename), e);
        }
        finally {
            CommonUtils.closeWriter(outfile);
            CommonUtils.closeReader(infile);
        }
    }

    private String wrapKey(String key, String keyWrapper) {
        StringBuffer buffer = new StringBuffer(key.length() + 2 * keyWrapper.length());
        buffer.append(keyWrapper).append(key).append(keyWrapper);
        return buffer.toString();
    }

    private boolean keyIsWrappedBy(String key, String keyWrapper) {
        return key.startsWith(keyWrapper) && key.endsWith(keyWrapper);
    }

    private PropertyMap processDefinitionFiles(String parameterName) throws WebAppConfigException {
        PropertyMap substitutions = this.readProperties(new FileURLPropertyPreprocessor(), parameterName, null);
        if (substitutions.isEmpty()) {
            throw new WebAppConfigException(ErrorHandling.generateNoPropertiesFilesDefinedErrorMessage(this), null);
        }
        if (this.paramExists("fixups")) {
            PropertyMap tempMap = new PropertyMap(substitutions);
            String fixupFile = this.getValue("fixups");
            BufferedReader in = this.openFixupFile(fixupFile);
            String line = null;
            while (null != (line = this.readLine(in, fixupFile))) {
                Object o;
                String[] tokens = CommonUtils.parseCommaDelimitedInput(line, true);
                String id = "";
                String oldValue = "";
                String newValue = "";
                if (tokens.length >= 1) {
                    id = tokens[0];
                    if (tokens.length >= 2) {
                        oldValue = tokens[1];
                        if (tokens.length >= 3) {
                            newValue = tokens[2];
                        }
                    }
                }
                if (null == (o = tempMap.get(id))) continue;
                tempMap.put(id, CommonUtils.replaceAll((String)o, oldValue, newValue));
            }
            CommonUtils.closeReader(in);
            substitutions = tempMap;
        }
        PropertyMaker.fixupIndirection(this, substitutions);
        return substitutions;
    }

    private String readLine(BufferedReader in, String filename) throws WebAppConfigException {
        try {
            return in.readLine();
        }
        catch (IOException e) {
            CommonUtils.closeReader(in);
            String errorMessage = ErrorHandling.generateCannotReadFileErrorMessage((Task)this, filename);
            throw new WebAppConfigException(errorMessage, e);
        }
    }

    private BufferedReader openFixupFile(String fixupFile) throws WebAppConfigException {
        BufferedReader in = null;
        try {
            in = CommonUtils.getUTF8Reader((Task)this, fixupFile);
        }
        catch (FileNotFoundException e) {
            String errorMessage = ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, fixupFile);
            throw new WebAppConfigException(errorMessage, e);
        }
        return in;
    }

    private Input getInputFile(String filename) throws WebAppConfigException {
        StringBuffer inputFileBuffer = new StringBuffer(filename.length() + _PRIMARY_TEMPLATE_EXTENSION.length());
        inputFileBuffer.append(filename);
        inputFileBuffer.append(_PRIMARY_TEMPLATE_EXTENSION);
        String inputFile = inputFileBuffer.toString();
        try {
            return new Input(this, inputFile);
        }
        catch (FileNotFoundException e) {
            StringBuffer buffer = new StringBuffer(filename.length() + _SECONDARY_TEMPLATE_EXTENSION.length());
            buffer.append(filename);
            buffer.append(_SECONDARY_TEMPLATE_EXTENSION);
            inputFile = buffer.toString();
            try {
                return new Input(this, inputFile);
            }
            catch (FileNotFoundException e2) {
                throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, inputFile), e2);
            }
        }
    }

    private static class Input {
        private String _inputFileName;
        private BufferedReader _reader;

        Input(Task task, String inputFileName) throws FileNotFoundException {
            this._inputFileName = inputFileName;
            this._reader = CommonUtils.getUTF8Reader(task, inputFileName);
        }

        final String getInputFileName() {
            return this._inputFileName;
        }

        final BufferedReader getReader() {
            return this._reader;
        }
    }
}

