/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.tools.webappconfig.tasks.DialogData;
import com.sas.tools.webappconfig.tasks.ObjectPropertiesUtil;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;

public class SetObjectProperties
extends TaskImpl {
    private String fqid = null;
    private String productcode = null;
    private String prefix = null;
    private String propertysetrefid = null;
    private String existingproperties = "Append";
    private String m_repositoryFQID = "";
    private String m_reposID = null;
    private MdFactory m_mdFactory = null;
    private MdObjectStore m_mdObjectStore = null;
    private boolean connected = false;

    @Override
    public boolean doWork() throws WebAppConfigException {
        boolean valid = true;
        HashMap<String, String> publicProperties = new HashMap<String, String>();
        HashMap<String, String> privateProperties = new HashMap<String, String>();
        this.m_reposID = this.fqid.substring(0, 8);
        this.m_repositoryFQID = "A0000001." + this.m_reposID;
        if (this.fqid == null) {
            valid = false;
            Logger.log(0, this, "Error during setting of properties.  Passed in FullyQualifiedID is null.");
        }
        if (this.productcode == null) {
            valid = false;
            Logger.log(0, this, "Error during setting of properties.  Passed in ProductCode is null.");
        }
        if (valid) {
            String host = this.getProject().getProperty("iomsrv.metadatasrv.host");
            String port = this.getProject().getProperty("iomsrv.metadatasrv.port");
            String user = this.getProject().getProperty("metadata.connection.userid");
            String password = this.getProject().getProperty("metadata.connection.passwd");
            String repository = this.getProject().getProperty("oma.repository.foundation.name");
            String configbundle = this.getProject().getProperty("configuration.configbundle.file");
            this.connected = this.makeConnection(host, port, user, password, repository);
            Root softwareComponent = this.getRoot();
            if (!this.existingproperties.equalsIgnoreCase("Replace")) {
                TextStore textStore = ObjectPropertiesUtil.getTextStore(this, softwareComponent, true);
                if (textStore != null) {
                    ObjectPropertiesUtil.appendProperties(this, publicProperties, textStore);
                }
                if ((textStore = ObjectPropertiesUtil.getTextStore(this, softwareComponent, false)) != null) {
                    ObjectPropertiesUtil.appendProperties(this, privateProperties, textStore);
                }
            }
            if (this.connected && softwareComponent != null) {
                String levdirroot = this.getProject().getProperty("levdirroot.configobj.fqid");
                if (levdirroot != null && !this.productcode.equals("levdirroot")) {
                    this.addDependency(softwareComponent, levdirroot);
                }
                try {
                    Logger.log(3, this, "Using prefix: " + this.prefix);
                    Logger.log(3, this, "\nCreating object properties on \n<SoftwareComponent Name=\"" + softwareComponent.getName() + "\" ID=\"" + this.fqid + "\" MetadataCreated=\"" + softwareComponent.getMetadataCreated() + "\" MetadataUpdated=\"" + softwareComponent.getMetadataUpdated() + "\" />\n");
                    String osType = null;
                    String osName = System.getProperty("os.name");
                    osType = osName.equalsIgnoreCase("z/OS") ? "zos" : (osName.startsWith("Windows") ? "win" : "unx");
                    Logger.log(3, this, "\nosType= " + osType + "configbundle= " + configbundle + "\n");
                    DialogData dialogData = new DialogData(configbundle);
                    DialogData.Dialog[] dialogs = null;
                    if (dialogData != null) {
                        dialogs = dialogData.getDialogs(osType);
                    }
                    if (dialogs != null) {
                        DialogData.Property[] dialogProperties = null;
                        String propertyname = null;
                        String prodCode = null;
                        int scope = -1;
                        boolean persist = false;
                        for (int i = 0; i < dialogs.length; ++i) {
                            dialogProperties = dialogs[i].getProperties();
                            for (int j = 0; j < dialogProperties.length; ++j) {
                                prodCode = dialogProperties[j].getOwner();
                                persist = dialogProperties[j].getPersist();
                                if (!prodCode.equalsIgnoreCase(this.productcode) || !persist) continue;
                                propertyname = dialogProperties[j].getName();
                                scope = dialogProperties[j].getScope();
                                String value = null;
                                if (this.prefix != null && this.getProject().getProperty(this.prefix + propertyname) != null) {
                                    value = this.getProject().getProperty(this.prefix + propertyname);
                                    Logger.log(3, this, "Found property named with prefix: " + this.prefix + propertyname + " so overriding with value from prefixed property: " + value);
                                }
                                if (value == null) {
                                    value = this.getProject().getProperty(propertyname);
                                }
                                if (value == null) continue;
                                Logger.log(3, this, "Saving property " + propertyname + "=" + value);
                                if (scope == 1) {
                                    publicProperties.put(propertyname, value);
                                    continue;
                                }
                                if (propertyname.indexOf(this.productcode + ".dependson") != -1) {
                                    if (value.length() <= 0) {
                                        valid = false;
                                        Logger.log(0, this, "Error during setting of properties.  Empty value for dependson property " + propertyname);
                                        return false;
                                    }
                                    String tempFQID = value;
                                    boolean added = this.addDependency(softwareComponent, tempFQID);
                                    if (added) continue;
                                    return false;
                                }
                                privateProperties.put(propertyname, value);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logger.log(0, this, "Error loading install dialog properties file: " + configbundle);
                    valid = false;
                }
                if (this.propertysetrefid != null) {
                    Reference r = new Reference(this.getProject(), this.propertysetrefid);
                    PropertySet refidpropset = (PropertySet)r.getReferencedObject();
                    Properties refidproperties = refidpropset.getProperties();
                    Logger.log(3, this, "\n\nRetrieved properties from referenced propersetrefid: " + this.propertysetrefid.toString());
                    if (refidproperties != null) {
                        Enumeration<?> en = refidproperties.propertyNames();
                        while (en.hasMoreElements()) {
                            String propertyname = (String)en.nextElement();
                            Logger.log(3, this, "Found private property in propertysetrefid.  Name: " + propertyname);
                            if (this.prefix != null) {
                                if (!propertyname.startsWith(this.prefix)) continue;
                                String unprefixedpropertyname = propertyname.substring(this.prefix.length());
                                String propertyvalue = refidproperties.getProperty(propertyname);
                                privateProperties.put(unprefixedpropertyname, propertyvalue);
                                Logger.log(3, this, "Added to private property after stripping prefix:  " + unprefixedpropertyname + "=" + propertyvalue);
                                continue;
                            }
                            String propertyvalue = refidproperties.getProperty(propertyname);
                            privateProperties.put(propertyname, propertyvalue);
                            Logger.log(3, this, "Added to private properties: " + propertyname + "=" + propertyvalue);
                        }
                    }
                }
                if (this.productcode != null) {
                    String propertyValue = null;
                    propertyValue = this.getBuiltinPropertValue(this.productcode + ".configobj.classname");
                    if (propertyValue != null) {
                        publicProperties.put("configobj.classname", propertyValue);
                    }
                    if ((propertyValue = this.getBuiltinPropertValue(this.productcode + ".configobj.name")) != null) {
                        publicProperties.put("configobj.name", propertyValue);
                    }
                    if ((propertyValue = this.getBuiltinPropertValue(this.productcode + ".configobj.classid")) != null) {
                        publicProperties.put("configobj.classid", propertyValue);
                    }
                    if ((propertyValue = this.getBuiltinPropertValue(this.productcode + ".configobj.type")) != null) {
                        publicProperties.put("configobj.type", propertyValue);
                    }
                    if ((propertyValue = this.getBuiltinPropertValue(this.productcode + ".configobj.version")) != null) {
                        publicProperties.put(this.productcode + ".configobj.version", propertyValue);
                    }
                    if ((propertyValue = this.getBuiltinPropertValue("config.order.number")) != null) {
                        publicProperties.put(this.productcode + ".configobj.order.number", propertyValue);
                    }
                    privateProperties.put("12byte", this.productcode);
                }
                if (valid) {
                    String storedTextAttribute = ObjectPropertiesUtil.getStringFromProperties((Task)this, publicProperties);
                    String storedPrivateTextAttribute = null;
                    if (privateProperties.size() > 0) {
                        storedPrivateTextAttribute = ObjectPropertiesUtil.getStringFromProperties((Task)this, privateProperties);
                    }
                    valid = this.setObjectProps(softwareComponent, storedTextAttribute, storedPrivateTextAttribute);
                }
                this.closeConnection();
            } else {
                valid = false;
                Logger.log(0, this, "Error setting object properties:");
                Logger.log(0, this, "   connected:" + this.connected);
                Logger.log(0, this, "   SoftwareComponent:" + softwareComponent);
            }
        }
        return valid;
    }

    public boolean setObjectProperties(HashMap publicProperties, HashMap privateProperties) {
        boolean valid = true;
        this.m_reposID = this.fqid.substring(0, 8);
        this.m_repositoryFQID = "A0000001." + this.m_reposID;
        if (this.fqid == null) {
            valid = false;
            Logger.log(0, this, "Error during setting of properties.  Passed in FullyQualifiedID is null.");
        }
        if (!this.connected) {
            Logger.log(0, this, "Error:  Not connected to metadata server.");
            valid = false;
        }
        if (valid) {
            Root softwareComponent = this.getRoot();
            if (this.connected && softwareComponent != null) {
                String storedTextAttribute = ObjectPropertiesUtil.getStringFromProperties((Task)this, publicProperties);
                Logger.log(3, this, "Setting text on TextStore:" + storedTextAttribute);
                String storedPrivateTextAttribute = null;
                if (privateProperties.size() > 0) {
                    storedPrivateTextAttribute = ObjectPropertiesUtil.getStringFromProperties((Task)this, privateProperties);
                    Logger.log(3, this, "Setting private text on TextStore:" + storedTextAttribute);
                }
                valid = this.setObjectProps(softwareComponent, storedTextAttribute, storedPrivateTextAttribute);
            } else {
                valid = false;
                Logger.log(0, this, "Error setting object properties:");
                Logger.log(0, this, "   connected:" + this.connected);
                Logger.log(0, this, "   SoftwareComponent:" + softwareComponent);
            }
        }
        return valid;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setExistingproperties(String existingproperties) {
        this.existingproperties = existingproperties;
    }

    public void setFqid(String fqid) {
        this.fqid = fqid;
    }

    public void setProductcode(String productcode) {
        this.productcode = productcode;
    }

    public void setPropertysetrefid(String propertysetrefid) {
        this.propertysetrefid = propertysetrefid;
    }

    public boolean makeConnection(String host, String port, String user, String password, String repository) {
        this.m_mdFactory = ObjectPropertiesUtil.makeConnection(this, host, port, user, password);
        if (this.m_mdFactory == null) {
            return false;
        }
        this.m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(this, this.m_mdFactory);
        if (this.m_mdObjectStore == null) {
            return false;
        }
        this.connected = true;
        return true;
    }

    public void closeConnection() {
        ObjectPropertiesUtil.closeConnection(this, this.m_mdFactory);
    }

    private Root getRoot() {
        return ObjectPropertiesUtil.getRoot(this, this.m_mdFactory, this.fqid, this.m_mdObjectStore, this.m_repositoryFQID);
    }

    private boolean setObjectProps(Root softwareComponent, String publicProperties, String privateProperties) {
        return ObjectPropertiesUtil.setObjectProps(this, this.m_mdFactory, this.m_mdObjectStore, this.m_reposID, softwareComponent, publicProperties, privateProperties);
    }

    private boolean addDependency(Root softwareComponent, String tempFQID) {
        try {
            String tempreposID = tempFQID.substring(0, 8);
            String temprepositoryFQID = "A0000001." + tempreposID;
            Root dependent = ObjectPropertiesUtil.getRoot(this, this.m_mdFactory, tempFQID, this.m_mdObjectStore, temprepositoryFQID);
            if (dependent == null) {
                Logger.log(0, this, "Error during adding of dependency.  FQID: " + tempFQID + " not found.");
                return false;
            }
            AssociationList al = ((SoftwareComponent)softwareComponent).getDependsOnComponents();
            if (al == null) {
                Logger.log(0, this, "Error during adding of dependency.  Null dependency list.");
                return false;
            }
            al.add((Object)dependent);
            String name = dependent.getName();
            Logger.log(3, this, "Added dependency for " + softwareComponent.getFQID() + " on Name:" + name + " FQID:" + tempFQID + "\n");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        catch (MdException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String getBuiltinPropertValue(String propertyName) {
        String propertyValue = null;
        if (this.prefix != null && (propertyValue = this.getProject().getProperty(this.prefix + propertyName)) != null) {
            Logger.log(3, this, "Found property named with prefix: " + this.prefix + propertyName + " so overriding with value from prefixed property: " + propertyValue);
        }
        if (propertyValue == null) {
            propertyValue = this.getProject().getProperty(propertyName);
        }
        return propertyValue;
    }
}

