/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.NamespaceRegistry;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.util.Map;

public final class PublishProperties
extends TaskImpl {
    private static final String _DEFAULT_NAMESPACE = "webappconfig.";
    private String _namespace;
    private PropertyMap _properties;

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this._properties = this.readProperties(null, "files", "source");
        this.setNamespace();
        if (this.paramExists("properties")) {
            this.publishSelectedProperties();
        } else {
            this.publishAllProperties();
        }
        this.registerNamespace();
        return true;
    }

    private void registerNamespace() {
        NamespaceRegistry.getInstance().registerNamespace(this, this._namespace, this.getPropertySource());
    }

    private void publishSelectedProperties() throws WebAppConfigException {
        String selectedProperties = this.getValue("properties");
        String[] properties = CommonUtils.parseCommaDelimitedInput(selectedProperties);
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i];
            Object value = this._properties.get(propertyName);
            if (null == value) {
                Logger.log(1, this, ErrorHandling.generateMissingPropertyErrorMessage(this, propertyName, this.getPropertySource()));
                continue;
            }
            this.createProperty(propertyName, value.toString());
        }
    }

    private void publishAllProperties() {
        for (Map.Entry entry : this._properties.entrySet()) {
            this.createProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private void createProperty(String propertyName, String propertyValue) {
        this.setProperty(this._namespace + propertyName, propertyValue);
    }

    private void setNamespace() throws WebAppConfigException {
        String candidateNamespace;
        String namespace = _DEFAULT_NAMESPACE;
        if (this.paramExists("namespace") && !CommonUtils.isEmpty(candidateNamespace = this.getValue("namespace"))) {
            namespace = candidateNamespace.endsWith(".") ? candidateNamespace : candidateNamespace + ".";
        }
        this._namespace = namespace;
    }
}

