/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.GetObjectProperties;
import com.sas.tools.webappconfig.tasks.SetObjectProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PropertyEditor
extends JFrame
implements WindowListener,
ActionListener,
ListSelectionListener {
    String host = "hpusrv001.na.sas.com";
    String port = "8561";
    String user = "sasadm@saspw";
    String password = "Password";
    String repository = "Foundation";
    String prefix = "";
    String fqid = "A5YNUPR6.AU000004";
    JButton applyButton;
    JButton cancelButton;
    JButton refreshObjectsButton;
    JButton refreshPropertiesButton;
    JButton okButton;
    JButton addRowButton;
    JButton deleteRowButton;
    JTextField hostTextField;
    JTextField portTextField;
    JTextField userTextField;
    JTextField passwordTextField;
    JTextField repositoryTextField;
    JTextField confobjTextField;
    JList idList;
    JTable propTable;
    MyTableModel tableModel;

    public void setConnectionInformation(String host, String port, String user, String password, String repository) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.repository = repository;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setFQID(String s) {
        this.fqid = s;
    }

    public static void main(String[] args) {
        PropertyEditor frame = new PropertyEditor();
        frame.pack();
        frame.setSize(800, 500);
        frame.setVisible(true);
        frame.setTitle("Property Editor");
    }

    public PropertyEditor() {
        BorderLayout overallLayout = new BorderLayout();
        overallLayout.setHgap(15);
        overallLayout.setVgap(15);
        this.getContentPane().setLayout(overallLayout);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        bottomPanel.add(this.applyButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.addRowButton = new JButton("Add property");
        this.addRowButton.addActionListener(this);
        this.deleteRowButton = new JButton("Delete selected property");
        this.deleteRowButton.addActionListener(this);
        bottomPanel.add(this.cancelButton);
        bottomPanel.add(this.okButton);
        this.getContentPane().add("South", bottomPanel);
        JPanel topPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(8);
        topPanel.setLayout(gridLayout);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        this.confobjTextField = new JTextField("");
        this.confobjTextField.setPreferredSize(new Dimension(140, 20));
        this.confobjTextField.setMaximumSize(new Dimension(140, 20));
        JLabel confobjLabel = new JLabel("12Byte:  ");
        this.idList = new JList();
        this.idList.setSelectionMode(0);
        this.idList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.idList);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout());
        panel1.add("Center", scrollPane);
        leftPanel.add("North", panel1);
        this.refreshPropertiesButton = new JButton("Refresh Properties");
        this.refreshPropertiesButton.addActionListener(this);
        panel2.add(confobjLabel);
        panel2.add(this.confobjTextField);
        panel2.add(this.refreshPropertiesButton);
        leftPanel.add("South", panel2);
        topPanel.add(leftPanel);
        JPanel topRightPanel = new JPanel();
        topRightPanel.setLayout(new GridLayout(6, 2));
        JLabel hostLabel = new JLabel("Host:");
        JLabel portLabel = new JLabel("Port:");
        JLabel userLabel = new JLabel("User:");
        JLabel passwordLabel = new JLabel("Password:");
        JLabel repositoryLabel = new JLabel("Repository:");
        JLabel tempLabel = new JLabel("");
        this.refreshObjectsButton = new JButton("Refresh Objects");
        this.refreshObjectsButton.addActionListener(this);
        this.hostTextField = new JTextField(this.host);
        this.portTextField = new JTextField(this.port);
        this.userTextField = new JTextField(this.user);
        this.passwordTextField = new JTextField(this.password);
        this.repositoryTextField = new JTextField(this.repository);
        topRightPanel.add(hostLabel);
        topRightPanel.add(this.hostTextField);
        topRightPanel.add(portLabel);
        topRightPanel.add(this.portTextField);
        topRightPanel.add(userLabel);
        topRightPanel.add(this.userTextField);
        topRightPanel.add(passwordLabel);
        topRightPanel.add(this.passwordTextField);
        topRightPanel.add(repositoryLabel);
        topRightPanel.add(this.repositoryTextField);
        topRightPanel.add(tempLabel);
        topRightPanel.add(this.refreshObjectsButton);
        topPanel.add(topRightPanel);
        this.getContentPane().add("North", topPanel);
        this.tableModel = new MyTableModel();
        this.propTable = new JTable(this.tableModel);
        JScrollPane scrollpane = new JScrollPane(this.propTable);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add("Center", scrollpane);
        JLabel titleLabel = new JLabel("Configurable Object Properties");
        titleLabel.setFont(new Font(titleLabel.getFont().getFamily(), 1, 12));
        titleLabel.setHorizontalAlignment(0);
        centerPanel.add("North", titleLabel);
        JPanel addRowPanel = new JPanel();
        addRowPanel.setLayout(new FlowLayout());
        addRowPanel.add(this.addRowButton);
        addRowPanel.add(this.deleteRowButton);
        centerPanel.add("South", addRowPanel);
        this.getContentPane().add("Center", centerPanel);
        this.addWindowListener(this);
    }

    public void init() {
        this.setSize(600, 300);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private MyTableModel getTableModel() {
        MyTableModel tm = new MyTableModel();
        Vector vectorModel = this.getVectorModel();
        tm.setDataVector(vectorModel, this.getColIds());
        return tm;
    }

    private Vector getVectorModel() {
        Vector<Object> v;
        int i;
        Properties publicProps = new Properties();
        Properties privateProps = new Properties();
        Properties modeledProps = new Properties();
        this.getObjectProperties(publicProps, privateProps, modeledProps);
        Vector data = new Vector();
        Object[] names = publicProps.keySet().toArray(new String[0]);
        Arrays.sort(names);
        String modeledProp = null;
        for (i = 0; i < names.length; ++i) {
            v = new Vector<Object>();
            v.add(names[i]);
            modeledProp = modeledProps.getProperty((String)names[i]);
            if (modeledProp == null) {
                v.add(publicProps.get(names[i]));
                v.add("Public");
                v.add("False");
            } else {
                v.add(modeledProp);
                v.add("Public");
                v.add("True");
            }
            data.add(v);
        }
        names = privateProps.keySet().toArray(new String[0]);
        Arrays.sort(names);
        for (i = 0; i < names.length; ++i) {
            v = new Vector();
            v.add(names[i]);
            modeledProp = modeledProps.getProperty((String)names[i]);
            if (modeledProp == null) {
                v.add(privateProps.get(names[i]));
                v.add("Private");
                v.add("False");
            } else {
                v.add(modeledProp);
                v.add("Private");
                v.add("True");
            }
            data.add(v);
        }
        return data;
    }

    private String[] getObjectList() {
        String[] returnStrings = null;
        GetObjectProperties gop = new GetObjectProperties();
        gop.setFqid((String)this.idList.getSelectedValue());
        gop.setInclude("ALL");
        boolean connected = gop.makeConnection(this.hostTextField.getText(), this.portTextField.getText(), this.userTextField.getText(), this.passwordTextField.getText(), this.repositoryTextField.getText());
        if (connected) {
            HashMap objectHash = gop.getSoftwareComponents();
            if (objectHash != null) {
                returnStrings = objectHash.keySet().toArray(new String[0]);
                for (int i = 0; i < returnStrings.length; ++i) {
                    returnStrings[i] = objectHash.get(returnStrings[i]).toString() + "     :" + returnStrings[i];
                }
            }
            gop.closeConnection();
            Arrays.sort(returnStrings);
        }
        return returnStrings;
    }

    private void getObjectProperties(Properties publicProps, Properties privateProps, Properties modeledProps) {
        this.printConnectionInfo();
        if (this.hostTextField.getText() == null || this.portTextField.getText() == null || this.repositoryTextField.getText() == null || this.userTextField.getText() == null || this.passwordTextField.getText() == null || this.idList.isSelectionEmpty()) {
            return;
        }
        GetObjectProperties gop = new GetObjectProperties();
        String fqid = this.confobjTextField.getText();
        gop.setFqid(fqid);
        gop.setInclude("ALL");
        boolean connected = gop.makeConnection(this.hostTextField.getText(), this.portTextField.getText(), this.userTextField.getText(), this.passwordTextField.getText(), this.repositoryTextField.getText());
        Properties p = new Properties();
        if (connected) {
            gop.getAllObjectProperties(publicProps, privateProps, modeledProps);
            gop.closeConnection();
        }
    }

    private void setObjectProperties(HashMap publicProperties, HashMap privateProperties) {
        if (this.hostTextField.getText() == null || this.portTextField.getText() == null || this.repositoryTextField.getText() == null || this.userTextField.getText() == null || this.passwordTextField.getText() == null || this.idList.isSelectionEmpty()) {
            return;
        }
        SetObjectProperties sop = new SetObjectProperties();
        String fqid = this.confobjTextField.getText();
        sop.setFqid(fqid);
        boolean connected = sop.makeConnection(this.hostTextField.getText(), this.portTextField.getText(), this.userTextField.getText(), this.passwordTextField.getText(), this.repositoryTextField.getText());
        if (connected) {
            sop.setObjectProperties(publicProperties, privateProperties);
            sop.closeConnection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String modeled;
        String scope;
        String value;
        String name;
        int i;
        int numRows;
        int selected;
        HashMap<String, String> publicHashMap = new HashMap<String, String>();
        HashMap<String, String> privateHashMap = new HashMap<String, String>();
        if (e.getSource().equals(this.applyButton) && (selected = JOptionPane.showConfirmDialog(null, "Are you sure you want to set these properties in metadata?", "Confirm Apply Properties", 0, 2)) == 0) {
            numRows = this.tableModel.getRowCount();
            for (i = 0; i < numRows; ++i) {
                name = (String)this.tableModel.getValueAt(i, 0);
                value = (String)this.tableModel.getValueAt(i, 1);
                scope = (String)this.tableModel.getValueAt(i, 2);
                modeled = (String)this.tableModel.getValueAt(i, 3);
                System.out.println(name + " : " + value + " : " + scope + " : " + modeled);
                if (scope.equalsIgnoreCase("PUBLIC")) {
                    publicHashMap.put(name, value);
                    continue;
                }
                if (!scope.equalsIgnoreCase("PRIVATE")) continue;
                privateHashMap.put(name, value);
            }
            this.setObjectProperties(publicHashMap, privateHashMap);
        }
        if (e.getSource().equals(this.okButton)) {
            selected = JOptionPane.showConfirmDialog(null, "Are you sure you want to set these properties in metadata?", "Confirm Apply Properties", 0, 2);
            if (selected == 0) {
                numRows = this.tableModel.getRowCount();
                for (i = 0; i < numRows; ++i) {
                    name = (String)this.tableModel.getValueAt(i, 0);
                    value = (String)this.tableModel.getValueAt(i, 1);
                    scope = (String)this.tableModel.getValueAt(i, 2);
                    modeled = (String)this.tableModel.getValueAt(i, 3);
                    System.out.println(name + " : " + value + " : " + scope);
                    if (!modeled.equalsIgnoreCase("FALSE")) continue;
                    if (scope.equalsIgnoreCase("PUBLIC")) {
                        publicHashMap.put(name, value);
                        continue;
                    }
                    if (!scope.equalsIgnoreCase("PRIVATE")) continue;
                    privateHashMap.put(name, value);
                }
                this.setObjectProperties(publicHashMap, privateHashMap);
            }
            System.exit(0);
        }
        if (e.getSource().equals(this.addRowButton)) {
            Vector<String> v = new Vector<String>();
            v.add(" ");
            v.add(" ");
            v.add(" ");
            v.add("False");
            this.tableModel.addRow(v);
            this.tableModel.fireTableDataChanged();
            this.propTable.repaint();
        }
        if (e.getSource().equals(this.deleteRowButton)) {
            int selected2;
            int i2 = this.propTable.getSelectedRow();
            if (i2 != -1 && (selected2 = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this property?", "Confirm Property Delete", 0, 2)) == 0) {
                this.tableModel.removeRow(i2);
                this.tableModel.fireTableDataChanged();
                this.propTable.repaint();
            }
        } else if (e.getSource().equals(this.cancelButton)) {
            System.exit(0);
        } else if (e.getSource().equals(this.refreshPropertiesButton)) {
            Vector vectorModel = this.getVectorModel();
            this.tableModel.setDataVector(vectorModel, this.getColIds());
            this.resetTable();
            this.tableModel.fireTableDataChanged();
            this.propTable.repaint();
        } else if (e.getSource().equals(this.refreshObjectsButton)) {
            Vector data = new Vector();
            if (this.tableModel != null) {
                this.tableModel.setDataVector(data, this.getColIds());
                this.tableModel.fireTableDataChanged();
            }
            this.propTable.repaint();
            String[] dataValues = this.getObjectList();
            this.idList.setListData(dataValues);
            this.idList.clearSelection();
        } else if (e.getSource().equals(this.hostTextField)) {
            System.out.println("TEXTCHANGE");
        }
    }

    private void printConnectionInfo() {
        System.out.println(this.hostTextField.getText());
        System.out.println(this.portTextField.getText());
        System.out.println(this.repositoryTextField.getText());
        System.out.println(this.userTextField.getText());
        System.out.println(this.passwordTextField.getText());
    }

    private Vector getColIds() {
        Vector<String> v = new Vector<String>();
        v.add("Name");
        v.add("Value");
        v.add("Scope");
        v.add("Modeled");
        return v;
    }

    private void resetTable() {
        this.propTable.setAutoCreateColumnsFromModel(true);
        this.propTable.setSelectionMode(0);
        this.propTable.setRowSelectionAllowed(true);
        this.propTable.setColumnSelectionAllowed(false);
        if (this.propTable.getColumnCount() <= 0) {
            return;
        }
        TableColumn column = null;
        for (int i = 0; i < 4; ++i) {
            column = this.propTable.getColumnModel().getColumn(i);
            if (i == 2) {
                column.setPreferredWidth(50);
                continue;
            }
            column.setPreferredWidth(150);
        }
        String[] values = new String[]{"Public", "Private"};
        int vColIndex = 2;
        TableColumn col = this.propTable.getColumnModel().getColumn(vColIndex);
        col.setCellEditor(new MyComboBoxEditor(values));
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        String fqid = (String)this.idList.getSelectedValue();
        this.confobjTextField.setText(fqid.substring(fqid.lastIndexOf(":") + 1));
    }

    protected class MyTableModel
    extends DefaultTableModel {
        protected MyTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 3) {
                return false;
            }
            return !((String)this.getValueAt(row, 3)).equalsIgnoreCase("True");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            super.setValueAt(value, row, col);
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int arg0) {
            return this.getValueAt(0, arg0).getClass();
        }
    }

    public class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(String[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

