/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.tools.webappconfig.util.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Task;

public class ObjectPropertiesUtil {
    public static final String COMPONENT_NAME = "SAS Deployment Wizard";
    public static final String PUBLIC_TEXT_STORE_NAME = "Public Configuration Properties";
    public static final String PRIVATE_TEXT_STORE_NAME = "Private Configuration Properties";
    private static final HashMap<String, String> MODELED_PROPERTY_CLASSNAMES = new HashMap<String, String>(){
        {
            this.put("SAS Application Server", "com.sas.tools.webappconfig.foundationservers.LevConfigProperties");
            this.put("IOM Spawner", "com.sas.tools.webappconfig.foundationservers.FoundationServersProperties");
            this.put("f3f46472-1e31-11d5-87c2-00c04f38f9f6", "com.sas.tools.webappconfig.foundationservers.FoundationServersProperties");
            this.put("SHARE", "com.sas.tools.webappconfig.foundationservers.FoundationServersProperties");
            this.put("15931E31-667F-11D5-8804-00C04F35AC8C", "com.sas.tools.webappconfig.foundationservers.FoundationServersProperties");
            this.put("440196D4-90F0-11D0-9F41-00A024BB830C", "com.sas.tools.webappconfig.foundationservers.FoundationServersProperties");
            this.put("620963ee-32bf-4128-bf5f-4b0df8ff90eb", "com.sas.tools.webappconfig.foundationservers.FoundationServersProperties");
        }
    };

    public static String getModeledPropertyClassname(String classid) {
        return MODELED_PROPERTY_CLASSNAMES.get(classid);
    }

    public static MdFactory makeConnection(Task owner, String host, String port, String user, String password) {
        MdFactoryImpl m_mdFactory = null;
        if (host == null || port == null || user == null || password == null) {
            Logger.log(0, owner, "One or more inputs needed for connection were invalid: \n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
            return null;
        }
        try {
            m_mdFactory = new MdFactoryImpl(false);
            if (m_mdFactory != null) {
                m_mdFactory.setDebug(false);
                m_mdFactory.getUtil().setOutputStream((OutputStream)System.out);
                m_mdFactory.setLoggingEnabled(false);
                m_mdFactory.getUtil().setLogStream((OutputStream)System.out);
                MdOMRConnection connection = m_mdFactory.getConnection();
                connection.makeOMRConnection(host, port, user, password);
                Logger.log(2, owner, "Successful connection to the metadata server: \n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
            }
        }
        catch (Exception e) {
            Logger.log(0, owner, "Error connecting to the metadata server: " + e.getMessage() + "\n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
            Logger.log(0, owner, "   m_mdFactory: " + m_mdFactory);
        }
        return m_mdFactory;
    }

    public static MdObjectStore createObjectStore(Task owner, MdFactory m_mdFactory) {
        if (m_mdFactory == null) {
            Logger.log(0, owner, "Error creating object store: ");
            Logger.log(0, owner, "   m_mdFactory: " + m_mdFactory);
        }
        MdObjectStore m_mdObjectStore = null;
        try {
            m_mdObjectStore = m_mdFactory.createObjectStore(null, "SDW: ConfigurationStore");
        }
        catch (Exception e) {
            Logger.log(0, owner, "Error creating object store: " + e.getMessage());
            Logger.log(0, owner, "   m_mdObjectStore: " + m_mdObjectStore);
        }
        return m_mdObjectStore;
    }

    public static void closeConnection(Task owner, MdFactory m_mdFactory) {
        if (m_mdFactory != null) {
            try {
                m_mdFactory.closeOMRConnection();
            }
            catch (Exception e) {
                Logger.log(0, owner, "Error closing metadata server connection: " + e.getMessage());
                Logger.log(0, owner, "   m_mdFactory: " + m_mdFactory);
            }
        }
    }

    public static Root getRoot(Task owner, MdFactory m_mdFactory, String fqid, MdObjectStore m_mdObjectStore, String m_repositoryFQID) {
        Root softwareComponent = null;
        String metadataType = "SoftwareComponent";
        boolean found = false;
        try {
            Logger.log(3, owner, "fqid: " + fqid);
            int flags = 400;
            String xmlSelect = "<XMLSelect search=\"*[@Id='" + fqid + "']\"/>";
            List objectsList = m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_mdObjectStore, m_repositoryFQID, metadataType, flags, xmlSelect);
            System.out.println("objectsList:" + objectsList);
            if (objectsList != null && objectsList.size() > 0) {
                softwareComponent = (Root)objectsList.get(0);
                found = true;
            }
            if (found) {
                Logger.log(3, owner, "Existing software component found: SAS Deployment Wizard");
            }
        }
        catch (Exception e) {
            Logger.log(0, owner, "Error finding software component: " + e.getMessage());
            Logger.log(0, owner, "   fqid: " + fqid);
            Logger.log(0, owner, "   m_mdFactory: " + m_mdFactory);
            Logger.log(0, owner, "   m_mdObjectStore: " + m_mdObjectStore);
            Logger.log(0, owner, "   m_repositoryFQID: " + m_repositoryFQID);
        }
        return softwareComponent;
    }

    public static void getObjectProps(MdFactory m_mdFactory, String fqid, Properties publicProperties, Properties privateProperties) {
        TextStore publicTextStore;
        Properties tempPublicProperties;
        String m_reposID = fqid.substring(0, 8);
        String m_repositoryFQID = "A0000001." + m_reposID;
        MdObjectStore m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(null, m_mdFactory);
        Root root = ObjectPropertiesUtil.getRoot(null, m_mdFactory, fqid, m_mdObjectStore, m_repositoryFQID);
        TextStore privateTextStore = ObjectPropertiesUtil.getTextStore(null, root, false);
        Properties tempPrivateProperties = ObjectPropertiesUtil.createProperties(null, privateTextStore);
        if (tempPrivateProperties != null) {
            privateProperties.putAll((Map<?, ?>)tempPrivateProperties);
        }
        if ((tempPublicProperties = ObjectPropertiesUtil.createProperties(null, publicTextStore = ObjectPropertiesUtil.getTextStore(null, root, true))) != null) {
            publicProperties.putAll((Map<?, ?>)tempPublicProperties);
        }
    }

    public static boolean setObjectProps(MdFactory m_mdFactory, String fqid, Properties publicProperties, Properties privateProperties) {
        MdObjectStore m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(null, m_mdFactory);
        String m_reposID = fqid.substring(0, 8);
        String m_repositoryFQID = "A0000001." + m_reposID;
        Root softwareComponent = ObjectPropertiesUtil.getRoot(null, m_mdFactory, fqid, m_mdObjectStore, m_repositoryFQID);
        String publicPropertiesString = ObjectPropertiesUtil.getStringFromProperties(null, publicProperties);
        String privatePropertiesString = ObjectPropertiesUtil.getStringFromProperties(null, privateProperties);
        return ObjectPropertiesUtil.setObjectProps(null, m_mdFactory, m_mdObjectStore, m_reposID, softwareComponent, publicPropertiesString, privatePropertiesString);
    }

    public static void getObjectProps(MdFactory m_mdFactory, Root softwareComponent, Properties publicProperties, Properties privateProperties) {
        TextStore publicTextStore;
        Properties tempPublicProperties;
        TextStore privateTextStore = ObjectPropertiesUtil.getTextStore(null, softwareComponent, false);
        Properties tempPrivateProperties = ObjectPropertiesUtil.createProperties(null, privateTextStore);
        if (tempPrivateProperties != null) {
            privateProperties.putAll((Map<?, ?>)tempPrivateProperties);
        }
        if ((tempPublicProperties = ObjectPropertiesUtil.createProperties(null, publicTextStore = ObjectPropertiesUtil.getTextStore(null, softwareComponent, true))) != null) {
            publicProperties.putAll((Map<?, ?>)tempPublicProperties);
        }
    }

    public static boolean setObjectProps(MdFactory m_mdFactory, Root softwareComponent, Properties publicProperties, Properties privateProperties) {
        String m_reposID;
        MdObjectStore m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(null, m_mdFactory);
        try {
            m_reposID = softwareComponent.getFQID().substring(0, 8);
        }
        catch (Exception e) {
            return false;
        }
        String publicPropertiesString = ObjectPropertiesUtil.getStringFromProperties(null, publicProperties);
        String privatePropertiesString = ObjectPropertiesUtil.getStringFromProperties(null, privateProperties);
        return ObjectPropertiesUtil.setObjectProps(null, m_mdFactory, m_mdObjectStore, m_reposID, softwareComponent, publicPropertiesString, privatePropertiesString);
    }

    public static boolean setObjectProps(Task owner, MdFactory m_mdFactory, MdObjectStore m_mdObjectStore, String m_reposID, Root softwareComponent, String publicProperties, String privateProperties) {
        boolean valid = true;
        try {
            AssociationList al = softwareComponent.getNotes();
            Object[] objectArray = al.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof TextStore) || !((TextStore)objectArray[i]).getName().equals(PUBLIC_TEXT_STORE_NAME) && !((TextStore)objectArray[i]).getName().equals(PRIVATE_TEXT_STORE_NAME)) continue;
                ((TextStore)objectArray[i]).delete();
            }
            TextStore textStore = (TextStore)m_mdFactory.createComplexMetadataObject(m_mdObjectStore, PUBLIC_TEXT_STORE_NAME, "TextStore", m_reposID);
            textStore.setStoredText(publicProperties);
            softwareComponent.getNotes().add((Object)textStore);
            Logger.log(3, owner, "\n\nCreating TextStore Object to store the Public Properties \n<TextStore Name=\"" + textStore.getName() + "\" /> \n\nPublic Properties: \n" + publicProperties);
            if (privateProperties != null) {
                TextStore ptextStore = (TextStore)m_mdFactory.createComplexMetadataObject(m_mdObjectStore, PRIVATE_TEXT_STORE_NAME, "TextStore", m_reposID);
                ptextStore.setStoredText(privateProperties);
                softwareComponent.getNotes().add((Object)ptextStore);
                Logger.log(3, owner, "\n\nCreating TextStore Object to store the Private Properties \n<TextStore Name=\"" + ptextStore.getName() + "\" /> \n\nPrivate Properties: \n" + privateProperties);
            }
        }
        catch (Exception e) {
            valid = false;
            Logger.log(0, owner, "Error creating text store: " + e.getMessage());
            Logger.log(0, owner, "   m_mdFactory: " + m_mdFactory);
            Logger.log(0, owner, "   m_mdObjectStore: " + m_mdObjectStore);
            Logger.log(0, owner, "   m_reposID: " + m_reposID);
            Logger.log(0, owner, "   softwareComponent: " + softwareComponent);
        }
        if (valid) {
            try {
                softwareComponent.updateMetadataAll();
            }
            catch (Exception e) {
                valid = false;
                Logger.log(0, owner, "Error saving metadata: " + e.getMessage());
                Logger.log(0, owner, "   m_mdFactory: " + m_mdFactory);
                Logger.log(0, owner, "   m_mdObjectStore: " + m_mdObjectStore);
                Logger.log(0, owner, "   m_reposID: " + m_reposID);
                Logger.log(0, owner, "   softwareComponent: " + softwareComponent);
            }
        }
        return valid;
    }

    public static TextStore getTextStore(Task owner, Root root, boolean publicVersion) {
        TextStore textStore = null;
        try {
            AssociationList al = root.getNotes();
            for (Object o : al) {
                if (publicVersion && o instanceof TextStore && ((TextStore)o).getName().equals(PUBLIC_TEXT_STORE_NAME)) {
                    textStore = (TextStore)o;
                    continue;
                }
                if (publicVersion || !(o instanceof TextStore) || !((TextStore)o).getName().equals(PRIVATE_TEXT_STORE_NAME)) continue;
                textStore = (TextStore)o;
            }
            if (textStore == null) {
                Logger.log(0, owner, "Text store not found for: SAS Deployment Wizard");
                Logger.log(0, owner, "   SoftwareComponent: " + root);
            }
        }
        catch (Exception e) {
            Logger.log(0, owner, "Error getting text store: " + e.getMessage());
            Logger.log(0, owner, "   SoftwareComponent: " + root);
        }
        return textStore;
    }

    public static void appendProperties(Task owner, HashMap hashMap, TextStore textStore) {
        try {
            String storedTextAttribute = textStore.getStoredText();
            StringReader reader = new StringReader(storedTextAttribute);
            PropertyMap myProperties = new PropertyMap();
            myProperties.load((Reader)reader);
            Iterator iterator = myProperties.getPropertyIterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                String propValue = myProperties.getProperty(propName);
                hashMap.put(propName, propValue);
            }
        }
        catch (Exception e) {
            Logger.log(0, owner, "Error retrieving text from TextStore: " + e.getMessage());
            Logger.log(0, owner, "     TextStore: " + textStore);
        }
    }

    public static String getStringFromProperties(Task owner, HashMap myProperties) {
        PropertyList myPropertyList = new PropertyList();
        String[] s = myProperties.keySet().toArray(new String[0]);
        if (s != null && s.length > 0) {
            for (int i = 0; i < s.length; ++i) {
                myPropertyList.addProperty(s[i], (String)myProperties.get(s[i]));
            }
        }
        StringWriter writer = new StringWriter();
        try {
            myPropertyList.save((Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String storedTextAttribute = writer.toString();
        storedTextAttribute = storedTextAttribute.replaceAll("\\r", "");
        return storedTextAttribute;
    }

    public static String getStringFromProperties(Task owner, Properties myProperties) {
        PropertyList myPropertyList = new PropertyList();
        String[] s = myProperties.keySet().toArray(new String[0]);
        if (s != null && s.length > 0) {
            for (int i = 0; i < s.length; ++i) {
                myPropertyList.addProperty(s[i], (String)myProperties.get(s[i]));
                Logger.log(3, owner, "Adding property value:" + (String)myProperties.get(s[i]) + ":");
            }
        }
        StringWriter writer = new StringWriter();
        try {
            myPropertyList.save((Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String storedTextAttribute = writer.toString();
        storedTextAttribute = storedTextAttribute.replaceAll("\\r", "");
        return storedTextAttribute;
    }

    public static Properties createProperties(Task owner, TextStore textStore) {
        Properties props = new Properties();
        try {
            String storedTextAttribute = textStore.getStoredText();
            StringReader reader = new StringReader(storedTextAttribute);
            PropertyMap myProperties = new PropertyMap();
            myProperties.load((Reader)reader);
            Iterator iterator = myProperties.getPropertyIterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                String propValue = myProperties.getProperty(propName);
                Logger.log(3, owner, "Found saved property     name: " + propName + " value: " + propValue);
                props.put(propName, propValue);
            }
        }
        catch (Exception e) {
            Logger.log(0, owner, "Error retrieving text from TextStore: " + e.getMessage());
            Logger.log(0, owner, " TextStore: " + textStore);
            return null;
        }
        return props;
    }
}

