/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.util.ErrorHandling;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergeProperties
extends Task {
    private File mergeFile;
    private File importFile;
    private File destFile;

    public void execute() throws BuildException {
        this.validate();
        Properties props = new Properties();
        Properties newProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.mergeFile);
            FileInputStream in2 = new FileInputStream(this.importFile);
            try {
                props.load(in);
                newProps.load(in2);
                Enumeration<?> enumProps = newProps.propertyNames();
                while (enumProps.hasMoreElements()) {
                    String key = (String)enumProps.nextElement();
                    props.setProperty(key, newProps.getProperty(key));
                }
                props.store(new FileOutputStream(this.destFile), null);
            }
            catch (Exception e) {
                throw new BuildException(ErrorHandling.generateFileReadingError(this), (Throwable)e);
            }
            finally {
                ((InputStream)in).close();
                ((InputStream)in2).close();
            }
        }
        catch (IOException IOe) {
            throw new BuildException(ErrorHandling.generateFileReadingError(this), (Throwable)IOe);
        }
    }

    private void validate() throws BuildException {
        if (!this.importFile.canRead()) {
            String message = ErrorHandling.generateFileReadingErrorWithFilename(this, this.importFile.getName());
            throw new BuildException(message);
        }
        if (!this.mergeFile.canRead()) {
            String message = ErrorHandling.generateFileReadingErrorWithFilename(this, this.mergeFile.getName());
            throw new BuildException(message);
        }
        if (!this.destFile.exists()) {
            try {
                this.destFile.createNewFile();
            }
            catch (IOException e) {
                throw new BuildException(ErrorHandling.generateFileCreationError(this, this.destFile.getName()));
            }
        }
    }

    public void setFile(File file) {
        this.mergeFile = file;
    }

    public void setImportFile(File file) {
        this.importFile = file;
    }

    public void setToFile(File file) {
        this.destFile = file;
    }
}

