/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.tools.webappconfig.tasks.ModeledPropertyFactory;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.tasks.ObjectPropertiesUtil;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.Reference;

public class GetObjectProperties
extends TaskImpl {
    private static final int FAILURE_NOT_FOUND = 0;
    private static final int FAILURE_BAD_FQID = 1;
    private String fqid = null;
    private String configobjClassname = null;
    private String referred12byte = null;
    private String errormessage = null;
    private String include = "Public";
    private String prefix = null;
    private String filtersetrefid = null;
    private String setdependency = "True";
    private String m_repositoryFQID = "";
    private String m_reposID = null;
    private MdFactory m_mdFactory = null;
    private MdObjectStore m_mdObjectStore = null;
    private boolean runningAntTask = false;
    private boolean gettingAll = false;
    private boolean connected = false;

    public Properties getObjectProperties() {
        Properties myProperties = null;
        HashMap map = new HashMap();
        if (!this.connected) {
            Logger.log(0, this, "Error:  Not connected to metadata server.");
            return null;
        }
        if (!this.isFqidValid()) {
            return null;
        }
        boolean valid = this.doActualWork(map, true, false);
        if (!valid) {
            Logger.log(0, this, "Error during getting of object properties.");
        }
        if (map == null || map.size() == 0) {
            myProperties = new Properties();
        } else {
            Collection c = map.values();
            if (c != null && c.size() >= 1) {
                myProperties = (Properties)c.toArray()[0];
            }
        }
        return myProperties;
    }

    public void getAllObjectProperties(Properties publicProps, Properties privateProps, Properties modeledProps) {
        this.gettingAll = true;
        HashMap map = new HashMap();
        if (!this.connected) {
            Logger.log(0, this, "Error:  Not connected to metadata server.");
            this.gettingAll = false;
            return;
        }
        if (!this.isFqidValid()) {
            return;
        }
        boolean valid = this.doActualWork(map, true, true);
        if (!valid) {
            Logger.log(0, this, "Error during getting of object properties.");
        }
        if (map != null) {
            Properties p = (Properties)map.get("PUBLIC");
            if (publicProps != null && p != null) {
                publicProps.putAll((Map<?, ?>)p);
            }
            p = (Properties)map.get("PRIVATE");
            if (privateProps != null && p != null) {
                privateProps.putAll((Map<?, ?>)p);
            }
            p = (Properties)map.get("MODELED");
            if (privateProps != null && p != null) {
                modeledProps.putAll((Map<?, ?>)p);
            }
        }
        this.gettingAll = false;
    }

    @Override
    public boolean doWork() throws WebAppConfigException {
        this.runningAntTask = true;
        Logger.log(3, this, "Using FQID: " + this.fqid);
        boolean valid = this.isFqidValid();
        if (!valid) {
            this.runningAntTask = false;
            return false;
        }
        String host = this.getAntProperty("iomsrv.metadatasrv.host");
        String port = this.getAntProperty("iomsrv.metadatasrv.port");
        String user = this.getAntProperty("metadata.connection.userid");
        String password = this.getAntProperty("metadata.connection.passwd");
        String repository = this.getAntProperty("oma.repository.foundation.name");
        this.connected = this.makeConnection(host, port, user, password, repository);
        valid = this.connected ? this.doActualWork(null, false, false) : false;
        if (this.connected) {
            this.closeConnection();
        }
        this.runningAntTask = false;
        return valid;
    }

    public HashMap getPropertiesForProduct(String classIdentifier, String metadataType) {
        boolean valid = true;
        if (!this.connected) {
            Logger.log(0, this, "Error:  Not connected to metadata server.");
            return null;
        }
        HashMap propMap = new HashMap();
        valid = this.getObjectProps(propMap, true, false, classIdentifier, metadataType);
        if (!valid) {
            Logger.log(0, this, "Error during getting of product properties.");
        }
        return propMap;
    }

    private boolean doActualWork(HashMap outProperties, boolean saveToProperties, boolean addSpecificProperties) {
        boolean valid = true;
        if (!this.connected) {
            return false;
        }
        this.m_reposID = this.fqid.substring(0, 8);
        this.m_repositoryFQID = "A0000001." + this.m_reposID;
        valid = this.getObjectProps(outProperties, saveToProperties, addSpecificProperties, null, null);
        if (!valid) {
            this.logAndIssueErrorToSDW(0);
        }
        return valid;
    }

    private boolean isFqidValid() {
        String errMsg = null;
        if (null == this.fqid) {
            errMsg = "Object property retrieval failed due to null fqid.";
        } else if (this.fqid.trim().equals("")) {
            errMsg = "Object property retrieval failed due to blank fqid.";
        } else if (this.fqid.matches("^\\$\\{.*\\}$")) {
            errMsg = "Object property retrieval failed since requested fqid is an unexpanded property: " + this.fqid;
            if (null == this.referred12byte) {
                String[] knownPatterns = new String[]{"^\\$\\{\\w+\\.dependson\\.(\\w+)\\.fqid\\}$", "^\\$\\{(\\w+)\\.configobj\\.fqid\\}$"};
                String extracted12byte = null;
                for (int i = 0; i < knownPatterns.length; ++i) {
                    extracted12byte = this.fqid.replaceFirst(knownPatterns[i], "$1");
                    if (extracted12byte.equals(this.fqid)) continue;
                    this.referred12byte = extracted12byte;
                    break;
                }
            }
        } else if (!this.fqid.matches("[a-zA-Z0-9]{8}\\.[a-zA-Z0-9]{8}")) {
            errMsg = "Object property retrieval failed due to invalid fqid: " + this.fqid;
        }
        if (null != errMsg) {
            if (null != this.getProject()) {
                for (int i = 0; i < 3; ++i) {
                    Logger.log(0, this, "*************** ERROR ****************");
                }
            }
            Logger.log(0, this, errMsg);
            this.logAndIssueErrorToSDW(1);
            return false;
        }
        return true;
    }

    private void logAndIssueErrorToSDW(int errorType) {
        String antLogMessage = null;
        String errProp = null;
        String useReference = this.getReferredLegalName();
        if (null == useReference) {
            useReference = this.referred12byte;
        }
        if (null == useReference) {
            antLogMessage = "No configured instance was found for the given fqid.";
            errProp = errorType == 1 ? "status.GetObjectProperties.bad.fqid.failure.msg" : "status.GetObjectProperties.failure.msg";
        } else {
            antLogMessage = "No configured instance was found using the given fqid for: " + useReference;
            errProp = errorType == 1 ? "status.GetObjectProperties.bad.fqid.refer.failure.msg" : "status.GetObjectProperties.refer.failure.msg";
        }
        Logger.log(0, this, antLogMessage);
        if (null == this.getProject()) {
            return;
        }
        if (null != this.errormessage) {
            this.setErrorMessageForSDW(this.errormessage);
            return;
        }
        String locMsg = this.getAntProperty(errProp);
        if (null == locMsg) {
            Logger.log(1, this, "Falling back to a non-localized error message.");
            locMsg = antLogMessage;
        } else if (null != useReference) {
            locMsg = locMsg + " " + useReference;
        }
        this.setErrorMessageForSDW(locMsg);
    }

    private String getReferredLegalName() {
        if (null == this.referred12byte) {
            return null;
        }
        return this.getAntProperty(this.referred12byte + ".legal.name");
    }

    private void setErrorMessageForSDW(String message) {
        String propFileProperty = "whatFailed.property.file";
        String propFileName = this.getAntProperty(propFileProperty);
        if (null == propFileName) {
            Logger.log(1, this, "Could not write to the status file since " + propFileProperty + " is not defined.");
            return;
        }
        File propFile = new File(propFileName);
        if (propFile.exists() && !propFile.isFile()) {
            Logger.log(1, this, "Cannot use the status file since it is not a real file (" + propFileName + ").");
            return;
        }
        Properties props = new Properties();
        String initVal = "";
        String failedProp = "error.whatFailed";
        props.setProperty(failedProp, initVal);
        if (propFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(propFile);
                props.load(fis);
                fis.close();
            }
            catch (Exception e) {
                Logger.log(1, this, "Error reading from properties file (" + propFileName + "): " + e);
            }
        }
        if (props.getProperty(failedProp).equals(initVal)) {
            props.setProperty(failedProp, this.getClass().getName());
        }
        props.setProperty("error.logfile", initVal);
        props.setProperty("error.task", initVal);
        props.setProperty("error.msg", message);
        props.setProperty("error.srcdir", initVal);
        props.setProperty("error.deploydir", initVal);
        props.setProperty("error.command", initVal);
        props.setProperty("error.commandline", initVal);
        props.setProperty("error.inifile", initVal);
        props.setProperty("error.serviceName", initVal);
        props.setProperty("error.docPart", initVal);
        props.setProperty("error.user", initVal);
        try {
            FileOutputStream fos = new FileOutputStream(propFile);
            props.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            Logger.log(0, this, "Error working with properties file (" + propFileName + "): " + e);
        }
    }

    private String getAntProperty(String property, boolean warnIfNotSet) {
        Project proj = this.getProject();
        if (null == proj) {
            return null;
        }
        String antValue = proj.getProperty(property);
        if (null == antValue && warnIfNotSet) {
            Logger.log(1, this, "Ant property is not set: " + property);
        }
        return antValue;
    }

    private String getAntProperty(String property) {
        return this.getAntProperty(property, true);
    }

    public void setConfigobjClassname(String configobjClassname) {
        this.configobjClassname = configobjClassname;
    }

    public void setFqid(String fqid) {
        this.fqid = fqid;
    }

    public void setReferred12byte(String referred12byte) {
        this.referred12byte = referred12byte;
    }

    public void setErrormessage(String errormessage) {
        this.errormessage = errormessage;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public void setSetdependency(String setdependency) {
        this.setdependency = setdependency;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setfiltersetrefid(String filtersetrefid) {
        this.filtersetrefid = filtersetrefid;
    }

    public boolean makeConnection(String host, String port, String user, String password, String repository) {
        boolean valid = true;
        this.m_mdFactory = ObjectPropertiesUtil.makeConnection(this, host, port, user, password);
        if (this.m_mdFactory == null) {
            return false;
        }
        this.m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(this, this.m_mdFactory);
        if (this.m_mdObjectStore == null) {
            return false;
        }
        if (repository != null) {
            try {
                List repositories = this.m_mdFactory.getOMIUtil().getRepositories();
                for (CMetadata repos : repositories) {
                    if (!repository.equals(repos.getName())) continue;
                    this.m_repositoryFQID = repos.getFQID();
                    this.m_reposID = this.m_repositoryFQID.substring(this.m_repositoryFQID.indexOf(".") + 1);
                }
                if (this.m_repositoryFQID == null || this.m_repositoryFQID == "") {
                    valid = false;
                    Logger.log(0, this, "Foundation repository not found: " + repository);
                }
            }
            catch (Exception e) {
                valid = false;
                Logger.log(0, this, "Error finding foundation repository: " + e.getMessage());
            }
        }
        this.connected = valid;
        return valid;
    }

    public void closeConnection() {
        ObjectPropertiesUtil.closeConnection(this, this.m_mdFactory);
    }

    private boolean getObjectProps(HashMap outProperties, boolean saveToProperties, boolean addSpecificProperties, String classIdentifier, String metadataType) {
        Logger.log(3, this, "Retrieving properties from metadata object Id=" + this.fqid);
        boolean valid = true;
        String modeledPropertiesClassName = null;
        Root[] softwareComponents = null;
        Properties publicProps = null;
        Properties privateProps = null;
        Properties modeledProps = null;
        if (metadataType == null) {
            metadataType = "SoftwareComponent";
        }
        boolean found = false;
        try {
            int flags = 408;
            String xmlSelect = classIdentifier != null ? "<XMLSelect search=\"*[@ClassIdentifier='" + classIdentifier + "']\"/>" : "<XMLSelect search=\"*[@Id='" + this.fqid + "']\"/>";
            List objectsList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_mdObjectStore, this.m_repositoryFQID, metadataType, flags, xmlSelect);
            if (objectsList != null && objectsList.size() > 0) {
                if (classIdentifier == null) {
                    softwareComponents = new Root[]{(Root)objectsList.get(0)};
                    found = true;
                } else {
                    softwareComponents = objectsList.toArray(new Root[0]);
                    found = true;
                }
            }
            if (!found) {
                valid = false;
                Logger.log(0, this, "Error finding software component: SAS Deployment Wizard");
                Logger.log(0, this, "   fqid: " + this.fqid);
                Logger.log(0, this, "   m_mdFactory: " + this.m_mdFactory);
                Logger.log(0, this, "   m_mdObjectStore: " + this.m_mdObjectStore);
                Logger.log(0, this, "   m_repositoryFQID: " + this.m_repositoryFQID);
            }
        }
        catch (Exception e) {
            valid = false;
            Logger.log(0, this, "Error finding software component: " + e.getMessage());
            Logger.log(0, this, "   fqid: " + this.fqid);
            Logger.log(0, this, "   m_mdFactory: " + this.m_mdFactory);
            Logger.log(0, this, "   m_mdObjectStore: " + this.m_mdObjectStore);
            Logger.log(0, this, "   m_repositoryFQID: " + this.m_repositoryFQID);
        }
        if (valid) {
            TextStore publicTextStore = null;
            TextStore privateTextStore = null;
            try {
                if (found) {
                    for (int i = 0; i < softwareComponents.length; ++i) {
                        Logger.log(3, this, "\nFound Valid Configurable Object\n<" + softwareComponents[i].getCMetadataType() + " Name=\"" + softwareComponents[i].getName() + "\" Id=\"" + softwareComponents[i].getFQID() + "\" MetadataCreated=\"" + softwareComponents[i].getMetadataCreated() + "\" MetadataUpdated=\"" + softwareComponents[i].getMetadataUpdated() + "\"/>\nNow retrieving properties:\n");
                        publicTextStore = this.getTextStore(softwareComponents[i], true);
                        privateTextStore = this.getTextStore(softwareComponents[i], false);
                        if (publicTextStore != null) {
                            Logger.log(3, this, "\nFound Public Properties TextStore Object\n<TextStore Name=\"" + publicTextStore.getName() + "\" Id=\"" + publicTextStore.getFQID() + "\" MetadataCreated=\"" + publicTextStore.getMetadataCreated() + "\" MetadataUpdated=\"" + publicTextStore.getMetadataUpdated() + "\"/>\n\nWith the following properties:\n");
                            publicProps = this.createProperties(publicTextStore);
                        } else {
                            publicProps = new Properties();
                            Logger.log(0, this, "No public text store found.  Using empty property list.");
                        }
                        Properties tempProps = null;
                        String owner12byte = null;
                        if (privateTextStore != null) {
                            Logger.log(3, this, "\nFound Private Properties TextStore Object\n<TextStore Name=\"" + privateTextStore.getName() + "\" Id=\"" + privateTextStore.getFQID() + "\" MetadataCreated=\"" + privateTextStore.getMetadataCreated() + "\" MetadataUpdated=\"" + privateTextStore.getMetadataUpdated() + "\"\n\nWith the following properties:\n");
                            tempProps = this.createProperties(privateTextStore);
                            owner12byte = tempProps.getProperty("12byte");
                            if (this.include.equalsIgnoreCase("All")) {
                                if (this.setdependency.equalsIgnoreCase("True")) {
                                    Root[] objectList;
                                    Logger.log(3, this, "Setting Dependency Properties - Using owner12byte=" + owner12byte);
                                    AssociationList al = ((SoftwareComponent)softwareComponents[0]).getDependsOnComponents();
                                    if (al != null && (objectList = (Root[])al.toArray((Object[])new Root[0])) != null && objectList.length > 0) {
                                        for (int j = 0; j < objectList.length; ++j) {
                                            Root dependsOnObject = objectList[j];
                                            String dependsonFQID = dependsOnObject.getFQID();
                                            Logger.log(3, this, "Setting Dependency Properties - Using dependsonFQID=" + dependsonFQID);
                                            TextStore dtextStore = ObjectPropertiesUtil.getTextStore(this, dependsOnObject, false);
                                            if (dtextStore == null) continue;
                                            Properties dtempProps = this.createProperties(dtextStore);
                                            String dependson12byte = dtempProps.getProperty("12byte");
                                            Logger.log(3, this, "Setting Dependency Properties - Using dependson12byte=" + dependson12byte);
                                            String starterString = owner12byte + ".dependson";
                                            if (this.checkExistence(starterString + "." + dependson12byte + ".fqid", tempProps)) {
                                                boolean incFound = false;
                                                int count = 1;
                                                while (!incFound) {
                                                    if (!this.checkExistence(starterString + Integer.toString(count) + "." + dependson12byte + ".fqid", tempProps)) {
                                                        starterString = starterString + Integer.toString(count);
                                                        incFound = true;
                                                        continue;
                                                    }
                                                    Logger.log(3, this, "Skipping already used property " + starterString + Integer.toString(count) + "." + dependson12byte + ".fqid");
                                                    ++count;
                                                }
                                            }
                                            if (this.runningAntTask) {
                                                Logger.log(3, this, "Setting Ant property " + starterString + "." + dependson12byte + ".fqid = " + dependsonFQID);
                                                this.getProject().setProperty(starterString + "." + dependson12byte + ".fqid", dependsonFQID);
                                                continue;
                                            }
                                            Logger.log(3, this, "Setting property in hash" + starterString + "." + dependson12byte + ".fqid = " + dependsonFQID);
                                            tempProps.setProperty(starterString + "." + dependson12byte + ".fqid", dependsonFQID);
                                        }
                                    }
                                }
                                Logger.log(3, this, "\nSince the include=\"" + this.include + "\" the private properites will be returned");
                                privateProps = tempProps;
                            }
                        }
                        if (this.configobjClassname != null) {
                            modeledPropertiesClassName = this.configobjClassname;
                            Logger.log(3, this, "\nconfigobj.classname was passed in directly by the SDW configobj.classname=" + modeledPropertiesClassName);
                        } else if (this.runningAntTask) {
                            modeledPropertiesClassName = this.getAntProperty(owner12byte + ".configobj.classname");
                            if (modeledPropertiesClassName != null && modeledPropertiesClassName.length() > 0) {
                                Logger.log(3, this, "\n" + owner12byte + "configobj.classname was found in the ant configuration.properties file " + owner12byte + ".configobj.classname=" + modeledPropertiesClassName);
                            } else {
                                modeledPropertiesClassName = null;
                            }
                        }
                        if (modeledPropertiesClassName == null && (modeledPropertiesClassName = publicProps.getProperty("configobj.classname")) != null) {
                            Logger.log(3, this, "configobj.classname found in the persisted public properties configobj.classname=" + modeledPropertiesClassName);
                        }
                        if (modeledPropertiesClassName != null && modeledPropertiesClassName.length() > 0) {
                            Logger.log(3, this, "\nSince a valid value for configobj.classname was found now calling getModeledProperties method in class " + modeledPropertiesClassName);
                            modeledProps = this.getModeledProperties(softwareComponents[i], modeledPropertiesClassName);
                            Logger.log(3, this, "\nBack in getmodeledproperties after retrieving modeled properties");
                            if (!this.gettingAll) {
                                this.addModeledProperties(softwareComponents[i], publicProps, privateProps, modeledProps);
                            }
                        } else {
                            Logger.log(3, this, "configobj.classname was not set to a valid value modeled properties classname was not be called");
                        }
                        Properties combinedProps = new Properties();
                        combinedProps.putAll((Map<?, ?>)publicProps);
                        if (privateProps != null) {
                            combinedProps.putAll((Map<?, ?>)privateProps);
                        }
                        if (outProperties != null) {
                            outProperties.put(softwareComponents[i].getFQID(), combinedProps);
                        } else {
                            this.saveProperties(combinedProps);
                        }
                        if (i != 0 || !addSpecificProperties) continue;
                        outProperties.put("PUBLIC", publicProps);
                        outProperties.put("PRIVATE", privateProps);
                        outProperties.put("MODELED", modeledProps);
                    }
                }
            }
            catch (Exception e) {
                valid = false;
                Logger.log(0, this, "Error getting text store properties: " + e.getMessage());
                Logger.log(0, this, "    Public Text Store: " + publicTextStore);
                Logger.log(0, this, "    Private Text Store: " + privateTextStore);
            }
        }
        return valid;
    }

    private boolean checkExistence(String s, Properties properties) {
        if (this.runningAntTask) {
            return this.getProject().getProperty(s) != null;
        }
        return properties.get(s) != null;
    }

    public HashMap getObjectList(String classIdentifier, String metadataType) {
        HashMap<String, String> returnHash = new HashMap<String, String>();
        if (metadataType == null) {
            metadataType = "SoftwareComponent";
        }
        try {
            int flags = 400;
            String xmlSelect = "<XMLSelect search=\"*[@ClassIdentifier='" + classIdentifier + "']\"/>";
            List objectsList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_mdObjectStore, this.m_repositoryFQID, metadataType, flags, xmlSelect);
            if (objectsList != null && objectsList.size() > 0) {
                int num = objectsList.size();
                for (int i = 0; i < num; ++i) {
                    Root root = (Root)objectsList.get(i);
                    returnHash.put(root.getFQID(), root.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnHash;
    }

    private void saveProperties(Properties properties) {
        String[] s;
        FilterSet f = null;
        Project project = this.getProject();
        if (properties == null || properties.size() == 0) {
            Logger.log(3, this, "No properties saved to Ant.");
            return;
        }
        if (this.filtersetrefid == null) {
            this.filtersetrefid = "configobj.filterset";
            if (!project.hasReference(this.filtersetrefid)) {
                FilterSet swcFilterSet = new FilterSet();
                project.addReference(this.filtersetrefid, (Object)swcFilterSet);
                Logger.log(3, this, "Created an empty FilterSet with filtersetrefid:" + this.filtersetrefid);
            }
        }
        Logger.log(3, this, "Using filtersetrefid:" + this.filtersetrefid);
        Reference r = new Reference(this.getProject(), this.filtersetrefid);
        f = (FilterSet)r.getReferencedObject();
        String prefixString = "";
        if (this.prefix != null) {
            prefixString = this.prefix;
            Logger.log(3, this, "Using prefix:" + this.prefix);
        }
        if ((s = properties.keySet().toArray(new String[0])) != null && s.length > 0) {
            for (int i = 0; i < s.length; ++i) {
                f.addFilter(prefixString + s[i], (String)properties.get(s[i]));
                if (project.getProperty(prefixString + s[i]) != null) continue;
                project.setNewProperty(prefixString + s[i], (String)properties.get(s[i]));
            }
            String string = f.getFilterHash().toString();
        }
    }

    private void addModeledProperties(Root root, Properties publicProps, Properties privateProps, Properties specialProperties) {
        if (publicProps == null) {
            Logger.log(0, this, "Null public properies hash during addModeledProperties.  No modeled properties added.");
        }
        if (specialProperties != null && specialProperties.size() > 0) {
            String[] s = specialProperties.keySet().toArray(new String[0]);
            try {
                if (s != null && s.length > 0) {
                    for (int i = 0; i < s.length; ++i) {
                        String value = (String)specialProperties.get(s[i]);
                        Logger.log(3, this, "Found modeled property.  name: " + s[i] + "=" + value);
                        if (value == null) {
                            Logger.log(3, this, "Null property value for " + s[i] + " not added.");
                            continue;
                        }
                        if (publicProps.containsKey(s[i])) {
                            publicProps.setProperty(s[i], value);
                            Logger.log(3, this, "Property " + s[i] + " added to public properties.");
                            continue;
                        }
                        if (privateProps != null) {
                            privateProps.setProperty(s[i], value);
                            Logger.log(3, this, "Property " + s[i] + " added to private properties.");
                            continue;
                        }
                        Logger.log(3, this, "Property " + s[i] + " not added.  Probably because private properties were not requested via include=\"all\"");
                    }
                }
            }
            catch (Exception e) {
                Logger.log(0, this, "Error retrieving modeled properties.  " + e.getMessage());
            }
        }
    }

    private Properties getModeledProperties(Root root, String modeledPropertiesClassName) {
        if (modeledPropertiesClassName == null || modeledPropertiesClassName.equals("")) {
            return null;
        }
        Properties specialProperties = null;
        try {
            ModeledPropertyInterface spi = ModeledPropertyFactory.getInstance(modeledPropertiesClassName, this);
            if (spi != null) {
                specialProperties = spi.getModeledProperties(root);
            }
        }
        catch (Exception e) {
            specialProperties = null;
        }
        return specialProperties;
    }

    private Properties createProperties(TextStore textStore) {
        Properties props = new Properties();
        try {
            String storedTextAttribute = textStore.getStoredText();
            StringReader reader = new StringReader(storedTextAttribute);
            PropertyMap myProperties = new PropertyMap();
            myProperties.load((Reader)reader);
            Iterator iterator = myProperties.getPropertyIterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                String propValue = myProperties.getProperty(propName);
                Logger.log(3, this, propName + "=" + propValue);
                props.put(propName, propValue);
            }
        }
        catch (Exception e) {
            Logger.log(0, this, "Error retrieving text from TextStore: " + e.getMessage());
            Logger.log(0, this, " TextStore: " + textStore);
            return null;
        }
        return props;
    }

    private TextStore getTextStore(Root root, boolean publicVersion) {
        return ObjectPropertiesUtil.getTextStore(this, root, publicVersion);
    }

    private HashMap combineHashMaps(HashMap map1, HashMap map2) {
        HashMap returnMap = new HashMap();
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        returnMap.putAll(map1);
        returnMap.putAll(map2);
        return returnMap;
    }

    public HashMap getSoftwareComponents() {
        HashMap<String, String> returnHash = new HashMap<String, String>();
        String metadataType = "SoftwareComponent";
        try {
            int flags = 400;
            String xmlSelect = "<XMLSelect search=\"*[@Id='" + this.fqid + "']\"/>";
            List objectsList = this.m_mdFactory.getOMIUtil().getMetadataObjects(this.m_repositoryFQID, metadataType, flags);
            if (objectsList != null && objectsList.size() > 0) {
                for (int i = 0; i < objectsList.size(); ++i) {
                    Root root = (Root)objectsList.get(i);
                    System.out.println(root.getName() + ":" + root.getFQID());
                    returnHash.put(root.getFQID(), root.getName());
                }
            }
        }
        catch (Exception e) {
            Logger.log(0, this, "Error finding software components: " + e.getMessage());
        }
        return returnHash;
    }
}

