/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.BackSlashToSlashPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.util.Map;

public final class CopyFile
extends TaskImpl {
    private static final char _OPTIONAL_FILE_INDICATOR = '*';
    private boolean _doMove;

    @Override
    protected boolean doWork() throws WebAppConfigException {
        String[] stDest;
        String sourceFiles = this.getValue("files", "sourceFiles");
        String destFileMacros = this.getValue("destination", "destFileMacros");
        PropertyMap installProps = this.readProperties(new BackSlashToSlashPropertyPreprocessor(), "propsFileName", null);
        this._doMove = this.getValueAsBool("move", false);
        String[] stSource = CommonUtils.parseCommaDelimitedInput(sourceFiles, true);
        if (stSource.length != (stDest = CommonUtils.parseCommaDelimitedInput(destFileMacros, true)).length) {
            throw new WebAppConfigException(ErrorHandling.generateFileNumberMismatchErrorMessage(this, sourceFiles, destFileMacros), null);
        }
        for (int i = 0; i < stDest.length; ++i) {
            String sourceFile = stSource[i];
            if (CommonUtils.isEmpty(sourceFile)) {
                throw new WebAppConfigException(ErrorHandling.generateEmptyParameterErrorMessage(this, i + 1, sourceFile), null);
            }
            String destFile = stDest[i];
            if (CommonUtils.isEmpty(destFile)) {
                throw new WebAppConfigException(ErrorHandling.generateEmptyParameterErrorMessage(this, i + 1, destFileMacros), null);
            }
            File source = null;
            if ('*' == sourceFile.charAt(0)) {
                source = new File(sourceFile.substring(1));
                if (!source.exists()) {
                    continue;
                }
            } else {
                source = new File(sourceFile);
            }
            for (Map.Entry entry : installProps.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                destFile = CommonUtils.replaceAll(destFile, key, value);
            }
            this.copyFile(source, new File(destFile));
        }
        return true;
    }

    private void copyFile(File inFile, File outFile) throws WebAppConfigException {
        CommonUtils.copyFile(this, inFile, outFile);
        if (this._doMove) {
            inFile.delete();
        }
    }
}

