/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;

public final class CheckPropertyValue
extends TaskImpl {
    public static final String ON_ERROR_WARN = "warn";
    public static final String ON_ERROR_FAIL = "fail";

    @Override
    protected boolean doWork() throws WebAppConfigException {
        String property = this.getValue("property");
        String value = this.getValue("value");
        boolean failOnError = true;
        if (this.paramExists("failonerror")) {
            failOnError = this.getValueAsBool("failonerror", true);
        } else if (this.paramExists("onerror")) {
            Logger.log(1, this, ErrorHandling.generateDeprecatedAttributeWarningMessage(this, "failonerror", "onerror"));
            String onerror = this.getValue("onerror");
            if (ON_ERROR_FAIL.equals(onerror)) {
                failOnError = true;
            } else if (ON_ERROR_WARN.equals(onerror)) {
                failOnError = false;
            } else {
                throw new WebAppConfigException(ErrorHandling.generateInvalidParameterValueErrorMessage(this, "onerror", onerror), null);
            }
        }
        boolean performCaseInsensitiveComparison = this.getValueAsBool("caseinsensitive", false);
        PropertyMap properties = this.readProperties(null, "files", null);
        if (properties.isEmpty()) {
            throw new WebAppConfigException(ErrorHandling.generateNoPropertiesFilesDefinedErrorMessage(this), null);
        }
        Object o = properties.get(property);
        if (null == o) {
            Logger.log(0, this, ErrorHandling.generateMissingPropertyErrorMessage(this, property, this.getPropertySource()));
            return !failOnError;
        }
        if (performCaseInsensitiveComparison ? value.equalsIgnoreCase((String)o) : value.equals(o)) {
            return true;
        }
        Logger.log(0, this, ErrorHandling.generatePropertyShouldHaveValue(this, property, (String)o, this.getPropertySource()));
        return !failOnError;
    }
}

