/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class BIDashmidProperties
implements ModeledPropertyInterface {
    Properties props = new Properties();

    @Override
    public Properties getModeledProperties(Root root) {
        SoftwareComponent configObject = (SoftwareComponent)root;
        this.getBIDProps(configObject);
        this.getEventGenProps(configObject);
        return this.props;
    }

    private void getBIDProps(SoftwareComponent configObject) {
        try {
            this.props.put("webapp.bidashmid.software.component.name", configObject.getName());
            DeployedComponent component = null;
            AssociationList components = configObject.getDeployedComponents();
            if (components != null && components.size() > 0) {
                for (int index = 0; index < components.size(); ++index) {
                    int cindex;
                    component = (DeployedComponent)components.get(index);
                    if (!"Registered SAS Application".equals(component.getName())) continue;
                    Object connection = null;
                    AssociationList connections = component.getSourceConnections();
                    if (connections == null || connections.size() <= 0 || (cindex = 0) >= connections.size() || !((connection = connections.get(cindex)) instanceof TCPIPConnection)) continue;
                    TCPIPConnection tcpip = (TCPIPConnection)connection;
                    this.props.put("midtier.bidashmid.protocol", tcpip.getCommunicationProtocol());
                    this.props.put("midtier.bidashmid.host", tcpip.getHostName());
                    this.props.put("midtier.bidashmid.port", Integer.toString(tcpip.getPort()));
                    this.props.put("midtier.bidashmid.url", tcpip.getCommunicationProtocol() + "://" + tcpip.getHostName() + ":" + tcpip.getPort() + "/");
                    this.props.put("webapp.bidashmid.contextroot", tcpip.getService().substring(1));
                }
            }
        }
        catch (RemoteException exception) {
            Logger.log(0, null, "EXCEPTION Occured : " + exception.getMessage());
        }
        catch (MdException exception) {
            Logger.log(0, null, "EXCEPTION Occured : " + exception.getMessage());
        }
    }

    private void getEventGenProps(SoftwareComponent configObject) {
        String eventGenName = null;
        try {
            eventGenName = configObject.getName() + " - Event Generator";
            MdStore mdStore = configObject.getObjectStore();
            String reposId = configObject.getRepositoryID();
            String mdType = "SoftwareComponent";
            String xmlSelect = "<XMLSELECT Search=\"@Name='" + eventGenName + "'\"/>";
            List found = BIDashmidProperties.findMetadataObjects(mdStore, reposId, mdType, xmlSelect);
            if (found != null && found.size() > 0) {
                SoftwareComponent eventGenComp = (SoftwareComponent)found.get(0);
                DeployedComponent component = null;
                AssociationList components = eventGenComp.getDeployedComponents();
                if (components != null && components.size() > 0) {
                    for (int index = 0; index < components.size(); ++index) {
                        int cindex;
                        component = (DeployedComponent)components.get(index);
                        if (!"Registered SAS Application".equals(component.getName())) continue;
                        Object connection = null;
                        AssociationList connections = component.getSourceConnections();
                        if (connections == null || connections.size() <= 0 || (cindex = 0) >= connections.size() || !((connection = connections.get(cindex)) instanceof TCPIPConnection)) continue;
                        TCPIPConnection tcpip = (TCPIPConnection)connection;
                        this.props.put("webapp.bidashmid.event_gen.contextroot", tcpip.getService().substring(1));
                    }
                }
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, "EXCEPTION Occured : " + e.getMessage());
        }
        catch (MdException e) {
            Logger.log(0, null, "EXCEPTION Occured : " + e.getMessage());
        }
    }

    public static List findMetadataObjects(MdStore mdObjectStore, String reposId, String mdType, String xmlSelect) throws MdException, RemoteException {
        MdFactoryImpl factory = new MdFactoryImpl();
        MdOMIUtil util = factory.getOMIUtil();
        List objectList = util.getMetadataObjectsSubset(mdObjectStore, reposId, mdType, 384, xmlSelect);
        factory.dispose();
        return objectList;
    }
}

