/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Repository;
import com.sas.app.VersionSpec;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class AddPickListToPath
extends TaskImpl {
    public static final String REFID = "refid";
    public static final String PATHELEMENT = "pathelement";
    private static final String _PLUGINS_FOLDER = "plugins";
    private static final String _ECLIPSE_FOLDER = "eclipse";
    private static final String _PATH_VARNAME = "sas.app.repository.path";
    private long _subtaskTimeout = 0L;
    private boolean debug = false;
    private Path path = null;
    private HashSet<Path> nestedPaths = new HashSet();

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRefId(String id) {
        this.path = (Path)this.getProject().getReference(id);
        if (this.path == null) {
            this.path = new Path(this.getProject());
            this.getProject().addReference(id, (Object)this.path);
            Logger.log(3, this, "Created new Path element for refid=" + id);
        } else {
            Logger.log(3, this, "Found existing Path element for refid=" + id);
        }
    }

    public void addPath(Path path) {
        this.nestedPaths.add(path);
    }

    @Override
    protected boolean doWork() throws WebAppConfigException {
        long startTime = System.currentTimeMillis();
        if (this.path == null) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(this, REFID), null);
        }
        for (Path nestedPath : this.nestedPaths) {
            this.path.add(nestedPath);
        }
        this.setPathVar();
        Plugin[] plugins = this.getPlugins(this.getRepository(), this.readPickList());
        if (plugins == null) {
            Logger.log(0, this, "No plugins found in the VJR repository!");
        } else {
            int i;
            HashSet<File> existingFiles = new HashSet<File>();
            String[] sPaths = this.path.list();
            for (i = 0; i < sPaths.length; ++i) {
                existingFiles.add(new File(sPaths[i]));
            }
            for (i = 0; i < plugins.length; ++i) {
                Plugin plugin = plugins[i];
                String pluginName = plugin.getName();
                VersionSpec pluginVersion = plugin.getVersion();
                URL[] urls = plugin.getBundleClasspath();
                for (int j = 0; j < urls.length; ++j) {
                    URL jarURL = urls[j];
                    File jarFile = this.toFile(jarURL);
                    if (existingFiles.contains(jarFile)) {
                        if (!this.debug) continue;
                        Logger.log(3, this, "File already exists for plugin '" + pluginName + "' with version '" + pluginVersion + "' with location '" + jarFile.getAbsolutePath() + "'");
                        continue;
                    }
                    Path pluginPath = new Path(this.getProject());
                    pluginPath.setLocation(jarFile);
                    this.path.add(pluginPath);
                    if (!this.debug) continue;
                    Logger.log(3, this, "Added file found for plugin '" + pluginName + "' with version '" + pluginVersion + "' with location '" + jarFile.getAbsolutePath() + "'");
                }
            }
        }
        if (this.debug) {
            Logger.log(3, this, "Finished execution in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        return true;
    }

    private void setPathVar() throws WebAppConfigException {
        if (!this.paramExists("source")) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(this, "source"), null);
        }
        String[] sources = CommonUtils.parsePath(this.getValue("source"));
        HashSet subfolders = new HashSet();
        for (int i = 0; i < sources.length; ++i) {
            String sourceFileName = sources[i];
            File vjrSource = new File(sourceFileName);
            CommonUtils.ensureDirectoryExists(this, vjrSource);
            subfolders.addAll(this.getAppropriateSubfolders(vjrSource));
        }
        if (subfolders.isEmpty()) {
            return;
        }
        int bufferLength = 0;
        int pathSeparatorLength = File.pathSeparator.length();
        Iterator iter = subfolders.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            bufferLength += path.length();
            if (!iter.hasNext()) continue;
            bufferLength += pathSeparatorLength;
        }
        StringBuffer builder = new StringBuffer(bufferLength);
        Iterator iter2 = subfolders.iterator();
        while (iter2.hasNext()) {
            builder.append(iter2.next());
            if (!iter2.hasNext()) continue;
            builder.append(File.pathSeparator);
        }
        System.setProperty(_PATH_VARNAME, builder.toString());
        Logger.log(3, this, "Setting sas.app.repository.path = " + builder.toString());
    }

    private Set getAppropriateSubfolders(File vjrSource) throws WebAppConfigException {
        HashSet subfolders = new HashSet();
        this.getSubfolders(subfolders, vjrSource);
        HashSet<String> appropriateSubFolders = new HashSet<String>();
        for (File file : subfolders) {
            File parent;
            if (!file.getName().equals(_PLUGINS_FOLDER) || !(parent = file.getParentFile()).getName().equals(_ECLIPSE_FOLDER)) continue;
            try {
                appropriateSubFolders.add(parent.getCanonicalPath());
            }
            catch (IOException e) {
                String message = ErrorHandling.generateCannotReadFileErrorMessage((Task)this, parent);
                throw new WebAppConfigException(message, e);
            }
        }
        return appropriateSubFolders;
    }

    private void getSubfolders(Set subfolders, File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isDirectory()) continue;
            subfolders.add(file);
            this.getSubfolders(subfolders, file);
        }
    }

    public final void setTimeoutSeconds(long timeout) {
        this._subtaskTimeout = 1000L * timeout;
    }

    private Plugin[] getPlugins(Repository repository, PickList picklist) throws WebAppConfigException {
        try {
            PluginFetcher fetcher = new PluginFetcher(this, repository, picklist, this._subtaskTimeout);
            fetcher.waitForThreadCompletion();
            return (Plugin[])fetcher.getReturnValue();
        }
        catch (Throwable e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotFindContentInVJRErrorMessage(this), e);
        }
    }

    private Repository getRepository() throws WebAppConfigException {
        try {
            RepositoryFetcher fetcher = new RepositoryFetcher(this, this._subtaskTimeout);
            fetcher.waitForThreadCompletion();
            return (Repository)fetcher.getReturnValue();
        }
        catch (Throwable e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotAccessVJRErrorMessage(this), e);
        }
    }

    private PickList readPickList() throws WebAppConfigException {
        String pickListFileName = this.getValue("picklist");
        Logger.log(3, this, "Using picklist '" + pickListFileName + "'");
        InputStream s = this.openPicklist(pickListFileName);
        try {
            PicklistReader reader = new PicklistReader(this, s, pickListFileName, this._subtaskTimeout);
            reader.waitForThreadCompletion();
            PickList pickList = (PickList)reader.getReturnValue();
            return pickList;
        }
        catch (Throwable t) {
            throw (WebAppConfigException)t;
        }
        finally {
            CommonUtils.closeInputStream(s);
        }
    }

    private InputStream openPicklist(String pickListFileName) throws WebAppConfigException {
        try {
            return new FileInputStream(pickListFileName);
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, pickListFileName), e);
        }
    }

    public File toFile(URL u) {
        if (u == null) {
            return null;
        }
        String temp = u.toString();
        if ("jar".equals(u.getProtocol())) {
            if (!temp.endsWith("!/") || !temp.startsWith("jar:")) {
                return null;
            }
            try {
                u = new URL(temp.substring(4, temp.length() - 2));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (!"file".equals(u.getProtocol())) {
            return null;
        }
        try {
            return this.canonical(new File(new URI(temp)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (temp.replace('\\', '/').startsWith("file://")) {
            return this.canonical(new File(temp.substring(5)));
        }
        return this.canonical(new File(u.getPath()));
    }

    public File canonical(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    private static class PluginFetcher
    extends WorkerThread {
        private Plugin[] _plugins = null;
        private Repository _repository;
        private PickList _picklist;

        PluginFetcher(Task task, Repository repository, PickList picklist, long timeout) {
            super(task, timeout);
            this._repository = repository;
            this._picklist = picklist;
        }

        @Override
        protected void acquireContent() throws WebAppConfigException {
            try {
                this._plugins = this._repository.find(this._picklist);
            }
            catch (Throwable e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotFindContentInVJRErrorMessage(this.getTask()), e);
            }
        }

        @Override
        protected Object getContent() {
            return this._plugins;
        }

        @Override
        protected WebAppConfigException processMissingContent() {
            return new WebAppConfigException(ErrorHandling.generateTimeoutReadingRepositoryErrorMessage(this.getTask()), null);
        }
    }

    private static class RepositoryFetcher
    extends WorkerThread {
        private Repository _repository = null;

        RepositoryFetcher(Task task, long timeout) {
            super(task, timeout);
        }

        @Override
        protected void acquireContent() throws WebAppConfigException {
            try {
                this._repository = Repository.getDefaultRepository();
            }
            catch (Throwable e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotAccessVJRErrorMessage(this.getTask()), e);
            }
        }

        @Override
        protected Object getContent() {
            return this._repository;
        }

        @Override
        protected WebAppConfigException processMissingContent() {
            return new WebAppConfigException(ErrorHandling.generateTimeoutAccessingRepositoryErrorMessage(this.getTask()), null);
        }
    }

    private static class PicklistReader
    extends WorkerThread {
        private InputStream _stream;
        private String _filename;
        private PickList _picklist;

        PicklistReader(Task task, InputStream stream, String filename, long timeout) {
            super(task, timeout);
            this._stream = stream;
            this._filename = filename;
            this._picklist = null;
        }

        @Override
        protected void acquireContent() throws WebAppConfigException {
            try {
                this._picklist = new PickList(this._stream);
            }
            catch (Throwable e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(this.getTask(), this._filename), e);
            }
        }

        @Override
        protected Object getContent() {
            return this._picklist;
        }

        @Override
        protected WebAppConfigException processMissingContent() {
            return new WebAppConfigException(ErrorHandling.generateTimeoutReadingPicklistErrorMessage(this.getTask()), null);
        }
    }

    private static abstract class WorkerThread
    implements Runnable {
        private static final long _DEFAULT_THREAD_TIMEOUT_MS = 30000L;
        private WebAppConfigException _error = null;
        private long _timeout;
        private Task _task;

        WorkerThread(Task task, long timeout) {
            this._timeout = timeout <= 0L ? 30000L : timeout;
            this._task = task;
        }

        final Task getTask() {
            return this._task;
        }

        final void waitForThreadCompletion() {
            new Thread(this).start();
            long now = System.currentTimeMillis();
            while (System.currentTimeMillis() - now < this._timeout && this.getContent() == null && this._error == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public final void run() {
            try {
                this.acquireContent();
            }
            catch (WebAppConfigException e) {
                this._error = e;
            }
        }

        final Object getReturnValue() throws WebAppConfigException {
            if (this._error != null) {
                throw this._error;
            }
            Object content = this.getContent();
            if (content == null) {
                throw this.processMissingContent();
            }
            return content;
        }

        protected abstract WebAppConfigException processMissingContent();

        protected abstract Object getContent();

        protected abstract void acquireContent() throws WebAppConfigException;
    }
}

