/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.propertymgmt;

import com.sas.tools.webappconfig.propertymgmt.AbstractPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.FileListPropertySource;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.Task;

public final class PropertyMaker {
    public PropertyMap processFiles(Task task, String definitions, AbstractPropertyPreprocessor preprocessor) throws WebAppConfigException {
        FileListPropertySource source = new FileListPropertySource(task, definitions, preprocessor);
        return new PropertyMap(false, source.resolveProperties(task));
    }

    public static void fixupIndirection(Task task, PropertyMap substitutions) throws WebAppConfigException {
        Iterator iter = substitutions.entrySet().iterator();
        while (iter.hasNext()) {
            PropertyMaker.fixupEntry(task, substitutions, (Map.Entry)iter.next());
        }
    }

    private static void fixupEntry(Task task, PropertyMap substitutions, Map.Entry entry) throws WebAppConfigException {
        Object value = entry.getValue();
        if (!substitutions.containsKey(value)) {
            return;
        }
        HashSet values = new HashSet();
        values.add(value);
        while (substitutions.containsKey(value)) {
            if (values.contains(value = substitutions.get(value))) {
                throw new WebAppConfigException(ErrorHandling.generateLoopInPropertiesErrorMessage(task, entry.getKey().toString()), null);
            }
            values.add(value);
        }
        entry.setValue(value);
    }
}

