/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.propertymgmt;

import com.sas.tools.webappconfig.propertymgmt.PropertySourceInterface;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public final class NamespaceRegistry {
    private static NamespaceRegistry _instance = new NamespaceRegistry();
    private Map _registryNoProject = new HashMap();
    private Map _registryMappedByProject = new HashMap();

    private NamespaceRegistry() {
    }

    public static NamespaceRegistry getInstance() {
        return _instance;
    }

    public void registerNamespace(Task task, String identifier, PropertySourceInterface source) {
        if (null == identifier || null == source) {
            throw new IllegalArgumentException();
        }
        Map registry = this.lookupRegistry(task);
        PropertySourceInterface oldSource = this.getFileList(identifier, registry);
        if (null != oldSource && !oldSource.equals(source)) {
            Logger.log(1, task, ErrorHandling.generateDuplicateNamespaceSourceErrorMessage(task, identifier, oldSource, source));
        }
        this.setFileList(identifier, source, registry);
    }

    private PropertySourceInterface getFileList(String identifier, Map registry) {
        return (PropertySourceInterface)registry.get(this.normalizeIdentifier(identifier));
    }

    private void setFileList(String identifier, PropertySourceInterface source, Map registry) {
        registry.put(this.normalizeIdentifier(identifier), source);
    }

    private Map lookupRegistry(Task task) {
        Map registry;
        Project project = null;
        if (null != task) {
            project = task.getProject();
        }
        if (null == project) {
            registry = this._registryNoProject;
        } else {
            registry = (Map)this._registryMappedByProject.get(project);
            if (null == registry) {
                registry = new HashMap();
                this._registryMappedByProject.put(project, registry);
            }
        }
        return registry;
    }

    private String normalizeIdentifier(String identifier) {
        String rval = identifier;
        while (rval.endsWith(".")) {
            rval = rval.substring(0, rval.length() - 1);
        }
        return rval;
    }

    public PropertySourceInterface getAssociatedFileList(Task task, String identifier) {
        if (null == identifier) {
            throw new IllegalArgumentException();
        }
        PropertySourceInterface source = this.getFileList(identifier, this.lookupRegistry(task));
        if (null == source) {
            source = ErrorHandling.generateNoPropertySourcesKnownErrorMessage(task);
        }
        return source;
    }
}

