/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.propertymgmt;

import com.sas.tools.webappconfig.propertymgmt.AbstractPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.AbstractPropertySourceImpl;
import com.sas.tools.webappconfig.propertymgmt.FilePropertySource;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import org.apache.tools.ant.Task;

public final class FileListPropertySource
extends AbstractPropertySourceImpl {
    public static final char OPTIONAL_FILE_INDICATOR = '*';
    private String _files;
    private boolean _initialized;

    public FileListPropertySource() {
        this._files = "";
        this._initialized = false;
    }

    @Override
    public void setFiles(String files) {
        this._files = files;
    }

    @Override
    public void initialize(Task task) throws WebAppConfigException {
        if (this._initialized) {
            return;
        }
        String[] filenames = CommonUtils.parseCommaDelimitedInput(this._files);
        for (int i = 0; i < filenames.length; ++i) {
            String filename = filenames[i];
            boolean isOptional = false;
            if ('*' == filename.charAt(0)) {
                isOptional = true;
                filename = filename.substring(1).trim();
            }
            FilePropertySource source = new FilePropertySource(filename, isOptional);
            this.addPropertySource(task, source);
        }
        this._initialized = true;
    }

    public FileListPropertySource(Task task, String definitions, AbstractPropertyPreprocessor preprocessor) throws WebAppConfigException {
        this._files = definitions;
        this.setPreprocessor(preprocessor);
        this.initialize(task);
    }

    @Override
    protected void doResolveMyProperties(Task task, PropertyMap map) throws WebAppConfigException {
    }

    @Override
    public String getMyDefinition() {
        return null;
    }

    @Override
    protected boolean doWork() throws WebAppConfigException {
        return false;
    }
}

